package ex1;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.Socket;
import java.util.logging.Level;
import java.util.logging.Logger;

public class EX1_Connection extends Thread {

    private DataInputStream in;
    private DataOutputStream out;
    private Socket clientSocket;
    
    public EX1_Connection(Socket aClientSocket) throws IOException
    {
        this.clientSocket = aClientSocket;
        this.in = new DataInputStream(clientSocket.getInputStream());
        this.out = new DataOutputStream(clientSocket.getOutputStream());
        this.start();        
    }
    
    @Override
    public void run(){
        String data;
        try {
            data = this.in.readUTF();
            this.out.writeUTF(data);
        } catch (IOException ex) {
            Logger.getLogger(EX1_Connection.class.getName()).log(Level.SEVERE, null, ex);
        }        
    }   
    
}
