/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.circuitconstructionkit.model.mna;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public interface LinearCircuitSolver {
    public ISolution solve(Circuit var1);

    public static class Battery
    extends Element {
        double voltage;

        Battery(int n, int n2, double d) {
            super(n, n2);
            this.voltage = d;
        }

        public String toString() {
            return "Battery{[" + this.node0 + "->" + this.node1 + "], " + "v=" + this.voltage + '}';
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Circuit {
        List<Battery> batteries;
        List<Resistor> resistors;
        List<CurrentSource> currentSources;

        Circuit(List<Battery> list, List<Resistor> list2, List<CurrentSource> list3) {
            this.batteries = list;
            this.resistors = list2;
            this.currentSources = list3;
        }

        public String toString() {
            return "Circuit{batteries=" + this.batteries + ", resistors=" + this.resistors + ", currentSources=" + this.currentSources + '}';
        }

        List<Element> getElements() {
            ArrayList<Element> arrayList = new ArrayList<Element>();
            arrayList.addAll(this.batteries);
            arrayList.addAll(this.resistors);
            arrayList.addAll(this.currentSources);
            return arrayList;
        }

        int getNodeCount() {
            return this.getNodeSet().size();
        }

        int getCurrentCount() {
            int n = 0;
            for (Resistor resistor : this.resistors) {
                if (resistor.resistance != 0.0) continue;
                ++n;
            }
            return this.batteries.size() + n;
        }

        HashSet<Integer> getNodeSet() {
            HashSet<Integer> hashSet = new HashSet<Integer>();
            for (Element element : this.getElements()) {
                hashSet.add(element.node0);
                hashSet.add(element.node1);
            }
            return hashSet;
        }
    }

    public static class CurrentSource
    extends Element {
        double current;

        public String toString() {
            return "CurrentSource{current=" + this.current + '}';
        }
    }

    public static abstract class Element {
        public final int node0;
        public final int node1;

        protected Element(int n, int n2) {
            this.node0 = n;
            this.node1 = n2;
        }

        boolean containsNode(int n) {
            return n == this.node0 || n == this.node1;
        }

        int getOpposite(int n) {
            if (n == this.node0) {
                return this.node1;
            }
            if (n == this.node1) {
                return this.node0;
            }
            throw new RuntimeException("node not found");
        }

        public String toString() {
            return "Element{node0=" + this.node0 + ", node1=" + this.node1 + '}';
        }
    }

    public static interface ISolution {
        public double getNodeVoltage(int var1);

        public double getCurrent(Element var1);
    }

    public static class Resistor
    extends Element {
        final double resistance;
        final double conductance;

        Resistor(int n, int n2, double d) {
            super(n, n2);
            this.resistance = d;
            this.conductance = 1.0 / d;
        }

        public String toString() {
            return "Resistor{[" + this.node0 + "->" + this.node1 + "], " + "r=" + this.resistance + '}';
        }
    }

    public static class Util {
        public static String mkString(List list, String string) {
            String string2 = "";
            for (int i = 0; i < list.size(); ++i) {
                string2 = string2 + list.get(i);
                if (i >= list.size() - 1) continue;
                string2 = string2 + string;
            }
            return string2;
        }
    }
}

