/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.circuitconstructionkit.model.analysis;

import edu.colorado.phet.circuitconstructionkit.model.Circuit;
import edu.colorado.phet.circuitconstructionkit.model.analysis.CircuitSolver;
import edu.colorado.phet.circuitconstructionkit.model.analysis.Path;
import edu.colorado.phet.circuitconstructionkit.model.components.Battery;
import edu.colorado.phet.circuitconstructionkit.model.components.Branch;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;

public class KirkhoffSolver
extends CircuitSolver {
    public static boolean debugging = false;

    public static class MatrixTable {
        Circuit circuit;
        Hashtable currentTable = new Hashtable();
        Hashtable voltageTable = new Hashtable();
        private int numFreeParameters;
        private Path[] loops;

        public MatrixTable(Circuit circuit) {
            Branch branch;
            int n;
            this.circuit = circuit;
            int n2 = 0;
            this.loops = Path.getLoops(circuit);
            for (n = 0; n < circuit.numBranches(); ++n) {
                branch = circuit.branchAt(n);
                if (!this.isLoopElementWithVoltageSource(branch)) continue;
                this.currentTable.put(new Integer(n), new Integer(n2++));
            }
            for (n = 0; n < circuit.numBranches(); ++n) {
                branch = circuit.branchAt(n);
                if (!this.isLoopElementWithVoltageSource(branch) || branch instanceof Battery) continue;
                this.voltageTable.put(new Integer(n), new Integer(n2++));
            }
            this.numFreeParameters = n2;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            ArrayList arrayList = new ArrayList();
            arrayList.addAll(this.currentTable.keySet());
            Collections.sort(arrayList);
            stringBuffer.append("MatrixTable: numFreeParameters=" + this.getNumFreeParameters() + ":\n");
            for (int i = 0; i < arrayList.size(); ++i) {
                Integer n = (Integer)arrayList.get(i);
                int n2 = this.getCurrentColumn(n);
                stringBuffer.append("column[" + n2 + "]=I" + n + "\n");
            }
            ArrayList arrayList2 = new ArrayList();
            arrayList2.addAll(this.voltageTable.keySet());
            Collections.sort(arrayList2);
            for (int i = 0; i < arrayList2.size(); ++i) {
                Integer n = (Integer)arrayList2.get(i);
                int n3 = this.getVoltageColumn(n);
                stringBuffer.append("column[" + n3 + "]=V" + n + "\n");
            }
            return stringBuffer.toString();
        }

        public Path[] getLoops() {
            return this.loops;
        }

        int getCurrentColumn(int n) {
            Integer n2 = new Integer(n);
            if (this.currentTable.containsKey(n2)) {
                return (Integer)this.currentTable.get(n2);
            }
            return -1;
        }

        int getVoltageColumn(int n) {
            Integer n2 = new Integer(n);
            if (this.voltageTable.containsKey(n2)) {
                return (Integer)this.voltageTable.get(new Integer(n));
            }
            return -1;
        }

        public boolean isLoopElementWithVoltageSource(Branch branch) {
            for (int i = 0; i < this.loops.length; ++i) {
                Path path = this.loops[i];
                if (!path.containsBranch(branch) || !path.containsVoltageSource()) continue;
                return true;
            }
            return false;
        }

        public int getNumFreeParameters() {
            return this.numFreeParameters;
        }
    }
}

