/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.circuitconstructionkit.view.piccolo.lifelike;

import edu.colorado.phet.circuitconstructionkit.model.CCKModel;
import edu.colorado.phet.circuitconstructionkit.model.components.Branch;
import edu.colorado.phet.circuitconstructionkit.model.components.Wire;
import edu.colorado.phet.circuitconstructionkit.view.CCKLookAndFeel;
import edu.colorado.phet.circuitconstructionkit.view.piccolo.BranchNode;
import edu.colorado.phet.circuitconstructionkit.view.piccolo.CircuitInteractionModel;
import edu.colorado.phet.circuitconstructionkit.view.piccolo.WirePopupMenu;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.common.piccolophet.event.CursorHandler;
import edu.colorado.phet.common.piccolophet.event.PopupMenuHandler;
import edu.umd.cs.piccolo.event.PBasicInputEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.nodes.PPath;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Shape;

public class WireNode
extends BranchNode {
    private Wire wire;
    private PPath wirePPath;
    private PPath wireHighlightPPath;
    private CircuitInteractionModel circuitInteractionModel;
    private double highlightStrokeWidth = 0.49184999999999995;
    private SimpleObserver wireObserver = new SimpleObserver(){

        public void update() {
            WireNode.this.update();
        }
    };

    public WireNode(final CCKModel cCKModel, final Wire wire, Component component) {
        this.wire = wire;
        this.circuitInteractionModel = new CircuitInteractionModel(cCKModel);
        this.wireHighlightPPath = new PPath();
        this.wireHighlightPPath.setPaint(CCKLookAndFeel.HIGHLIGHT_COLOR);
        this.wireHighlightPPath.setStroke(null);
        this.wirePPath = new PPath();
        this.setWirePaint(CCKLookAndFeel.COPPER);
        this.wirePPath.setStroke(null);
        this.addChild(this.wireHighlightPPath);
        this.addChild(this.wirePPath);
        this.addInputEventListener(new CursorHandler());
        this.addInputEventListener(new PBasicInputEventHandler(){

            public void mouseDragged(PInputEvent pInputEvent) {
                WireNode.this.circuitInteractionModel.translate(wire, pInputEvent.getPositionRelativeTo(WireNode.this.getParent()));
            }

            public void mouseReleased(PInputEvent pInputEvent) {
                WireNode.this.circuitInteractionModel.dropBranch(wire);
            }

            public void mousePressed(PInputEvent pInputEvent) {
                if (pInputEvent.isControlDown()) {
                    wire.setSelected(!wire.isSelected());
                } else {
                    cCKModel.getCircuit().setSelection(wire);
                }
            }
        });
        wire.addObserver(this.wireObserver);
        this.update();
        this.addInputEventListener(new PopupMenuHandler(component, new WirePopupMenu(cCKModel, wire)));
    }

    public void setHighlightStrokeWidth(double d) {
        this.highlightStrokeWidth = d;
        this.update();
    }

    public void setWirePaint(Color color) {
        this.wirePPath.setPaint(color);
    }

    private void update() {
        this.wireHighlightPPath.setVisible(this.wire.isSelected());
        Shape shape = new BasicStroke((float)this.highlightStrokeWidth, 0, 0).createStrokedShape(this.wire.getLine());
        this.wireHighlightPPath.setPathTo(shape);
        this.wirePPath.setPathTo(this.wire.getShape());
    }

    public Branch getBranch() {
        return this.wire;
    }

    public void delete() {
        this.wire.removeObserver(this.wireObserver);
    }
}

