/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.circuitconstructionkit.view.piccolo;

import edu.colorado.phet.circuitconstructionkit.model.Electron;
import edu.colorado.phet.circuitconstructionkit.view.CCKImageSuite;
import edu.colorado.phet.circuitconstructionkit.view.piccolo.ClipFactory;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.common.piccolophet.PhetPNode;
import edu.umd.cs.piccolo.nodes.PImage;
import edu.umd.cs.piccolo.util.PPaintContext;
import java.awt.Shape;
import java.awt.geom.Area;
import java.awt.image.BufferedImage;
import java.io.IOException;

public class ElectronNode
extends PhetPNode {
    private Electron electron;
    private ClipFactory clipFactory;
    private PImage pImage;
    private static BufferedImage image = null;
    private Shape clip;
    private double SCALE = 0.00625;

    public ElectronNode(Electron electron, ClipFactory clipFactory) {
        this.electron = electron;
        this.clipFactory = clipFactory;
        this.pImage = new PImage(image);
        this.addChild(this.pImage);
        electron.addObserver(new SimpleObserver(){

            public void update() {
                ElectronNode.this.update();
            }
        });
        this.pImage.scale(this.SCALE);
        this.setPickable(false);
        this.setChildrenPickable(false);
        this.update();
    }

    public void update() {
        this.pImage.setOffset(this.electron.getPosition());
        this.pImage.translate(-this.pImage.getFullBounds().getWidth() / 2.0 / this.SCALE, -this.pImage.getFullBounds().getHeight() / 2.0 / this.SCALE);
        this.clip = this.clipFactory.getClip(this);
    }

    protected void paint(PPaintContext pPaintContext) {
        if (this.clip != null) {
            Shape shape = pPaintContext.getGraphics().getClip();
            Area area = new Area(shape);
            area.subtract(new Area(this.clip));
            pPaintContext.pushClip(area);
        }
    }

    protected void paintAfterChildren(PPaintContext pPaintContext) {
        if (this.clip != null) {
            pPaintContext.popClip(null);
        }
    }

    public Electron getElectron() {
        return this.electron;
    }

    static {
        try {
            image = CCKImageSuite.getInstance().getParticleImage();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }
}

