/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.circuitconstructionkit.model.components;

import edu.colorado.phet.circuitconstructionkit.model.CircuitChangeListener;
import edu.colorado.phet.circuitconstructionkit.model.CompositeCircuitChangeListener;
import edu.colorado.phet.circuitconstructionkit.model.CurrentVoltListener;
import edu.colorado.phet.circuitconstructionkit.model.Electron;
import edu.colorado.phet.circuitconstructionkit.model.Junction;
import edu.colorado.phet.circuitconstructionkit.model.SimpleObservableDebug;
import edu.colorado.phet.common.phetcommon.math.ImmutableVector2D;
import edu.colorado.phet.common.phetcommon.math.Vector2D;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import java.awt.Shape;
import java.awt.geom.Point2D;
import java.util.ArrayList;

public abstract class Branch
extends SimpleObservableDebug {
    private double resistance = 1.0E-8;
    private Junction startJunction;
    private Junction endJunction;
    private CompositeCircuitChangeListener circuitChangeListeners = new CompositeCircuitChangeListener();
    private ArrayList<CurrentVoltListener> ivListeners = new ArrayList();
    private boolean isSelected = false;
    private boolean kirkhoffEnabled = true;
    private ArrayList<FlameListener> flameListeners = new ArrayList();
    private boolean isOnFire = false;
    private boolean editing = false;
    private String name;
    private double current;
    private double mnaCurrent;
    private double voltageDrop;
    private double mnaVoltageDrop;
    private static int indexCounter = 0;
    SimpleObserver so = new SimpleObserver(){

        public void update() {
            Branch.this.notifyObservers();
        }
    };

    protected Branch(CircuitChangeListener circuitChangeListener) {
        this.name = Branch.toLabel(indexCounter++);
        this.setResistance(1.0E-8);
        this.addKirkhoffListener(circuitChangeListener);
    }

    public Branch(CircuitChangeListener circuitChangeListener, Junction junction, Junction junction2) {
        this(circuitChangeListener);
        this.startJunction = junction;
        this.endJunction = junction2;
        junction.addObserver(this.so);
        junction2.addObserver(this.so);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean isSelected() {
        return this.isSelected;
    }

    public void setSelected(boolean bl) {
        this.isSelected = bl;
        this.notifyObservers();
    }

    public void removeFlameListener(FlameListener flameListener) {
        this.flameListeners.remove(flameListener);
    }

    public void addFlameListener(FlameListener flameListener) {
        this.flameListeners.add(flameListener);
    }

    public void addCurrentVoltListener(CurrentVoltListener currentVoltListener) {
        this.ivListeners.add(currentVoltListener);
    }

    public void removeCurrentVoltListener(CurrentVoltListener currentVoltListener) {
        this.ivListeners.remove(currentVoltListener);
    }

    public void addKirkhoffListener(CircuitChangeListener circuitChangeListener) {
        this.circuitChangeListeners.addCircuitChangeListener(circuitChangeListener);
    }

    public void addObserver(SimpleObserver simpleObserver) {
        super.addObserver(simpleObserver);
    }

    public String toString() {
        return "Branch_" + this.name + "[" + this.startJunction.getLabel() + "," + this.endJunction.getLabel() + "] <" + this.getClass() + ">";
    }

    public ImmutableVector2D getDirectionVector() {
        return new ImmutableVector2D(this.startJunction.getPosition(), this.endJunction.getPosition());
    }

    public double getResistance() {
        return this.resistance;
    }

    public double getCurrent() {
        return this.current;
    }

    public double getVoltageDrop() {
        return this.voltageDrop;
    }

    public void setResistance(double d) {
        if (d < 0.0) {
            throw new RuntimeException("Resistance was < 0, value=" + d);
        }
        if (d < 1.0E-8) {
            throw new RuntimeException("Resistance was less than MIN, res=" + d + ", min=" + 1.0E-8);
        }
        if (d != this.resistance) {
            this.resistance = d;
            this.notifyObservers();
            this.fireKirkhoffChange();
        }
    }

    public void notifyObservers() {
        ArrayList<Electron.Observer> arrayList = new ArrayList<Electron.Observer>();
        for (int i = 0; i < this.getObserverList().size(); ++i) {
            Electron.Observer observer;
            SimpleObserver simpleObserver = this.getObserverList().get(i);
            if (!(simpleObserver instanceof Electron.Observer) || !(observer = (Electron.Observer)simpleObserver).isDeleted()) continue;
            arrayList.add(observer);
        }
        for (Electron.Observer observer : arrayList) {
            this.removeObserver(observer);
        }
        super.notifyObservers();
    }

    public void setCurrent(double d) {
        block6: {
            boolean bl;
            if (this.current != d) {
                this.current = d;
                this.notifyObservers();
                for (CurrentVoltListener iterator : this.ivListeners) {
                    iterator.currentOrVoltageChanged(this);
                }
            }
            boolean bl2 = bl = Math.abs(d) > 10.0;
            if (bl == this.isOnFire) break block6;
            this.isOnFire = bl;
            if (this.isOnFire) {
                for (FlameListener flameListener : this.flameListeners) {
                    flameListener.flameFinished();
                }
            } else {
                for (FlameListener flameListener : this.flameListeners) {
                    flameListener.flameStarted();
                }
            }
        }
    }

    public void setVoltageDrop(double d) {
        if (this.voltageDrop != d) {
            this.voltageDrop = d;
            this.notifyObservers();
            for (int i = 0; i < this.ivListeners.size(); ++i) {
                this.ivListeners.get(i).currentOrVoltageChanged(this);
            }
        }
    }

    public void fireKirkhoffChange() {
        if (this.kirkhoffEnabled) {
            this.circuitChangeListeners.circuitChanged();
        }
    }

    public Point2D getStartPoint() {
        return this.startJunction.getPosition();
    }

    public Point2D getEndPoint() {
        return this.endJunction.getPosition();
    }

    public Junction getStartJunction() {
        return this.startJunction;
    }

    public Junction getEndJunction() {
        return this.endJunction;
    }

    public boolean hasJunction(Junction junction) {
        return this.endJunction == junction || this.startJunction == junction;
    }

    public Junction opposite(Junction junction) {
        if (this.startJunction == junction) {
            return this.endJunction;
        }
        if (this.endJunction == junction) {
            return this.startJunction;
        }
        throw new RuntimeException("No such junction: " + junction);
    }

    public void setStartJunction(Junction junction) {
        if (this.startJunction != null) {
            this.startJunction.removeObserver(this.so);
        }
        this.startJunction = junction;
        this.startJunction.addObserver(this.so);
    }

    public void setEndJunction(Junction junction) {
        if (this.endJunction != null) {
            this.endJunction.removeObserver(this.so);
        }
        this.endJunction = junction;
        this.endJunction.addObserver(this.so);
    }

    public void replaceJunction(Junction junction, Junction junction2) {
        if (junction == this.startJunction) {
            this.setStartJunction(junction2);
        } else if (junction == this.endJunction) {
            this.setEndJunction(junction2);
        } else {
            throw new RuntimeException("No such junction.");
        }
    }

    public double getLength() {
        return this.getStartJunction().getDistance(this.getEndJunction());
    }

    public Point2D getPosition(double d) {
        if (this.getLength() == 0.0) {
            return this.getStartJunction().getPosition();
        }
        ImmutableVector2D immutableVector2D = new Vector2D(this.getStartJunction().getPosition(), this.getEndJunction().getPosition()).getInstanceOfMagnitude(d);
        return immutableVector2D.getDestination(this.getStartJunction().getPosition());
    }

    private static String toLabel(int n) {
        char c = 'a';
        c = (char)(c + n % 26);
        int n2 = n / 26;
        String string = "";
        string = n2 == 0 ? "" + c : "" + c + "_" + n2;
        return string;
    }

    public String getName() {
        return this.name;
    }

    public boolean containsScalarLocation(double d) {
        return d >= 0.0 && d <= this.getLength();
    }

    public double getAngle() {
        return new ImmutableVector2D(this.getStartJunction().getPosition(), this.getEndJunction().getPosition()).getAngle();
    }

    public void delete() {
        this.removeAllObservers();
        this.endJunction.removeObserver(this.so);
        this.startJunction.removeObserver(this.so);
    }

    public void setKirkhoffEnabled(boolean bl) {
        this.kirkhoffEnabled = bl;
    }

    public abstract Shape getShape();

    public boolean isOnFire() {
        return this.isOnFire;
    }

    public boolean isEditing() {
        return this.editing;
    }

    public void setEditing(boolean bl) {
        if (this.editing != bl) {
            this.editing = bl;
            this.notifyObservers();
        }
    }

    public void setMNACurrent(double d) {
        this.mnaCurrent = d;
    }

    public double getMNACurrent() {
        return this.mnaCurrent;
    }

    public void setMNAVoltageDrop(double d) {
        this.mnaVoltageDrop = d;
    }

    public double getMNAVoltageDrop() {
        return this.mnaVoltageDrop;
    }

    public static interface FlameListener {
        public void flameStarted();

        public void flameFinished();
    }
}

