/*
 * Decompiled with CFR 0.152.
 */
package jason.util;

import jason.asSemantics.Agent;
import jason.asSyntax.Literal;
import jason.asSyntax.Plan;
import jason.asSyntax.PlanBody;
import jason.asSyntax.Trigger;
import jason.util.asl2xml;
import java.util.HashSet;

public class asl2dot
extends asl2xml {
    public static void main(String[] args) throws Exception {
        if (args.length != 1) {
            System.err.println("The asl code file must be informed");
            System.exit(1);
        }
        new asl2dot().run(args[0]);
    }

    @Override
    public String transform(Agent ag) throws Exception {
        StringBuilder so = new StringBuilder();
        so.append("// dot file used to generate goals graph\n");
        so.append("// run: dot -Tpdf <theoutput> -o goals.pdf\n");
        so.append("digraph goals {\n");
        so.append("    rankdir=BT;\n\n");
        HashSet<String> done = new HashSet<String>();
        for (Plan p : ag.getPL()) {
            if (p.getTrigger().getType() != Trigger.TEType.achieve) continue;
            String ps = p.getTrigger().getLiteral().getFunctor();
            if (!done.contains(ps)) {
                done.add(ps);
                so.append("    " + ps + ";\n");
            }
            for (PlanBody b = p.getBody(); b != null; b = b.getBodyNext()) {
                String bs;
                String e2;
                if (b.getBodyType() != PlanBody.BodyType.achieve && b.getBodyType() != PlanBody.BodyType.achieveNF || done.contains(e2 = (bs = ((Literal)b.getBodyTerm()).getFunctor()) + ps)) continue;
                done.add(e2);
                so.append("    " + bs + " -> " + ps + ";\n");
            }
        }
        so.append("}\n");
        return so.toString();
    }
}

