/*
 * Decompiled with CFR 0.152.
 */
package jason.stdlib;

import jason.JasonException;
import jason.asSemantics.DefaultInternalAction;
import jason.asSemantics.InternalAction;
import jason.asSemantics.TransitionSystem;
import jason.asSemantics.Unifier;
import jason.asSyntax.NumberTerm;
import jason.asSyntax.NumberTermImpl;
import jason.asSyntax.Term;
import java.util.Iterator;

public class range
extends DefaultInternalAction {
    private static InternalAction singleton = null;

    public static InternalAction create() {
        if (singleton == null) {
            singleton = new range();
        }
        return singleton;
    }

    @Override
    public int getMinArgs() {
        return 3;
    }

    @Override
    public int getMaxArgs() {
        return 4;
    }

    @Override
    protected void checkArguments(Term[] args) throws JasonException {
        super.checkArguments(args);
        if (!args[1].isNumeric()) {
            throw JasonException.createWrongArgument(this, "second parameter ('" + args[1] + "') must be a number!");
        }
        if (!args[2].isNumeric()) {
            throw JasonException.createWrongArgument(this, "third parameter ('" + args[2] + "') must be a number!");
        }
        if (args.length == 4 && !args[3].isNumeric()) {
            throw JasonException.createWrongArgument(this, "fourth parameter ('" + args[3] + "') must be a number!");
        }
    }

    @Override
    public Object execute(TransitionSystem ts, final Unifier un, Term[] args) throws Exception {
        this.checkArguments(args);
        final int start = (int)((NumberTerm)args[1]).solve();
        final int end2 = (int)((NumberTerm)args[2]).solve();
        final int step = args.length == 4 ? (int)((NumberTerm)args[3]).solve() : 1;
        if (!args[0].isVar()) {
            int vl = (int)((NumberTerm)args[0]).solve();
            return vl >= start && vl <= end2;
        }
        final Term var = args[0];
        return new Iterator<Unifier>(){
            int vl;
            {
                this.vl = start - step;
            }

            @Override
            public boolean hasNext() {
                if (step > 0) {
                    return this.vl + step <= end2;
                }
                return this.vl + step >= end2;
            }

            @Override
            public Unifier next() {
                this.vl += step;
                Unifier c = un.clone();
                c.unifiesNoUndo(var, new NumberTermImpl(this.vl));
                return c;
            }

            @Override
            public void remove() {
            }
        };
    }
}

