/*
 * Decompiled with CFR 0.152.
 */
package jason.stdlib;

import jason.JasonException;
import jason.asSemantics.Circumstance;
import jason.asSemantics.DefaultInternalAction;
import jason.asSemantics.Event;
import jason.asSemantics.IntendedMeans;
import jason.asSemantics.Intention;
import jason.asSemantics.InternalAction;
import jason.asSemantics.TransitionSystem;
import jason.asSemantics.Unifier;
import jason.asSyntax.Atom;
import jason.asSyntax.InternalActionLiteral;
import jason.asSyntax.Literal;
import jason.asSyntax.ObjectTermImpl;
import jason.asSyntax.PlanBody;
import jason.asSyntax.PlanBodyImpl;
import jason.asSyntax.PlanLibrary;
import jason.asSyntax.Structure;
import jason.asSyntax.Term;
import jason.asSyntax.Trigger;
import jason.stdlib.drop_intention;
import jason.util.Pair;
import java.util.HashSet;
import java.util.Set;

public class fork
extends DefaultInternalAction {
    private static InternalAction singleton = null;
    private static final Structure joinS = new Structure(".join");
    public static final Atom aAnd = new Atom("and");
    public static final Atom aOr = new Atom("or");

    public static InternalAction create() {
        if (singleton == null) {
            singleton = new fork();
        }
        return singleton;
    }

    @Override
    public Term[] prepareArguments(Literal body, Unifier un) {
        return body.getTermsArray();
    }

    @Override
    public int getMinArgs() {
        return 2;
    }

    @Override
    protected void checkArguments(Term[] args) throws JasonException {
        super.checkArguments(args);
        if (!(args[0] instanceof Atom)) {
            throw JasonException.createWrongArgument(this, "first argument must be 'and' or 'or'.");
        }
    }

    @Override
    public boolean suspendIntention() {
        return true;
    }

    @Override
    public boolean canBeUsedInContext() {
        return false;
    }

    @Override
    public Object execute(TransitionSystem ts, Unifier un, Term[] args) throws Exception {
        this.checkArguments(args);
        ForkData fd = new ForkData(((Atom)args[0]).equals(aAnd));
        Intention currentInt = ts.getC().getSelectedIntention();
        for (int iPlans = 1; iPlans < args.length; ++iPlans) {
            ForkIntention i = new ForkIntention(currentInt, fd);
            fd.addIntention(i);
            i.pop();
            IntendedMeans im = (IntendedMeans)currentInt.peek().clone();
            InternalActionLiteral joinL = new InternalActionLiteral(joinS, ts.getAg());
            joinL.addTerm(new ObjectTermImpl(fd));
            PlanBodyImpl joinPB = new PlanBodyImpl(PlanBody.BodyType.internalAction, (Term)joinL);
            joinPB.setBodyNext(im.getCurrentStep().getBodyNext());
            PlanBody whattoadd = (PlanBody)args[iPlans].clone();
            whattoadd.add(joinPB);
            whattoadd.setAsBodyTerm(false);
            im.insertAsNextStep(whattoadd);
            im.removeCurrentStep();
            i.push(im);
            ts.getC().addIntention(i);
        }
        return true;
    }

    class ForkIntention
    extends Intention {
        ForkData fd;
        int forkPoint;

        ForkIntention(Intention i, ForkData fd) {
            i.copyTo(this);
            this.forkPoint = i.size();
            this.fd = fd;
        }

        @Override
        public boolean dropGoal(Trigger te, Unifier un) {
            boolean r = super.dropGoal(te, un);
            if (r && this.size() < this.forkPoint) {
                if (this.fd.toFinish > 0) {
                    this.fd.toFinish = 0;
                    return true;
                }
                this.clearIM();
                return false;
            }
            return r;
        }

        @Override
        public void fail(Circumstance c) {
            if (this.size() >= this.forkPoint && this.fd.isAnd) {
                for (Intention ifo : this.fd.intentions) {
                    drop_intention.dropInt(c, ifo);
                }
            }
        }

        @Override
        public Pair<Event, Integer> findEventForFailure(Trigger tevent, PlanLibrary pl, Circumstance c) {
            Pair<Event, Integer> p = super.findEventForFailure(tevent, pl, c);
            if (p.getSecond() <= this.forkPoint) {
                if (this.fd.isAnd) {
                    this.fd.intentions.remove(this);
                    for (Intention ifo : this.fd.intentions) {
                        drop_intention.dropInt(c, ifo);
                    }
                } else {
                    return new Pair<Object, Integer>(null, p.getSecond());
                }
            }
            return p;
        }
    }

    class ForkData {
        boolean isAnd = true;
        Set<Intention> intentions = new HashSet<Intention>();
        int toFinish = 0;

        public ForkData(boolean isAnd) {
            this.isAnd = isAnd;
        }

        public void addIntention(Intention i) {
            this.intentions.add(i);
            ++this.toFinish;
        }

        public String toString() {
            StringBuilder s = new StringBuilder("fork data");
            if (this.isAnd) {
                s.append(" (and) ");
            } else {
                s.append(" (or) ");
            }
            s.append(" intentions = { ");
            for (Intention i : this.intentions) {
                s.append(" " + i.getId());
            }
            s.append(" } waiting for " + this.toFinish);
            return s.toString();
        }
    }
}

