/*
 * Decompiled with CFR 0.152.
 */
package jason.stdlib;

import jason.JasonException;
import jason.asSemantics.DefaultInternalAction;
import jason.asSemantics.TransitionSystem;
import jason.asSemantics.Unifier;
import jason.asSyntax.ListTerm;
import jason.asSyntax.StringTerm;
import jason.asSyntax.StringTermImpl;
import jason.asSyntax.Structure;
import jason.asSyntax.Term;
import jason.mas2j.ClassParameters;
import jason.runtime.RuntimeServicesInfraTier;
import jason.runtime.Settings;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class create_agent
extends DefaultInternalAction {
    @Override
    public int getMinArgs() {
        return 1;
    }

    @Override
    public int getMaxArgs() {
        return 3;
    }

    @Override
    protected void checkArguments(Term[] args) throws JasonException {
        super.checkArguments(args);
        if (args.length > 1 && !args[1].isString()) {
            throw JasonException.createWrongArgument(this, "second argument must be a string");
        }
        if (args.length == 3 && !args[2].isList()) {
            throw JasonException.createWrongArgument(this, "third argument must be a list");
        }
    }

    @Override
    public Object execute(TransitionSystem ts, Unifier un, Term[] args) throws Exception {
        this.checkArguments(args);
        String name = this.getName(args);
        String source = this.getSource(args);
        List<String> agArchClasses = this.getAgArchClasses(args);
        String agClass = null;
        ClassParameters bbPars = null;
        if (args.length > 2) {
            for (Term t : (ListTerm)args[2]) {
                if (!t.isStructure()) continue;
                Structure s = (Structure)t;
                if (s.getFunctor().equals("beliefBaseClass")) {
                    bbPars = new ClassParameters(this.testString(s.getTerm(0)));
                    continue;
                }
                if (!s.getFunctor().equals("agentClass")) continue;
                agClass = this.testString(s.getTerm(0)).toString();
            }
        }
        RuntimeServicesInfraTier rs = ts.getUserAgArch().getRuntimeServices();
        name = rs.createAgent(name, source, agClass, agArchClasses, bbPars, this.getSettings(ts));
        rs.startAgent(name);
        if (args[0].isVar()) {
            return un.unifies(new StringTermImpl(name), args[0]);
        }
        return true;
    }

    protected Settings getSettings(TransitionSystem ts) {
        return new Settings();
    }

    protected String getName(Term[] args) {
        String name = args[0].isString() ? ((StringTerm)args[0]).getString() : args[0].toString();
        if (args[0].isVar()) {
            name = name.substring(0, 1).toLowerCase() + name.substring(1);
        }
        return name;
    }

    protected String getSource(Term[] args) throws JasonException {
        String source = null;
        if (args.length > 1) {
            File fSource = new File(((StringTerm)args[1]).getString());
            if (!(fSource.exists() || (fSource = new File("src/asl/" + ((StringTerm)args[1]).getString())).exists() || (fSource = new File("src/agt/" + ((StringTerm)args[1]).getString())).exists())) {
                throw new JasonException("The source file " + source + " was not found!");
            }
            source = fSource.getAbsolutePath();
        }
        return source;
    }

    protected List<String> getAgArchClasses(Term[] args) {
        ArrayList<String> agArchClasses = new ArrayList<String>();
        if (args.length > 2) {
            for (Term t : (ListTerm)args[2]) {
                Structure s;
                if (!t.isStructure() || !(s = (Structure)t).getFunctor().equals("agentArchClass")) continue;
                agArchClasses.add(this.testString(s.getTerm(0)).toString());
            }
        }
        return agArchClasses;
    }

    private Structure testString(Term t) {
        if (t.isStructure()) {
            return (Structure)t;
        }
        if (t.isString()) {
            return Structure.parse(((StringTerm)t).getString());
        }
        return null;
    }
}

