/*
 * Decompiled with CFR 0.152.
 */
package jason.runtime;

import jason.infra.MASLauncherInfraTier;
import jason.mas2j.MAS2JProject;
import jason.mas2j.parser.mas2j;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;

public class RunJasonProject {
    static MASLauncherInfraTier launcher;

    public static void main(String[] args) {
        mas2j parser;
        MAS2JProject project = new MAS2JProject();
        if (args.length == 0) {
            System.out.println("usage must be:");
            System.out.println("      java " + RunJasonProject.class.getName() + " <MAS2j Project File>");
            return;
        }
        String name = args[0];
        System.err.println("reading from file " + name + " ...");
        try {
            parser = new mas2j(new FileInputStream(name));
        }
        catch (FileNotFoundException e2) {
            System.err.println("file \"" + name + "\" not found.");
            return;
        }
        try {
            File file = new File(name);
            project = parser.mas();
            project.setProjectFile(file);
            project.setDirectory(file.getAbsoluteFile().getParentFile().getAbsolutePath());
            System.out.println("file " + name + " parsed successfully!\n");
            launcher = project.getInfrastructureFactory().createMASLauncher();
            launcher.setProject(project);
            launcher.writeScripts(false, false);
            new Thread((Runnable)launcher, "MAS-Launcher").start();
        }
        catch (Exception e3) {
            System.err.println("parsing errors found... \n" + e3);
        }
    }

    public MASLauncherInfraTier getLauncher() {
        return launcher;
    }
}

