/*
 * Decompiled with CFR 0.152.
 */
package jason.runtime;

import jason.infra.centralised.BaseCentralisedMAS;
import jason.runtime.MASConsoleLogHandler;
import jason.runtime.OutputStreamAdapter;
import java.awt.BorderLayout;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.LogManager;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.text.DefaultCaret;

public class MASConsoleGUI {
    protected static MASConsoleGUI masConsole = null;
    public static String isTabbedPropField = MASConsoleLogHandler.class.getName() + ".tabbed";
    private boolean isTabbed = false;
    protected Map<String, JTextArea> agsTextArea = new HashMap<String, JTextArea>();
    protected JTabbedPane tabPane;
    protected JFrame frame = null;
    protected JTextArea output;
    protected JPanel pBt = null;
    protected JPanel pcenter;
    protected OutputStreamAdapter out;
    protected boolean inPause = false;

    public static MASConsoleGUI get() {
        if (masConsole == null) {
            masConsole = new MASConsoleGUI("MAS Console");
        }
        return masConsole;
    }

    public static boolean hasConsole() {
        return masConsole != null;
    }

    protected MASConsoleGUI(String title) {
        this.initFrame(title);
        this.initMainPanel();
        this.initOutput();
        this.initButtonPanel();
    }

    protected void initFrame(String title) {
        this.frame = new JFrame(title);
        this.frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e2) {
                MASConsoleGUI.this.close();
            }
        });
        this.frame.getContentPane().setLayout(new BorderLayout());
        int h = 600;
        int w = (int)((double)h * 1.618);
        this.frame.setBounds((int)((double)h * 0.618), 20, w, h);
    }

    protected void initMainPanel() {
        String tabbed = LogManager.getLogManager().getProperty(isTabbedPropField);
        if (tabbed != null && tabbed.equals("true")) {
            this.isTabbed = true;
        }
        this.pcenter = new JPanel(new BorderLayout());
        if (this.isTabbed) {
            this.tabPane = new JTabbedPane(2);
            this.pcenter.add("Center", this.tabPane);
        }
        this.frame.getContentPane().add("Center", this.pcenter);
    }

    protected void initOutput() {
        this.output = new JTextArea();
        this.output.setEditable(false);
        ((DefaultCaret)this.output.getCaret()).setUpdatePolicy(2);
        if (this.isTabbed) {
            this.tabPane.add("common", new JScrollPane(this.output));
        } else {
            this.pcenter.add("Center", new JScrollPane(this.output));
        }
    }

    public void cleanConsole() {
        this.output.setText("");
    }

    protected void initButtonPanel() {
        this.pBt = new JPanel();
        this.pBt.setLayout(new FlowLayout(1));
        this.frame.getContentPane().add("South", this.pBt);
        JButton btClean = new JButton("Clean", new ImageIcon(BaseCentralisedMAS.class.getResource("/images/clear.gif")));
        btClean.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MASConsoleGUI.this.cleanConsole();
            }
        });
        this.addButton(btClean);
    }

    public void setTitle(String s) {
        this.frame.setTitle(s);
    }

    public JFrame getFrame() {
        return this.frame;
    }

    public void addButton(JButton jb) {
        this.pBt.add(jb);
        this.pBt.revalidate();
    }

    public synchronized void setPause(boolean b) {
        this.inPause = b;
        this.notifyAll();
    }

    synchronized void waitNotPause() {
        try {
            while (this.inPause) {
                this.wait();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean isTabbed() {
        return this.isTabbed;
    }

    public boolean isPause() {
        return this.inPause;
    }

    public void append(String s) {
        this.append(null, s);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void append(final String agName, String s) {
        try {
            JTextArea ta;
            if (!this.frame.isVisible()) {
                this.frame.setVisible(true);
            }
            if (this.inPause) {
                this.waitNotPause();
            }
            if (this.isTabbed && agName != null) {
                ta = this.agsTextArea.get(agName);
                if (ta == null) {
                    ta = new JTextArea();
                    ta.setEditable(false);
                    ((DefaultCaret)ta.getCaret()).setUpdatePolicy(2);
                    final JTextArea cta = ta;
                    SwingUtilities.invokeAndWait(new Runnable(){

                        @Override
                        public void run() {
                            MASConsoleGUI.this.agsTextArea.put(agName, cta);
                            MASConsoleGUI.this.tabPane.add(agName, new JScrollPane(cta));
                        }
                    });
                }
                if (ta != null) {
                    if (ta.getDocument().getLength() > 100000) {
                        ta.setText("");
                    }
                    ta.append(s);
                }
            }
            ta = this.output;
            synchronized (ta) {
                try {
                    if (this.output.getDocument().getLength() > 60000) {
                        this.cleanConsole();
                    }
                    this.output.append(s);
                }
                catch (IllegalArgumentException e2) {
                    // empty catch block
                }
            }
        }
        catch (Exception e3) {
            try {
                PrintWriter out = new PrintWriter(new FileWriter("e_r_r_o_r.txt"));
                out.write("Error that can not be printed in the MAS Console!\n" + e3.toString() + "\n");
                e3.printStackTrace(out);
                out.close();
            }
            catch (IOException e1) {
                // empty catch block
            }
        }
    }

    public void close() {
        this.setPause(false);
        if (masConsole != null && MASConsoleGUI.masConsole.frame != null) {
            MASConsoleGUI.masConsole.frame.setVisible(false);
        }
        if (this.out != null) {
            this.out.restoreOriginalOut();
        }
        try {
            if (BaseCentralisedMAS.getRunner() != null) {
                FileWriter f = new FileWriter(".stop___MAS");
                f.write(32);
                f.close();
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        masConsole = null;
    }

    public void setAsDefaultOut() {
        this.out = new OutputStreamAdapter(this, null);
        this.out.setAsDefaultOut();
    }
}

