/*
 * Decompiled with CFR 0.152.
 */
package jason.mas2j;

import jason.JasonException;
import jason.asSyntax.directives.DirectiveProcessor;
import jason.environment.Environment;
import jason.infra.InfrastructureFactory;
import jason.mas2j.AgentParameters;
import jason.mas2j.ClassParameters;
import jason.mas2j.parser.mas2j;
import jason.util.Config;
import java.io.File;
import java.io.FileReader;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MAS2JProject {
    public static final String EXT = "mas2j";
    public static final String AS_EXT = "asl";
    private static Logger logger = Logger.getLogger(MAS2JProject.class.getName());
    private String soc = "default";
    private ClassParameters envClass = null;
    private ClassParameters controlClass = null;
    private ClassParameters infrastructure = new ClassParameters("Centralised");
    private String projectDir = ".";
    private File projectFile = null;
    private List<AgentParameters> agents = new ArrayList<AgentParameters>();
    private List<String> classpaths = new ArrayList<String>();
    private List<String> sourcepaths = new ArrayList<String>();
    private Map<String, String> directiveClasses = new HashMap<String, String>();
    private InfrastructureFactory infraFac = null;

    public static MAS2JProject parse(String file) {
        try {
            mas2j parser = new mas2j(new FileReader(file));
            return parser.mas();
        }
        catch (Exception e2) {
            logger.log(Level.SEVERE, "Error parsing mas2j file.", e2);
            return null;
        }
    }

    public void setupDefault() {
        if (this.envClass == null) {
            this.envClass = new ClassParameters(Environment.class.getName());
        }
    }

    public void setDirectory(String d) {
        if (d != null) {
            this.projectDir = d;
            if (this.projectDir.endsWith(File.separator) || this.projectDir.endsWith("/")) {
                this.projectDir = this.projectDir.substring(0, this.projectDir.length() - 1);
            }
        }
    }

    public String getDirectory() {
        return this.projectDir;
    }

    public void setProjectFile(File f) {
        this.projectFile = f;
    }

    public File getProjectFile() {
        return this.projectFile;
    }

    public void setInfrastructure(ClassParameters infra) {
        this.infrastructure = infra;
    }

    public ClassParameters getInfrastructure() {
        return this.infrastructure;
    }

    public boolean isJade() {
        return this.getInfrastructure().getClassName().equals("Jade");
    }

    public void setEnvClass(ClassParameters e2) {
        this.envClass = e2;
    }

    public ClassParameters getEnvClass() {
        return this.envClass;
    }

    public void setSocName(String s) {
        this.soc = s;
    }

    public String getSocName() {
        return this.soc;
    }

    public void setControlClass(ClassParameters sControl) {
        this.controlClass = sControl;
    }

    public ClassParameters getControlClass() {
        return this.controlClass;
    }

    public void initAgMap() {
        this.agents = new ArrayList<AgentParameters>();
    }

    public void addAgent(AgentParameters a) {
        this.agents.add(a);
    }

    public AgentParameters getAg(String name) {
        for (AgentParameters a : this.agents) {
            if (!a.name.equals(name)) continue;
            return a;
        }
        return null;
    }

    public List<AgentParameters> getAgents() {
        return this.agents;
    }

    public Set<File> getAllASFiles() {
        HashSet<File> files = new HashSet<File>();
        for (AgentParameters agp : this.agents) {
            if (agp.asSource == null) continue;
            files.add(agp.asSource);
        }
        return files;
    }

    public void fixAgentsSrc(String urlPrefix) {
        List<String> srcpath = this.getSourcePaths();
        for (AgentParameters agp : this.agents) {
            if (agp.asSource == null) continue;
            agp.fixSrc(srcpath, urlPrefix);
        }
    }

    public void addClassPath(String cp) {
        if (cp.startsWith("\"")) {
            cp = cp.substring(1, cp.length() - 1);
        }
        this.classpaths.add(cp);
    }

    public List<String> getClassPaths() {
        return this.classpaths;
    }

    public void addSourcePath(String cp) {
        if (cp.startsWith("\"")) {
            cp = cp.substring(1, cp.length() - 1);
        }
        this.sourcepaths.add(cp);
    }

    public List<String> getSourcePaths() {
        ArrayList<String> r = new ArrayList<String>();
        if (this.sourcepaths.isEmpty()) {
            r.add(this.getDirectory());
        }
        for (String p : this.sourcepaths) {
            if (p.startsWith(".") || p.startsWith("/") || p.charAt(1) == ':') {
                r.add(p);
                continue;
            }
            r.add(this.getDirectory() + "/" + p);
        }
        return r;
    }

    public void removeSourcePath(int index) {
        this.sourcepaths.remove(index);
    }

    public void addDirectiveClass(String id, ClassParameters classname) {
        this.directiveClasses.put(id, classname.getClassName());
    }

    public Map<String, String> getDirectiveClasses() {
        return this.directiveClasses;
    }

    public void registerDirectives() {
        if (this.directiveClasses != null) {
            for (String id : this.directiveClasses.keySet()) {
                try {
                    DirectiveProcessor.registerDirective(id, Class.forName(this.directiveClasses.get(id)));
                }
                catch (Exception e2) {
                    logger.log(Level.SEVERE, "Error registering directives " + this.directiveClasses, e2);
                }
            }
        }
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append("/*\n");
        s.append("    Jason Project\n\n");
        s.append("    -- created on " + new SimpleDateFormat("MMMM dd, yyyy").format(new Date()) + "\n");
        s.append("*/\n\n");
        s.append("MAS " + this.getSocName() + " {\n");
        s.append("   infrastructure: " + this.getInfrastructure() + "\n\n");
        if (this.getEnvClass() != null && !this.getEnvClass().getClassName().equals(Environment.class.getName())) {
            s.append("   environment: " + this.getEnvClass());
            if (this.envClass.getHost() != null) {
                s.append(" at \"" + this.envClass.getHost() + "\"");
            }
            s.append("\n\n");
        }
        if (this.getControlClass() != null) {
            s.append("   executionControl: " + this.getControlClass());
            if (this.getControlClass().getHost() != null) {
                s.append(" at \"" + this.getControlClass().getHost() + "\"");
            }
            s.append("\n\n");
        }
        s.append("   agents:\n");
        Iterator<AgentParameters> i = this.agents.iterator();
        while (i.hasNext()) {
            s.append("       " + i.next());
            s.append("\n");
        }
        s.append("\n");
        if (this.directiveClasses.size() > 0) {
            s.append("   directives: ");
            for (String d : this.directiveClasses.keySet()) {
                s.append(d + "=" + this.directiveClasses.get(d) + "; ");
            }
            s.append("\n");
        }
        if (this.classpaths.size() > 0) {
            s.append("   classpath: ");
            for (String cp : this.classpaths) {
                s.append("\"" + cp + "\"; ");
            }
            s.append("\n");
        }
        if (this.sourcepaths.size() > 0) {
            s.append("   aslSourcePath: ");
            for (String cp : this.sourcepaths) {
                s.append("\"" + cp + "\"; ");
            }
            s.append("\n");
        }
        s.append("}");
        return s.toString();
    }

    public InfrastructureFactory getInfrastructureFactory() throws JasonException {
        if (this.infraFac == null) {
            try {
                String facClass = Config.get().getInfrastructureFactoryClass(this.infrastructure.getClassName());
                this.infraFac = (InfrastructureFactory)Class.forName(facClass).newInstance();
            }
            catch (Exception e2) {
                throw new JasonException("The project's infrastructure ('" + this.infrastructure.getClassName() + "') is not well configured! \n" + e2);
            }
        }
        return this.infraFac;
    }
}

