/*
 * Decompiled with CFR 0.152.
 */
package jason.infra.repl;

import jason.infra.repl.ReplAg;
import java.awt.BorderLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.logging.LogRecord;
import java.util.logging.StreamHandler;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class ReplAgGUI
extends ReplAg {
    JTextField command = null;
    JTextArea output = null;
    JFrame frame;
    static int lastPos = 30;

    @Override
    public void initAg() {
        super.initAg();
        this.initGui();
        this.initLogger();
    }

    void initLogger() {
        this.getTS().getLogger().addHandler(new StreamHandler(){

            @Override
            public synchronized void publish(LogRecord l) {
                ReplAgGUI.this.output.append(l.getMessage() + "\n");
                ReplAgGUI.this.output.setCaretPosition(ReplAgGUI.this.output.getDocument().getLength());
            }
        });
    }

    void initGui() {
        Font font = new Font("Courier", 0, 14);
        this.command = new JTextField(40);
        this.command.setFont(font);
        this.command.setToolTipText("Type a Jason operation here.");
        this.command.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                ReplAgGUI.this.execCmd(ReplAgGUI.this.command.getText().trim());
            }
        });
        this.output = new JTextArea(5, 50);
        this.output.setFont(font);
        this.output.setEditable(false);
        this.output.setText("Example of operations you can type:\n   +bel; !goal; .add_plan({+!goal <- .print(ok) }); !!goal; \n   .send(bob,tell,hello);\n");
        this.output.append("   ?bel(A); .findall(X,bel(X),L); \n");
        this.output.append("   .mi // to open mind inspector\n");
        this.output.append("   .verbose(2) // to show debug messages\n");
        this.output.append("   .clear // clean console\n");
        this.output.append("\nYou can add more agents using the button 'new REPL ag' in MAS Console.");
        this.output.append("\n");
        this.frame = new JFrame(".::  REPL Interface for " + this.getTS().getUserAgArch().getAgName() + "  ::.");
        this.frame.getContentPane().setLayout(new BorderLayout());
        this.frame.getContentPane().add("North", this.command);
        this.frame.getContentPane().add("Center", new JScrollPane(this.output));
        this.frame.pack();
        int h = 200;
        int w = (int)((double)(h * 2) * 1.618);
        this.frame.setBounds((int)((double)h * 0.618), 20, w, h);
        this.frame.setLocation(lastPos, 200 + lastPos);
        lastPos += 50;
        this.frame.setVisible(true);
    }

    @Override
    public void clear() {
        this.output.setText("");
    }

    @Override
    public void print(String s) {
        this.output.append(s + "\n");
    }

    @Override
    public void stopAg() {
        this.frame.setVisible(false);
        super.stopAg();
    }
}

