/*
 * Decompiled with CFR 0.152.
 */
package jason.infra.jade;

import jade.core.AID;
import jade.core.behaviours.CyclicBehaviour;
import jade.domain.DFService;
import jade.domain.FIPAAgentManagement.DFAgentDescription;
import jade.domain.FIPAAgentManagement.ServiceDescription;
import jade.domain.FIPAException;
import jade.lang.acl.ACLMessage;
import jason.asSemantics.Message;
import jason.asSyntax.Literal;
import jason.asSyntax.Structure;
import jason.environment.Environment;
import jason.environment.EnvironmentInfraTier;
import jason.infra.centralised.BaseCentralisedMAS;
import jason.infra.jade.JadeAg;
import jason.infra.jade.JadeRuntimeServices;
import jason.infra.jade.RunJadeMAS;
import jason.mas2j.ClassParameters;
import jason.mas2j.MAS2JProject;
import jason.mas2j.parser.mas2j;
import jason.runtime.RuntimeServicesInfraTier;
import java.io.FileReader;
import java.util.Arrays;
import java.util.Collection;
import java.util.logging.Level;

public class JadeEnvironment
extends JadeAg
implements EnvironmentInfraTier {
    public static String actionOntology = "AS-actions";
    public static String perceptionOntology = "AS-perception";
    private Environment userEnv;

    @Override
    public void setup() {
        BaseCentralisedMAS.getRunner().setupLogger();
        this.logger.fine("Starting JadeEnvironment.");
        try {
            Object[] args = this.getArguments();
            if (args != null && args.length > 0) {
                if (args[0] instanceof ClassParameters) {
                    ClassParameters ep = (ClassParameters)args[0];
                    this.userEnv = (Environment)Class.forName(ep.getClassName()).newInstance();
                    this.userEnv.setEnvironmentInfraTier(this);
                    this.userEnv.init(ep.getParametersArray());
                } else if (args[0].toString().equals("j-project")) {
                    if (args.length != 2) {
                        this.logger.log(Level.SEVERE, "To start the environment from .mas2j file, you have to provide as parameters: (j-project <file.mas2j>)");
                        return;
                    }
                    mas2j parser = new mas2j(new FileReader(args[1].toString()));
                    MAS2JProject project = parser.mas();
                    project.setupDefault();
                    ClassParameters ep = project.getEnvClass();
                    this.userEnv = (Environment)Class.forName(ep.getClassName()).newInstance();
                    this.userEnv.setEnvironmentInfraTier(this);
                    this.userEnv.init(ep.getParametersArray());
                    this.logger.fine("Init of environmend, via j-project, done.");
                } else {
                    this.userEnv = (Environment)Class.forName(args[0].toString()).newInstance();
                    this.userEnv.setEnvironmentInfraTier(this);
                    String[] envArgs = new String[args.length - 1];
                    for (int i = 1; i < args.length; ++i) {
                        envArgs[i - 1] = args[1].toString();
                    }
                    this.userEnv.init(envArgs);
                }
            } else {
                this.logger.warning("Using default environment.");
                this.userEnv = new Environment();
                this.userEnv.setEnvironmentInfraTier(this);
            }
        }
        catch (Exception e2) {
            this.logger.log(Level.SEVERE, "Error in setup Jade Environment", e2);
        }
        DFAgentDescription dfa = new DFAgentDescription();
        dfa.setName(this.getAID());
        ServiceDescription vc = new ServiceDescription();
        vc.setType("jason");
        vc.setName(RunJadeMAS.environmentName);
        dfa.addServices(vc);
        try {
            DFService.register(this, dfa);
        }
        catch (FIPAException e3) {
            this.logger.log(Level.SEVERE, "Error registering environment in DF", e3);
        }
        this.logger.fine("Registry in the DF done.");
        try {
            this.addBehaviour(new CyclicBehaviour(){
                ACLMessage m;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void action() {
                    this.m = JadeEnvironment.this.receive();
                    if (this.m == null) {
                        this.block(1000L);
                    } else if (this.m.getContent().equals("getPercepts")) {
                        ACLMessage r;
                        block13: {
                            r = this.m.createReply();
                            r.setPerformative(7);
                            try {
                                Collection<Literal> percepts = JadeEnvironment.this.userEnv.getPercepts(this.m.getSender().getLocalName());
                                if (percepts == null) {
                                    r.setContent("nothing_new");
                                    break block13;
                                }
                                Collection<Literal> collection = percepts;
                                synchronized (collection) {
                                    r.setContent(percepts.toString());
                                }
                            }
                            catch (Exception e2) {
                                e2.printStackTrace();
                            }
                        }
                        JadeEnvironment.this.send(r);
                    } else if (this.m.getOntology().equals(actionOntology)) {
                        ACLMessage r = this.m.createReply();
                        r.setPerformative(7);
                        try {
                            Structure action = Structure.parse(this.m.getContent());
                            JadeEnvironment.this.userEnv.scheduleAction(this.m.getSender().getLocalName(), action, r);
                        }
                        catch (Exception e3) {
                            e3.printStackTrace();
                        }
                    }
                }
            });
            this.logger.fine("setup done");
        }
        catch (Exception e4) {
            this.logger.log(Level.SEVERE, "Error starting agent", e4);
        }
    }

    @Override
    protected void takeDown() {
        if (this.userEnv != null) {
            this.userEnv.stop();
        }
    }

    @Override
    public void actionExecuted(String agName, Structure actTerm, boolean success, Object infraData) {
        try {
            ACLMessage r = (ACLMessage)infraData;
            if (success) {
                r.setContent("ok");
            } else {
                r.setContent("error");
            }
            this.send(r);
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    @Override
    public void informAgsEnvironmentChanged(String ... agents) {
        if (agents.length == 0) {
            this.broadcast(new Message("tell", null, null, "environmentChanged"));
        } else {
            this.informAgsEnvironmentChanged(Arrays.asList(agents));
        }
    }

    @Override
    public void informAgsEnvironmentChanged(Collection<String> agentsToNotify) {
        try {
            if (agentsToNotify == null) {
                this.informAgsEnvironmentChanged(new String[0]);
            } else {
                ACLMessage m = new ACLMessage(7);
                m.setContent("environmentChanged");
                for (String ag : agentsToNotify) {
                    m.addReceiver(new AID(ag, false));
                }
                this.send(m);
            }
        }
        catch (Exception e2) {
            this.logger.log(Level.SEVERE, "Error sending notifyEvents ", e2);
        }
    }

    @Override
    public RuntimeServicesInfraTier getRuntimeServices() {
        return new JadeRuntimeServices(this.getContainerController(), this);
    }
}

