/*
 * Decompiled with CFR 0.152.
 */
package jason.infra.centralised;

import jason.JasonException;
import jason.asSemantics.Agent;
import jason.asSyntax.directives.DirectiveProcessor;
import jason.asSyntax.directives.Include;
import jason.bb.DefaultBeliefBase;
import jason.control.ExecutionControlGUI;
import jason.environment.Environment;
import jason.infra.centralised.BaseCentralisedMAS;
import jason.infra.centralised.CentralisedAgArch;
import jason.infra.centralised.CentralisedAgArchAsynchronous;
import jason.infra.centralised.CentralisedAgArchForPool;
import jason.infra.centralised.CentralisedEnvironment;
import jason.infra.centralised.CentralisedExecutionControl;
import jason.infra.centralised.KillAgentGUI;
import jason.infra.centralised.RConf;
import jason.infra.centralised.StartNewAgentGUI;
import jason.infra.components.CircumstanceListenerComponents;
import jason.infra.repl.ReplAgGUI;
import jason.mas2j.AgentParameters;
import jason.mas2j.ClassParameters;
import jason.mas2j.MAS2JProject;
import jason.mas2j.parser.ParseException;
import jason.mas2j.parser.mas2j;
import jason.runtime.MASConsoleGUI;
import jason.runtime.MASConsoleLogFormatter;
import jason.runtime.MASConsoleLogHandler;
import jason.runtime.Settings;
import jason.util.Config;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.ConsoleHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class RunCentralisedMAS
extends BaseCentralisedMAS {
    private JButton btDebug;
    private Set<CentralisedAgArch> sleepingAgs;
    private ExecutorService executor;
    private ExecutorService executorSense;
    private ExecutorService executorDeliberate;
    private ExecutorService executorAct;
    private Boolean runningFinish = false;

    public RunCentralisedMAS() {
        runner = this;
    }

    @Override
    public boolean hasDebugControl() {
        return this.btDebug != null;
    }

    @Override
    public void enableDebugControl() {
        this.btDebug.setEnabled(true);
    }

    public static void main(String[] args) throws JasonException {
        RunCentralisedMAS r = new RunCentralisedMAS();
        runner = r;
        r.init(args);
        r.create();
        r.start();
        r.waitEnd();
        r.finish();
    }

    protected int init(String[] args) {
        String projectFileName = null;
        if (args.length < 1) {
            if (RunCentralisedMAS.class.getResource("/default.mas2j") != null) {
                projectFileName = "default.mas2j";
                readFromJAR = true;
                Config.get(false);
            }
        } else {
            projectFileName = args[0];
        }
        this.setupLogger();
        if (args.length >= 2 && args[1].equals("-debug")) {
            debug = true;
            Logger.getLogger("").setLevel(Level.FINE);
        }
        for (Handler h : Logger.getLogger("").getHandlers()) {
            if (!h.getClass().toString().equals(MASConsoleLogHandler.class.toString())) continue;
            MASConsoleGUI.get().getFrame().setVisible(true);
            MASConsoleGUI.get().setAsDefaultOut();
        }
        int errorCode = 0;
        try {
            if (projectFileName != null) {
                InputStream inProject;
                if (readFromJAR) {
                    inProject = RunCentralisedMAS.class.getResource("/default.mas2j").openStream();
                    urlPrefix = "ClassResource:/";
                } else {
                    URL file;
                    try {
                        file = new URL(projectFileName);
                        if (projectFileName.startsWith("jar")) {
                            urlPrefix = projectFileName.substring(0, projectFileName.indexOf("!") + 1) + "/";
                        }
                    }
                    catch (Exception e2) {
                        file = new URL("file:" + projectFileName);
                    }
                    inProject = file.openStream();
                }
                mas2j parser = new mas2j(inProject);
                project = parser.mas();
            } else {
                project = new MAS2JProject();
            }
            project.setupDefault();
            project.registerDirectives();
            ((Include)DirectiveProcessor.getDirective("include")).setSourcePath(project.getSourcePaths());
            project.fixAgentsSrc(urlPrefix);
            if (MASConsoleGUI.hasConsole()) {
                MASConsoleGUI.get().setTitle("MAS Console - " + project.getSocName());
                this.createButtons();
            }
            errorCode = 0;
        }
        catch (FileNotFoundException e1) {
            logger.log(Level.SEVERE, "File " + projectFileName + " not found!");
            errorCode = 2;
        }
        catch (ParseException e3) {
            logger.log(Level.SEVERE, "Error parsing file " + projectFileName + "!", e3);
            errorCode = 3;
        }
        catch (Exception e4) {
            logger.log(Level.SEVERE, "Error!?: ", e4);
            errorCode = 4;
        }
        System.out.flush();
        System.err.flush();
        if (!MASConsoleGUI.hasConsole() && errorCode != 0) {
            System.exit(errorCode);
        }
        return errorCode;
    }

    protected void create() throws JasonException {
        this.createEnvironment();
        this.createAgs();
        this.createController();
    }

    protected void start() {
        this.startAgs();
        this.startSyncMode();
    }

    @Override
    public synchronized void setupLogger() {
        if (readFromJAR) {
            Handler[] hs = Logger.getLogger("").getHandlers();
            for (int i = 0; i < hs.length; ++i) {
                Logger.getLogger("").removeHandler(hs[i]);
            }
            MASConsoleLogHandler h = new MASConsoleLogHandler();
            h.setFormatter(new MASConsoleLogFormatter());
            Logger.getLogger("").addHandler(h);
            Logger.getLogger("").setLevel(Level.INFO);
        } else if (new File("logging.properties").exists()) {
            try {
                LogManager.getLogManager().readConfiguration(new FileInputStream("logging.properties"));
            }
            catch (Exception e2) {
                System.err.println("Error setting up logger:" + e2);
            }
        } else {
            try {
                if (runner != null) {
                    LogManager.getLogManager().readConfiguration(this.getDefaultLogProperties());
                } else {
                    LogManager.getLogManager().readConfiguration(RunCentralisedMAS.class.getResource("/templates/logging.properties").openStream());
                }
            }
            catch (Exception e3) {
                System.err.println("Error setting up logger:" + e3);
                e3.printStackTrace();
            }
        }
    }

    protected InputStream getDefaultLogProperties() throws IOException {
        return RunCentralisedMAS.class.getResource("/templates/logging.properties").openStream();
    }

    protected void setupDefaultConsoleLogger() {
        Handler[] hs = Logger.getLogger("").getHandlers();
        for (int i = 0; i < hs.length; ++i) {
            Logger.getLogger("").removeHandler(hs[i]);
        }
        ConsoleHandler h = new ConsoleHandler();
        h.setFormatter(new MASConsoleLogFormatter());
        Logger.getLogger("").addHandler(h);
        Logger.getLogger("").setLevel(Level.INFO);
    }

    protected void createButtons() {
        this.createStopButton();
        this.createPauseButton();
        this.btDebug = new JButton("Debug", new ImageIcon(RunCentralisedMAS.class.getResource("/images/debug.gif")));
        this.btDebug.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RunCentralisedMAS.this.changeToDebugMode();
                RunCentralisedMAS.this.btDebug.setEnabled(false);
                if (BaseCentralisedMAS.runner.control != null) {
                    try {
                        BaseCentralisedMAS.runner.control.getUserControl().setRunningCycle(false);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        });
        if (debug) {
            this.btDebug.setEnabled(false);
        }
        MASConsoleGUI.get().addButton(this.btDebug);
        JButton btShowSrc = new JButton("Sources", new ImageIcon(RunCentralisedMAS.class.getResource("/images/list.gif")));
        btShowSrc.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RunCentralisedMAS.showProjectSources(BaseCentralisedMAS.project);
            }
        });
        MASConsoleGUI.get().addButton(btShowSrc);
        JButton btStartAg = new JButton("New agent", new ImageIcon(RunCentralisedMAS.class.getResource("/images/newAgent.gif")));
        btStartAg.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                new StartNewAgentGUI((Frame)MASConsoleGUI.get().getFrame(), "Start a new agent to run in current MAS", System.getProperty("user.dir"));
            }
        });
        MASConsoleGUI.get().addButton(btStartAg);
        JButton btKillAg = new JButton("Kill agent", new ImageIcon(RunCentralisedMAS.class.getResource("/images/killAgent.gif")));
        btKillAg.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                new KillAgentGUI((Frame)MASConsoleGUI.get().getFrame(), "Kill an agent of the current MAS");
            }
        });
        MASConsoleGUI.get().addButton(btKillAg);
        this.createNewReplAgButton();
    }

    protected void createPauseButton() {
        final JButton btPause = new JButton("Pause", new ImageIcon(RunCentralisedMAS.class.getResource("/images/resume_co.gif")));
        btPause.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                if (MASConsoleGUI.get().isPause()) {
                    btPause.setText("Pause");
                    MASConsoleGUI.get().setPause(false);
                } else {
                    btPause.setText("Continue");
                    MASConsoleGUI.get().setPause(true);
                }
            }
        });
        MASConsoleGUI.get().addButton(btPause);
    }

    protected void createStopButton() {
        JButton btStop = new JButton("Stop", new ImageIcon(RunCentralisedMAS.class.getResource("/images/suspend.gif")));
        btStop.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MASConsoleGUI.get().setPause(false);
                BaseCentralisedMAS.runner.finish();
            }
        });
        MASConsoleGUI.get().addButton(btStop);
    }

    protected void createNewReplAgButton() {
        final JButton btStartAg = new JButton("New REPL agent", new ImageIcon(RunCentralisedMAS.class.getResource("/images/newAgent.gif")));
        btStartAg.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                final JFrame f = new JFrame("New REPL Agent, give it a name");
                final JTextField n = new JTextField(30);
                n.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e2) {
                        f.setVisible(false);
                        RunCentralisedMAS.this.createReplAg(n.getText());
                    }
                });
                f.setLayout(new FlowLayout());
                f.add(n);
                f.pack();
                f.setLocation(btStartAg.getLocationOnScreen().x, btStartAg.getLocationOnScreen().y + 30);
                f.setVisible(true);
            }
        });
        MASConsoleGUI.get().addButton(btStartAg);
    }

    protected void createReplAg(String n) {
        CentralisedAgArch agArch = new CentralisedAgArch();
        try {
            agArch.setAgName(n);
            agArch.setEnvInfraTier(this.env);
            agArch.createArchs(null, ReplAgGUI.class.getName(), null, null, new Settings(), this);
            Thread agThread = new Thread(agArch);
            agArch.setThread(agThread);
            agThread.start();
        }
        catch (JasonException e1) {
            e1.printStackTrace();
        }
        this.addAg(agArch);
    }

    protected void createEnvironment() throws JasonException {
        if (project.getEnvClass() != null && !project.getEnvClass().getClassName().equals(Environment.class.getName())) {
            logger.fine("Creating environment " + project.getEnvClass());
            this.env = new CentralisedEnvironment(project.getEnvClass(), this);
        }
    }

    protected void createAgs() throws JasonException {
        RConf generalConf = project.getInfrastructure().hasParameter("pool") ? RConf.POOL_SYNCH : (project.getInfrastructure().hasParameter("synch_scheduled") ? RConf.POOL_SYNCH_SCHEDULED : (project.getInfrastructure().hasParameter("asynch") ? RConf.ASYNCH : (project.getInfrastructure().hasParameter("asynch_shared") ? RConf.ASYNCH_SHARED_POOLS : RConf.TRHEADED)));
        if (generalConf != RConf.TRHEADED) {
            logger.info("Creating agents....");
        }
        int nbAg = 0;
        Agent pag = null;
        for (AgentParameters ap : project.getAgents()) {
            try {
                String agName = ap.name;
                for (int cAg = 0; cAg < ap.getNbInstances(); ++cAg) {
                    CentralisedAgArch agArch;
                    ++nbAg;
                    String numberedAg = agName;
                    if (ap.getNbInstances() > 1) {
                        numberedAg = numberedAg + (cAg + 1);
                    }
                    String nb = "";
                    int n = 1;
                    while (this.getAg(numberedAg + nb) != null) {
                        nb = "_" + n++;
                    }
                    numberedAg = numberedAg + nb;
                    logger.fine("Creating agent " + numberedAg + " (" + (cAg + 1) + "/" + ap.getNbInstances() + ")");
                    RConf agentConf = ap.getOption("rc") != null ? (ap.getOption("rc").equals("pool") ? RConf.POOL_SYNCH : (ap.getOption("rc").equals("synch_scheduled") ? RConf.POOL_SYNCH_SCHEDULED : (ap.getOption("rc").equals("asynch") ? RConf.ASYNCH : (ap.getOption("rc").equals("asynch_shared") ? RConf.ASYNCH_SHARED_POOLS : RConf.TRHEADED)))) : generalConf;
                    int cycles = 0;
                    int cyclesSense = 0;
                    int cyclesDeliberate = 0;
                    int cyclesAct = 0;
                    if (ap.getOption("cycles") != null) {
                        cycles = Integer.valueOf(ap.getOption("cycles"));
                    }
                    if (ap.getOption("cycles_sense") != null) {
                        cyclesSense = Integer.valueOf(ap.getOption("cycles_sense"));
                    }
                    if (ap.getOption("cycles_deliberate") != null) {
                        cyclesDeliberate = Integer.valueOf(ap.getOption("cycles_deliberate"));
                    }
                    if (ap.getOption("cycles_act") != null) {
                        cyclesAct = Integer.valueOf(ap.getOption("cycles_act"));
                    }
                    if (agentConf == RConf.POOL_SYNCH) {
                        agArch = new CentralisedAgArchForPool();
                    } else if (agentConf == RConf.POOL_SYNCH_SCHEDULED) {
                        agArch = new CentralisedAgArchSynchronousScheduled();
                        if (cycles != 0) {
                            if (cyclesSense == 0) {
                                cyclesSense = cycles;
                            }
                            if (cyclesDeliberate == 0) {
                                cyclesDeliberate = cycles;
                            }
                            if (cyclesAct == 0) {
                                cyclesAct = cycles;
                            }
                            cycles = 1;
                        }
                    } else if (agentConf == RConf.ASYNCH || agentConf == RConf.ASYNCH_SHARED_POOLS) {
                        agArch = new CentralisedAgArchAsynchronous();
                        if (cycles != 0) {
                            if (cyclesSense == 0) {
                                cyclesSense = cycles;
                            }
                            if (cyclesDeliberate == 0) {
                                cyclesDeliberate = cycles;
                            }
                            if (cyclesAct == 0) {
                                cyclesAct = cycles;
                            }
                            cycles = 1;
                        }
                    } else {
                        agArch = new CentralisedAgArch();
                        if (cycles != 0) {
                            if (cyclesSense == 0) {
                                cyclesSense = cycles;
                            }
                            if (cyclesDeliberate == 0) {
                                cyclesDeliberate = cycles;
                            }
                            if (cyclesAct == 0) {
                                cyclesAct = cycles;
                            }
                            cycles = 1;
                        }
                    }
                    agArch.setCycles(cycles);
                    agArch.setCyclesSense(cyclesSense);
                    agArch.setCyclesDeliberate(cyclesDeliberate);
                    agArch.setCyclesAct(cyclesAct);
                    agArch.setConf(agentConf);
                    agArch.setAgName(numberedAg);
                    agArch.setEnvInfraTier(this.env);
                    if (generalConf != RConf.TRHEADED && cAg > 0 && ap.getAgArchClasses().isEmpty() && ap.getBBClass().equals(DefaultBeliefBase.class.getName())) {
                        agArch.createArchs(ap.getAgArchClasses(), pag, this);
                    } else {
                        agArch.createArchs(ap.getAgArchClasses(), ap.agClass.getClassName(), ap.getBBClass(), ap.asSource.toString(), ap.getAsSetts(debug, project.getControlClass() != null), this);
                    }
                    this.addAg(agArch);
                    pag = agArch.getTS().getAg();
                }
            }
            catch (Exception e2) {
                logger.log(Level.SEVERE, "Error creating agent " + ap.name, e2);
            }
        }
        if (generalConf != RConf.TRHEADED) {
            logger.info("Created " + nbAg + " agents.");
        }
    }

    protected void createController() throws JasonException {
        ClassParameters controlClass = project.getControlClass();
        if (debug && controlClass == null) {
            controlClass = new ClassParameters(ExecutionControlGUI.class.getName());
        }
        if (controlClass != null) {
            logger.fine("Creating controller " + controlClass);
            this.control = new CentralisedExecutionControl(controlClass, this);
        }
    }

    protected void startAgs() {
        if (project.getInfrastructure().hasParameter("pool") || project.getInfrastructure().hasParameter("synch_scheduled") || project.getInfrastructure().hasParameter("asynch") || project.getInfrastructure().hasParameter("asynch_shared")) {
            this.createThreadPool();
        } else {
            this.createAgsThreads();
        }
    }

    private void createAgsThreads() {
        int cyclesSense = 1;
        int cyclesDeliberate = 1;
        int cyclesAct = 5;
        if (project.getInfrastructure().hasParameters()) {
            if (project.getInfrastructure().getParametersArray().length > 2) {
                cyclesSense = Integer.parseInt(project.getInfrastructure().getParameter(1));
                cyclesDeliberate = Integer.parseInt(project.getInfrastructure().getParameter(2));
                cyclesAct = Integer.parseInt(project.getInfrastructure().getParameter(3));
            } else if (project.getInfrastructure().getParametersArray().length > 1) {
                cyclesDeliberate = cyclesAct = Integer.parseInt(project.getInfrastructure().getParameter(1));
                cyclesSense = cyclesAct;
            }
        }
        for (CentralisedAgArch ag : this.ags.values()) {
            ag.setControlInfraTier(this.control);
            ag.setCyclesSense(cyclesSense);
            ag.setCyclesDeliberate(cyclesDeliberate);
            ag.setCyclesAct(cyclesAct);
            Thread agThread = new Thread(ag);
            ag.setThread(agThread);
        }
        for (CentralisedAgArch ag : this.ags.values()) {
            ag.startThread();
        }
    }

    private void createThreadPool() {
        this.sleepingAgs = Collections.synchronizedSet(new HashSet());
        int configuration = 0;
        int maxthreads = 10;
        int maxthreadsSense = 1;
        int maxthreadsDeliberate = 1;
        int maxthreadsAct = 1;
        int cycles = 1;
        int cyclesSense = 1;
        int cyclesDeliberate = 1;
        int cyclesAct = 5;
        try {
            if (project.getInfrastructure().hasParameters()) {
                if (project.getInfrastructure().hasParameter("asynch")) {
                    configuration = 1;
                    maxthreadsSense = Integer.parseInt(project.getInfrastructure().getParameter(1));
                    maxthreadsDeliberate = Integer.parseInt(project.getInfrastructure().getParameter(2));
                    maxthreadsAct = Integer.parseInt(project.getInfrastructure().getParameter(3));
                    if (project.getInfrastructure().getParametersArray().length > 5) {
                        cyclesSense = Integer.parseInt(project.getInfrastructure().getParameter(4));
                        cyclesDeliberate = Integer.parseInt(project.getInfrastructure().getParameter(5));
                        cyclesAct = Integer.parseInt(project.getInfrastructure().getParameter(6));
                    } else if (project.getInfrastructure().getParametersArray().length > 4) {
                        cyclesDeliberate = cyclesAct = Integer.parseInt(project.getInfrastructure().getParameter(4));
                        cyclesSense = cyclesAct;
                    }
                    logger.info("Creating agents with asynchronous reasoning cycle. Sense (" + maxthreadsSense + "), Deliberate (" + maxthreadsDeliberate + "), Act (" + maxthreadsAct + ")" + "Cycles: " + cyclesSense + ", " + cyclesDeliberate + ", " + cyclesAct);
                } else if (project.getInfrastructure().hasParameter("asynch_shared")) {
                    configuration = 2;
                    maxthreads = Integer.parseInt(project.getInfrastructure().getParameter(1));
                    if (project.getInfrastructure().getParametersArray().length > 3) {
                        cyclesSense = Integer.parseInt(project.getInfrastructure().getParameter(2));
                        cyclesDeliberate = Integer.parseInt(project.getInfrastructure().getParameter(3));
                        cyclesAct = Integer.parseInt(project.getInfrastructure().getParameter(4));
                    } else if (project.getInfrastructure().getParametersArray().length > 2) {
                        cyclesDeliberate = cyclesAct = Integer.parseInt(project.getInfrastructure().getParameter(2));
                        cyclesSense = cyclesAct;
                    }
                    logger.info("Creating agents with asynchronous reasoning cycle (shared). Sense, Deliberate, Act (" + maxthreads + ")" + "Cycles: " + cyclesSense + ", " + cyclesDeliberate + ", " + cyclesAct);
                } else if (project.getInfrastructure().hasParameter("synch_scheduled")) {
                    maxthreads = Integer.parseInt(project.getInfrastructure().getParameter(1));
                    if (project.getInfrastructure().getParametersArray().length > 3) {
                        cyclesSense = Integer.parseInt(project.getInfrastructure().getParameter(2));
                        cyclesDeliberate = Integer.parseInt(project.getInfrastructure().getParameter(3));
                        cyclesAct = Integer.parseInt(project.getInfrastructure().getParameter(4));
                    } else if (project.getInfrastructure().getParametersArray().length > 2) {
                        cyclesDeliberate = cyclesAct = Integer.parseInt(project.getInfrastructure().getParameter(2));
                        cyclesSense = cyclesAct;
                    }
                    logger.info("Creating a thread pool with " + maxthreads + " thread(s)." + "Cycles: " + cyclesSense + ", " + cyclesDeliberate + ", " + cyclesAct + " Reasoning Cycles: " + cycles);
                } else {
                    maxthreads = Integer.parseInt(project.getInfrastructure().getParameter(1));
                    if (project.getInfrastructure().getParametersArray().length > 3) {
                        cyclesSense = Integer.parseInt(project.getInfrastructure().getParameter(2));
                        cyclesDeliberate = Integer.parseInt(project.getInfrastructure().getParameter(3));
                        cyclesAct = Integer.parseInt(project.getInfrastructure().getParameter(4));
                        cycles = project.getInfrastructure().getParametersArray().length > 4 ? Integer.parseInt(project.getInfrastructure().getParameter(5)) : 5;
                    } else {
                        cycles = project.getInfrastructure().getParametersArray().length > 2 ? Integer.parseInt(project.getInfrastructure().getParameter(2)) : 5;
                    }
                    logger.info("Creating a thread pool with " + maxthreads + " thread(s)." + "Cycles: " + cyclesSense + ", " + cyclesDeliberate + ", " + cyclesAct + " Reasoning Cycles: " + cycles);
                }
            }
        }
        catch (Exception e2) {
            logger.warning("Error getting the number of thread for the pool.");
        }
        if (configuration == 0) {
            int poolSize = Math.min(8, this.ags.size());
            if (poolSize > maxthreads) {
                poolSize = maxthreads;
            }
            this.executor = Executors.newFixedThreadPool(poolSize);
            for (CentralisedAgArch ag : this.ags.values()) {
                ag.setCycles(cycles);
                ag.setCyclesSense(cyclesSense);
                ag.setCyclesDeliberate(cyclesDeliberate);
                ag.setCyclesAct(cyclesAct);
                if (ag instanceof CentralisedAgArchForPool) {
                    ((CentralisedAgArchForPool)ag).setExecutor(this.executor);
                }
                this.executor.execute(ag);
            }
        } else {
            if (configuration == 2) {
                this.executorDeliberate = this.executorAct = Executors.newFixedThreadPool(maxthreads);
                this.executorSense = this.executorAct;
            } else {
                this.executorSense = Executors.newFixedThreadPool(maxthreadsSense);
                this.executorDeliberate = Executors.newFixedThreadPool(maxthreadsDeliberate);
                this.executorAct = Executors.newFixedThreadPool(maxthreadsAct);
            }
            for (CentralisedAgArch ag : this.ags.values()) {
                CentralisedAgArchAsynchronous ag2 = (CentralisedAgArchAsynchronous)ag;
                ag2.addListenerToC(new CircumstanceListenerComponents(ag2));
                ag2.setExecutorAct(this.executorAct);
                ag2.setCyclesAct(cyclesAct);
                this.executorAct.execute(ag2.getActComponent());
                ag2.setExecutorDeliberate(this.executorDeliberate);
                ag2.setCyclesDeliberate(cyclesDeliberate);
                this.executorDeliberate.execute(ag2.getDeliberateComponent());
                ag2.setExecutorSense(this.executorSense);
                ag2.setCyclesSense(cyclesSense);
                this.executorSense.execute(ag2.getSenseComponent());
            }
        }
    }

    protected void stopAgs() {
        for (CentralisedAgArch ag : this.ags.values()) {
            ag.stopAg();
        }
    }

    protected void changeToDebugMode() {
        try {
            if (this.control == null) {
                this.control = new CentralisedExecutionControl(new ClassParameters(ExecutionControlGUI.class.getName()), this);
                for (CentralisedAgArch ag : this.ags.values()) {
                    ag.setControlInfraTier(this.control);
                    Settings stts = ag.getTS().getSettings();
                    stts.setVerbose(2);
                    stts.setSync(true);
                    ag.getLogger().setLevel(Level.FINE);
                    ag.getTS().getLogger().setLevel(Level.FINE);
                    ag.getTS().getAg().getLogger().setLevel(Level.FINE);
                }
            }
        }
        catch (Exception e2) {
            logger.log(Level.SEVERE, "Error entering in debug mode", e2);
        }
    }

    protected void startSyncMode() {
        if (this.control != null) {
            try {
                Thread.sleep(500L);
                this.control.informAllAgsToPerformCycle(0);
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
        }
    }

    protected void waitEnd() {
        try {
            File stop = new File(".stop___MAS");
            if (stop.exists()) {
                stop.delete();
            }
            while (!stop.exists()) {
                Thread.sleep(1500L);
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void finish() {
        Boolean bl = this.runningFinish;
        synchronized (bl) {
            if (this.runningFinish.booleanValue()) {
                return;
            }
            this.runningFinish = true;
        }
        try {
            new Thread(){

                @Override
                public void run() {
                    try {
                        8.sleep(5000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    System.exit(0);
                }
            }.start();
            System.out.flush();
            System.err.flush();
            if (MASConsoleGUI.hasConsole()) {
                MASConsoleGUI.get().close();
            }
            if (this.control != null) {
                this.control.stop();
                this.control = null;
            }
            if (this.env != null) {
                this.env.stop();
                this.env = null;
            }
            this.stopAgs();
            runner = null;
            File stop = new File(".stop___MAS");
            if (stop.exists()) {
                stop.delete();
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        System.exit(0);
    }

    private static void showProjectSources(MAS2JProject project) {
        JFrame frame = new JFrame("Project " + project.getSocName() + " sources");
        JTabbedPane pane = new JTabbedPane();
        frame.getContentPane().add(pane);
        project.fixAgentsSrc(urlPrefix);
        for (AgentParameters ap : project.getAgents()) {
            try {
                String tmpAsSrc = ap.asSource.toString();
                InputStream in = null;
                if (tmpAsSrc.startsWith("ClassResource:")) {
                    in = RunCentralisedMAS.class.getResource(tmpAsSrc.substring("ClassResource:".length())).openStream();
                } else {
                    try {
                        in = new URL(tmpAsSrc).openStream();
                    }
                    catch (MalformedURLException e2) {
                        in = new FileInputStream(tmpAsSrc);
                    }
                }
                StringBuilder s = new StringBuilder();
                int c = in.read();
                while (c > 0) {
                    s.append((char)c);
                    c = in.read();
                }
                JTextArea ta = new JTextArea(40, 50);
                ta.setEditable(false);
                ta.setText(s.toString());
                ta.setCaretPosition(0);
                JScrollPane sp = new JScrollPane(ta);
                pane.add(ap.name, sp);
            }
            catch (Exception e3) {
                logger.info("Error:" + e3);
            }
        }
        frame.pack();
        frame.setVisible(true);
    }

    protected final class CentralisedAgArchSynchronousScheduled
    extends CentralisedAgArch {
        private volatile boolean runWakeAfterTS = false;
        private int currentStep = 0;

        protected CentralisedAgArchSynchronousScheduled() {
        }

        @Override
        public void sleep() {
            RunCentralisedMAS.this.sleepingAgs.add(this);
        }

        @Override
        public void wake() {
            if (RunCentralisedMAS.this.sleepingAgs.remove(this)) {
                RunCentralisedMAS.this.executor.execute(this);
            } else {
                this.runWakeAfterTS = true;
            }
        }

        @Override
        public void sense() {
            int number_cycles = this.getCyclesSense();
            for (int i = 0; this.isRunning() && i < number_cycles; ++i) {
                this.runWakeAfterTS = false;
                this.getTS().sense();
                if (!this.getTS().canSleepSense()) continue;
                if (!this.runWakeAfterTS) break;
                this.wake();
                break;
            }
            if (this.isRunning()) {
                RunCentralisedMAS.this.executor.execute(this);
            }
        }

        @Override
        public void deliberate() {
            super.deliberate();
            if (this.isRunning()) {
                RunCentralisedMAS.this.executor.execute(this);
            }
        }

        @Override
        public void act() {
            super.act();
            if (this.isRunning()) {
                RunCentralisedMAS.this.executor.execute(this);
            }
        }

        @Override
        public void run() {
            switch (this.currentStep) {
                case 0: {
                    this.sense();
                    this.currentStep = 1;
                    break;
                }
                case 1: {
                    this.deliberate();
                    this.currentStep = 2;
                    break;
                }
                case 2: {
                    this.act();
                    this.currentStep = 0;
                }
            }
        }
    }
}

