/*
 * Decompiled with CFR 0.152.
 */
package jason.functions;

import jason.JasonException;
import jason.asSemantics.DefaultArithFunction;
import jason.asSemantics.TransitionSystem;
import jason.asSyntax.ListTerm;
import jason.asSyntax.NumberTerm;
import jason.asSyntax.Term;

public class StdDev
extends DefaultArithFunction {
    @Override
    public String getName() {
        return "math.std_dev";
    }

    @Override
    public double evaluate(TransitionSystem ts, Term[] args) throws Exception {
        if (args[0].isList()) {
            double num;
            double sum = 0.0;
            double squareSum = 0.0;
            int n = 0;
            for (Term t : (ListTerm)args[0]) {
                if (!t.isNumeric() || !t.isNumeric()) continue;
                num = ((NumberTerm)t).solve();
                sum += num;
                ++n;
            }
            double mean = sum / (double)n;
            for (Term t : (ListTerm)args[0]) {
                if (!t.isNumeric()) continue;
                num = ((NumberTerm)t).solve();
                squareSum += (num - mean) * (num - mean);
            }
            return Math.sqrt(squareSum / (double)(n - 1));
        }
        throw new JasonException(this.getName() + " is not implemented for type '" + args[0] + "'.");
    }

    @Override
    public boolean checkArity(int a) {
        return a == 1;
    }
}

