/*
 * Decompiled with CFR 0.152.
 */
package jason.functions;

import jason.JasonException;
import jason.asSemantics.DefaultArithFunction;
import jason.asSemantics.TransitionSystem;
import jason.asSemantics.Unifier;
import jason.asSyntax.InternalActionLiteral;
import jason.asSyntax.Literal;
import jason.asSyntax.LiteralImpl;
import jason.asSyntax.NumberTerm;
import jason.asSyntax.Structure;
import jason.asSyntax.Term;
import jason.asSyntax.VarTerm;
import java.util.Iterator;

public class RuleToFunction
extends DefaultArithFunction {
    private final String literal;
    private final int arity;

    public RuleToFunction(String literal2, int arity) {
        this.literal = literal2;
        this.arity = arity;
    }

    @Override
    public String getName() {
        return super.getName() + "_{" + this.literal + "}";
    }

    @Override
    public boolean checkArity(int a) {
        return a == this.arity;
    }

    @Override
    public boolean allowUngroundTerms() {
        return true;
    }

    @Override
    public double evaluate(TransitionSystem ts, Term[] args) throws Exception {
        Structure r = this.literal.indexOf(".") > 0 ? new InternalActionLiteral(this.literal) : new LiteralImpl(this.literal);
        ((Literal)r).addTerms(args);
        VarTerm answer = new VarTerm("__RuleToFunctionResult");
        ((Literal)r).addTerm(answer);
        Iterator<Unifier> i = r.logicalConsequence(ts == null ? null : ts.getAg(), new Unifier());
        if (i.hasNext()) {
            Term value = i.next().get(answer);
            if (value.isNumeric()) {
                return ((NumberTerm)value).solve();
            }
            throw new JasonException("The result of " + r + " (=" + value + ") is not numeric!");
        }
        throw new JasonException("No solution was found for rule " + r);
    }

    @Override
    public String toString() {
        return "function wrapper for " + this.literal + "/" + this.arity;
    }
}

