/*
 * Decompiled with CFR 0.152.
 */
package jason.asSyntax;

import jason.NoValueException;
import jason.asSemantics.Agent;
import jason.asSemantics.Unifier;
import jason.asSyntax.Atom;
import jason.asSyntax.CyclicTerm;
import jason.asSyntax.ListTerm;
import jason.asSyntax.Literal;
import jason.asSyntax.LiteralImpl;
import jason.asSyntax.LogicalFormula;
import jason.asSyntax.NumberTerm;
import jason.asSyntax.Term;
import jason.asSyntax.parser.as2j;
import java.io.StringReader;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class VarTerm
extends LiteralImpl
implements NumberTerm,
ListTerm {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger(VarTerm.class.getName());

    public VarTerm(String s) {
        super(s);
        if (s != null && Character.isLowerCase(s.charAt(0))) {
            logger.warning("Are you sure you want to create a VarTerm that begins with lowercase (" + s + ")? Should it be a Term instead?");
            Exception e2 = new Exception("stack");
            e2.printStackTrace();
        }
    }

    public VarTerm(Atom namespace2, String functor) {
        super(namespace2, true, functor);
    }

    public VarTerm(Atom namespace2, Literal v) {
        super(namespace2, !v.negated(), v);
    }

    public static VarTerm parseVar(String sVar) {
        as2j parser = new as2j(new StringReader(sVar));
        try {
            return parser.var(Literal.DefaultNS);
        }
        catch (Exception e2) {
            logger.log(Level.SEVERE, "Error parsing var " + sVar, e2);
            return null;
        }
    }

    @Override
    public Term capply(Unifier u) {
        Term vl;
        if (u != null && (vl = u.get(this)) != null) {
            if (!vl.isCyclicTerm() && vl.hasVar(this, u)) {
                u.remove(this);
                Term tempVl = vl.capply(u);
                u.bind(this, vl);
                CyclicTerm ct = new CyclicTerm((Literal)tempVl, this);
                Unifier renamedVars = new Unifier();
                ct.makeVarsAnnon(renamedVars);
                renamedVars.remove(this);
                u.compose(renamedVars);
                vl = ct;
            }
            if ((vl = vl.capply(u)).isLiteral()) {
                if (this.getNS() != Literal.DefaultNS) {
                    vl = ((Literal)vl).cloneNS((Atom)this.getNS().capply(u));
                }
                if (this.negated()) {
                    ((Literal)vl).setNegated(false);
                }
            }
            if (vl.isLiteral() && this.hasAnnot()) {
                vl = ((Literal)vl).forceFullLiteralImpl().addAnnots((ListTerm)this.getAnnots().capply(u));
            }
            return vl;
        }
        return this.clone();
    }

    @Override
    public Term clone() {
        return new VarTerm(this.getNS(), (Literal)this);
    }

    @Override
    public Literal cloneNS(Atom newNameSpace) {
        return new VarTerm(newNameSpace, (Literal)this);
    }

    @Override
    public ListTerm cloneLT() {
        return (ListTerm)this.clone();
    }

    @Override
    public boolean isVar() {
        return true;
    }

    @Override
    public boolean isUnnamedVar() {
        return false;
    }

    @Override
    public boolean isGround() {
        return false;
    }

    @Override
    public boolean equals(Object t) {
        if (t == null) {
            return false;
        }
        if (t == this) {
            return true;
        }
        if (t instanceof VarTerm) {
            VarTerm tAsVT = (VarTerm)t;
            return this.getFunctor().equals(tAsVT.getFunctor());
        }
        return false;
    }

    @Override
    protected int calcHashCode() {
        int result = this.getFunctor().hashCode();
        return result;
    }

    @Override
    public int compareTo(Term t) {
        if (t == null || t.isUnnamedVar()) {
            return -1;
        }
        if (t.isVar()) {
            return this.getFunctor().compareTo(((VarTerm)t).getFunctor());
        }
        return 1;
    }

    @Override
    public boolean subsumes(Term t) {
        return true;
    }

    @Override
    public Iterator<Unifier> logicalConsequence(Agent ag, Unifier un) {
        Term t = this.capply(un);
        if (t.equals(this)) {
            return super.logicalConsequence(ag, un);
        }
        return ((LogicalFormula)t).logicalConsequence(ag, un);
    }

    @Override
    public Term getTerm(int i) {
        return null;
    }

    @Override
    public void addTerm(Term t) {
        logger.log(Level.WARNING, "The addTerm '" + t + "' in " + this + " was lost, since I am a var.", new Exception());
    }

    @Override
    public int getArity() {
        return 0;
    }

    @Override
    public List<Term> getTerms() {
        return null;
    }

    @Override
    public Literal setTerms(List<Term> l) {
        return this;
    }

    @Override
    public void setTerm(int i, Term t) {
    }

    @Override
    public Literal addTerms(List<Term> l) {
        return this;
    }

    @Override
    public boolean isInternalAction() {
        return false;
    }

    @Override
    public boolean isList() {
        return false;
    }

    @Override
    public boolean isString() {
        return false;
    }

    @Override
    public boolean isPlanBody() {
        return false;
    }

    @Override
    public boolean isNumeric() {
        return false;
    }

    @Override
    public boolean isPred() {
        return false;
    }

    @Override
    public boolean isLiteral() {
        return false;
    }

    @Override
    public boolean isStructure() {
        return false;
    }

    @Override
    public boolean isAtom() {
        return false;
    }

    @Override
    public boolean isRule() {
        return false;
    }

    @Override
    public boolean isArithExpr() {
        return false;
    }

    @Override
    public boolean isCyclicTerm() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasVar(VarTerm t, Unifier u) {
        Term vl;
        if (this.equals(t)) {
            return true;
        }
        if (u != null && (vl = u.get(this)) != null) {
            try {
                u.remove(this);
                boolean bl = vl.hasVar(t, u);
                return bl;
            }
            finally {
                u.bind(this, vl);
            }
        }
        return false;
    }

    @Override
    public void countVars(Map<VarTerm, Integer> c) {
        int n = c.containsKey(this) ? c.get(this) : 0;
        c.put(this, n + 1);
        super.countVars(c);
    }

    @Override
    public boolean canBeAddedInBB() {
        return false;
    }

    @Override
    public double solve() throws NoValueException {
        throw new NoValueException();
    }

    @Override
    public void add(int index, Term o) {
    }

    @Override
    public boolean add(Term o) {
        return false;
    }

    @Override
    public boolean addAll(Collection c) {
        return false;
    }

    @Override
    public boolean addAll(int index, Collection c) {
        return false;
    }

    @Override
    public void clear() {
    }

    @Override
    public boolean contains(Object o) {
        return false;
    }

    @Override
    public boolean containsAll(Collection c) {
        return false;
    }

    @Override
    public Term get(int index) {
        return null;
    }

    @Override
    public int indexOf(Object o) {
        return -1;
    }

    @Override
    public int lastIndexOf(Object o) {
        return -1;
    }

    @Override
    public Iterator<Term> iterator() {
        return null;
    }

    @Override
    public ListIterator<Term> listIterator() {
        return null;
    }

    @Override
    public ListIterator<Term> listIterator(int index) {
        return null;
    }

    @Override
    public Term remove(int index) {
        return null;
    }

    @Override
    public boolean remove(Object o) {
        return false;
    }

    @Override
    public boolean removeAll(Collection c) {
        return false;
    }

    @Override
    public boolean retainAll(Collection c) {
        return false;
    }

    @Override
    public Term set(int index, Term o) {
        return null;
    }

    @Override
    public List<Term> subList(int arg0, int arg1) {
        return null;
    }

    @Override
    public Iterator<List<Term>> subSets(int k) {
        return null;
    }

    @Override
    public Object[] toArray() {
        return null;
    }

    @Override
    public Object[] toArray(Object[] arg0) {
        return null;
    }

    @Override
    public void setTerm(Term t) {
    }

    @Override
    public void setNext(Term t) {
    }

    @Override
    public ListTerm append(Term t) {
        return null;
    }

    @Override
    public ListTerm insert(Term t) {
        return null;
    }

    @Override
    public ListTerm concat(ListTerm lt) {
        return null;
    }

    @Override
    public ListTerm reverse() {
        return null;
    }

    @Override
    public ListTerm union(ListTerm lt) {
        return null;
    }

    @Override
    public ListTerm intersection(ListTerm lt) {
        return null;
    }

    @Override
    public ListTerm difference(ListTerm lt) {
        return null;
    }

    @Override
    public List<Term> getAsList() {
        return null;
    }

    @Override
    public ListTerm getLast() {
        return null;
    }

    @Override
    public ListTerm getPenultimate() {
        return null;
    }

    @Override
    public Term removeLast() {
        return null;
    }

    @Override
    public ListTerm getNext() {
        return null;
    }

    @Override
    public Term getTerm() {
        return null;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public boolean isEnd() {
        return false;
    }

    @Override
    public boolean isTail() {
        return false;
    }

    @Override
    public void setTail(VarTerm v) {
    }

    @Override
    public VarTerm getTail() {
        return null;
    }

    @Override
    public Iterator<ListTerm> listTermIterator() {
        return null;
    }

    @Override
    public int size() {
        return -1;
    }

    @Override
    public ListTerm cloneLTShallow() {
        return null;
    }

    @Override
    public Element getAsDOM(Document document) {
        Element u = document.createElement("var-term");
        u.setAttribute("functor", this.getFunctor());
        if (this.hasAnnot()) {
            Element ea = document.createElement("annotations");
            ea.appendChild(this.getAnnots().getAsDOM(document));
            u.appendChild(ea);
        }
        return u;
    }
}

