/*
 * Decompiled with CFR 0.152.
 */
package jason.asSyntax;

import jason.asSyntax.Atom;
import jason.asSyntax.Literal;
import jason.asSyntax.Term;
import jason.asSyntax.VarTerm;
import java.util.concurrent.atomic.AtomicInteger;

public class UnnamedVar
extends VarTerm {
    private static final long serialVersionUID = 1L;
    private static AtomicInteger varCont = new AtomicInteger(0);
    public int myId;

    public UnnamedVar() {
        this(Literal.DefaultNS, varCont.incrementAndGet());
    }

    public UnnamedVar(Atom ns) {
        this(ns, varCont.incrementAndGet());
    }

    public UnnamedVar(Atom ns, int id) {
        super(ns, "_" + id);
        this.myId = id;
    }

    public UnnamedVar(int id) {
        super("_" + id);
        this.myId = id;
    }

    private UnnamedVar(String name) {
        super(name);
    }

    private UnnamedVar(Atom ns, String name) {
        super(ns, name);
    }

    public static UnnamedVar create(String name) {
        return UnnamedVar.create(Literal.DefaultNS, name);
    }

    public static UnnamedVar create(Atom ns, String name) {
        if (name.length() == 1) {
            return new UnnamedVar(ns);
        }
        int id = varCont.incrementAndGet();
        UnnamedVar v = new UnnamedVar(ns, "_" + id + name);
        v.myId = id;
        return v;
    }

    @Override
    public Term clone() {
        return this.cloneNS(this.getNS());
    }

    @Override
    public Literal cloneNS(Atom newNameSpace) {
        UnnamedVar newv = new UnnamedVar(newNameSpace, this.getFunctor());
        newv.myId = this.myId;
        newv.hashCodeCache = this.hashCodeCache;
        if (this.hasAnnot()) {
            newv.addAnnots(this.getAnnots().cloneLT());
        }
        return newv;
    }

    @Override
    public boolean equals(Object t) {
        if (t == null) {
            return false;
        }
        if (t == this) {
            return true;
        }
        if (t instanceof UnnamedVar) {
            return ((UnnamedVar)t).myId == this.myId;
        }
        return false;
    }

    @Override
    public int compareTo(Term t) {
        if (t instanceof UnnamedVar) {
            if (this.myId > ((UnnamedVar)t).myId) {
                return 1;
            }
            if (this.myId < ((UnnamedVar)t).myId) {
                return -1;
            }
            return 0;
        }
        if (t instanceof VarTerm) {
            return 1;
        }
        return super.compareTo(t);
    }

    @Override
    public boolean isUnnamedVar() {
        return true;
    }
}

