/*
 * Decompiled with CFR 0.152.
 */
package jason.asSyntax;

import jason.asSyntax.DefaultTerm;
import jason.asSyntax.NumberTerm;
import jason.asSyntax.StringTerm;
import jason.asSyntax.Term;
import jason.asSyntax.VarTerm;
import jason.asSyntax.parser.as2j;
import java.io.StringReader;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public final class StringTermImpl
extends DefaultTerm
implements StringTerm {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger(StringTermImpl.class.getName());
    private final String value;

    public StringTermImpl() {
        this.value = null;
    }

    public StringTermImpl(String fs) {
        this.value = fs;
    }

    public StringTermImpl(StringTermImpl t) {
        this.value = t.getString();
        this.srcInfo = t.srcInfo;
    }

    @Override
    public String getString() {
        return this.value;
    }

    @Override
    public StringTerm clone() {
        return this;
    }

    public static StringTerm parseString(String sTerm) {
        as2j parser = new as2j(new StringReader(sTerm));
        try {
            return (StringTerm)parser.term();
        }
        catch (Exception e2) {
            logger.log(Level.SEVERE, "Error parsing string term " + sTerm, e2);
            return null;
        }
    }

    @Override
    public boolean isString() {
        return true;
    }

    @Override
    public int length() {
        if (this.value == null) {
            return 0;
        }
        return this.value.length();
    }

    @Override
    public boolean equals(Object t) {
        if (t == this) {
            return true;
        }
        if (t != null && t instanceof StringTerm) {
            StringTerm st = (StringTerm)t;
            if (this.value == null) {
                return st.getString() == null;
            }
            return this.value.equals(st.getString());
        }
        return false;
    }

    @Override
    protected int calcHashCode() {
        if (this.value == null) {
            return 0;
        }
        return this.value.hashCode();
    }

    @Override
    public int compareTo(Term o) {
        if (o instanceof VarTerm) {
            return o.compareTo(this) * -1;
        }
        if (o instanceof NumberTerm) {
            return 1;
        }
        return super.compareTo(o);
    }

    public String toString() {
        return "\"" + this.value + "\"";
    }

    @Override
    public Element getAsDOM(Document document) {
        Element u = document.createElement("string-term");
        u.appendChild(document.createTextNode(this.toString()));
        return u;
    }
}

