/*
 * Decompiled with CFR 0.152.
 */
package jason.asSyntax;

import jason.asSemantics.Agent;
import jason.asSemantics.Unifier;
import jason.asSyntax.BinaryStructure;
import jason.asSyntax.ListTerm;
import jason.asSyntax.Literal;
import jason.asSyntax.LogExpr;
import jason.asSyntax.LogicalFormula;
import jason.asSyntax.Term;
import jason.asSyntax.parser.as2j;
import java.io.StringReader;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class RelExpr
extends BinaryStructure
implements LogicalFormula {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger(RelExpr.class.getName());
    private RelationalOp op = RelationalOp.none;

    public RelExpr(Term t1, RelationalOp oper, Term t2) {
        super(t1, oper.toString(), t2);
        this.op = oper;
    }

    @Override
    public Iterator<Unifier> logicalConsequence(Agent ag, Unifier un) {
        Term xp = this.getTerm(0).capply(un);
        Term yp = this.getTerm(1).capply(un);
        switch (this.op) {
            case none: {
                break;
            }
            case gt: {
                if (xp.compareTo(yp) <= 0) break;
                return LogExpr.createUnifIterator(un);
            }
            case gte: {
                if (xp.compareTo(yp) < 0) break;
                return LogExpr.createUnifIterator(un);
            }
            case lt: {
                if (xp.compareTo(yp) >= 0) break;
                return LogExpr.createUnifIterator(un);
            }
            case lte: {
                if (xp.compareTo(yp) > 0) break;
                return LogExpr.createUnifIterator(un);
            }
            case eq: {
                if (!xp.equals(yp)) break;
                return LogExpr.createUnifIterator(un);
            }
            case dif: {
                if (xp.equals(yp)) break;
                return LogExpr.createUnifIterator(un);
            }
            case unify: {
                if (!un.unifies(xp, yp)) break;
                return LogExpr.createUnifIterator(un);
            }
            case literalBuilder: {
                try {
                    Literal p = (Literal)xp;
                    ListTerm l = (ListTerm)yp;
                    if (!p.isVar() && !l.isVar()) {
                        ListTerm palt = p.getAsListOfTerms();
                        if (l.size() == 3) {
                            palt = palt.getNext();
                        }
                        if (!un.unifies(palt, l)) break;
                        return LogExpr.createUnifIterator(un);
                    }
                    if (p.isVar() && l.isList()) {
                        if (un.unifies(p, Literal.newFromListOfTerms(l))) {
                            return LogExpr.createUnifIterator(un);
                        }
                        LogExpr.EMPTY_UNIF_LIST.iterator();
                    }
                    if (p.isLiteral() && l.isVar()) {
                        if (un.unifies(p.getAsListOfTerms(), l)) {
                            return LogExpr.createUnifIterator(un);
                        }
                        LogExpr.EMPTY_UNIF_LIST.iterator();
                    }
                    logger.log(Level.SEVERE, "Both arguments of " + this.getTerm(0) + " =.. " + this.getTerm(1) + " are variables!");
                    break;
                }
                catch (Exception e2) {
                    logger.log(Level.SEVERE, "The arguments of operator =.. are not Literal and List.", e2);
                }
            }
        }
        return LogExpr.EMPTY_UNIF_LIST.iterator();
    }

    public static LogicalFormula parseExpr(String sExpr) {
        as2j parser = new as2j(new StringReader(sExpr));
        try {
            return (LogicalFormula)parser.rel_expr();
        }
        catch (Exception e2) {
            logger.log(Level.SEVERE, "Error parsing expression " + sExpr, e2);
            return null;
        }
    }

    @Override
    public Term capply(Unifier u) {
        return new RelExpr(this.getTerm(0).capply(u), this.op, this.getTerm(1).capply(u));
    }

    @Override
    public LogicalFormula clone() {
        return new RelExpr(this.getTerm(0).clone(), this.op, this.getTerm(1).clone());
    }

    public RelationalOp getOp() {
        return this.op;
    }

    @Override
    public Element getAsDOM(Document document) {
        Element u = super.getAsDOM(document);
        u.setAttribute("type", "relational");
        return u;
    }

    public static enum RelationalOp {
        none{

            public String toString() {
                return "";
            }
        }
        ,
        gt{

            public String toString() {
                return " > ";
            }
        }
        ,
        gte{

            public String toString() {
                return " >= ";
            }
        }
        ,
        lt{

            public String toString() {
                return " < ";
            }
        }
        ,
        lte{

            public String toString() {
                return " <= ";
            }
        }
        ,
        eq{

            public String toString() {
                return " == ";
            }
        }
        ,
        dif{

            public String toString() {
                return " \\== ";
            }
        }
        ,
        unify{

            public String toString() {
                return " = ";
            }
        }
        ,
        literalBuilder{

            public String toString() {
                return " =.. ";
            }
        };

    }
}

