/*
 * Decompiled with CFR 0.152.
 */
package jason.asSyntax;

import jason.asSemantics.Unifier;
import jason.asSyntax.Atom;
import jason.asSyntax.ListTerm;
import jason.asSyntax.ListTermImpl;
import jason.asSyntax.Literal;
import jason.asSyntax.Structure;
import jason.asSyntax.Term;
import jason.asSyntax.VarTerm;
import jason.asSyntax.parser.as2j;
import java.io.StringReader;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Pred
extends Structure {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger(Pred.class.getName());
    private ListTerm annots;

    public Pred(String functor) {
        super(functor);
    }

    public Pred(Literal l) {
        this(l.getNS(), l);
    }

    public Pred(Atom namespace2, String functor) {
        super(namespace2, functor);
    }

    public Pred(Atom namespace2, Literal l) {
        super(namespace2, l);
        this.annots = l.hasAnnot() ? l.getAnnots().cloneLT() : null;
    }

    protected Pred(Literal l, Unifier u) {
        super(l, u);
        if (l.hasAnnot()) {
            this.setAnnots((ListTerm)l.getAnnots().capply(u));
        } else {
            this.annots = null;
        }
    }

    public Pred(String functor, int termsSize) {
        super(functor, termsSize);
    }

    public static Pred parsePred(String sPred) {
        as2j parser = new as2j(new StringReader(sPred));
        try {
            return parser.pred();
        }
        catch (Exception e2) {
            logger.log(Level.SEVERE, "Error parsing predicate " + sPred, e2);
            return null;
        }
    }

    @Override
    public boolean isPred() {
        return true;
    }

    @Override
    public boolean isAtom() {
        return super.isAtom() && !this.hasAnnot();
    }

    @Override
    public boolean isGround() {
        if (this.annots == null) {
            return super.isGround();
        }
        return super.isGround() && this.annots.isGround();
    }

    @Override
    public Literal setAnnots(ListTerm l) {
        this.annots = null;
        if (l == null) {
            return this;
        }
        Iterator<ListTerm> i = l.listTermIterator();
        while (i.hasNext()) {
            ListTerm lt = i.next();
            if (lt.getTerm() == null) {
                return this;
            }
            this.addAnnot(lt.getTerm());
            if (!lt.isTail()) continue;
            this.annots.setTail(lt.getTail());
            return this;
        }
        return this;
    }

    @Override
    public boolean addAnnot(Term t) {
        if (this.annots == null) {
            this.annots = new ListTermImpl();
        }
        Iterator<ListTerm> i = this.annots.listTermIterator();
        while (i.hasNext()) {
            ListTerm lt = i.next();
            int c = t.compareTo(lt.getTerm());
            if (c == 0) {
                return false;
            }
            if (c >= 0) continue;
            lt.insert(t);
            return true;
        }
        return false;
    }

    @Override
    public Literal addAnnots(List<Term> l) {
        if (l != null) {
            for (Term t : l) {
                this.addAnnot(t);
            }
        }
        return this;
    }

    @Override
    public Literal addAnnots(Term ... l) {
        for (Term t : l) {
            this.addAnnot(t);
        }
        return this;
    }

    @Override
    public boolean delAnnot(Term t) {
        if (this.annots == null) {
            return false;
        }
        return this.annots.remove(t);
    }

    @Override
    public void clearAnnots() {
        this.annots = null;
    }

    @Override
    public ListTerm getAnnots() {
        return this.annots;
    }

    @Override
    public boolean hasAnnot(Term t) {
        if (this.annots == null) {
            return false;
        }
        Iterator<ListTerm> i = this.annots.listTermIterator();
        while (i.hasNext()) {
            ListTerm lt = i.next();
            int c = t.compareTo(lt.getTerm());
            if (c == 0) {
                return true;
            }
            if (c >= 0) continue;
            return false;
        }
        return false;
    }

    @Override
    public Literal getAnnot(String functor) {
        if (this.annots == null) {
            return null;
        }
        for (Term t : this.annots) {
            if (!t.isLiteral()) continue;
            Literal l = (Literal)t;
            int c = functor.compareTo(l.getFunctor());
            if (c == 0) {
                return l;
            }
            if (c >= 0) continue;
            return null;
        }
        return null;
    }

    @Override
    public boolean hasAnnot() {
        return this.annots != null && !this.annots.isEmpty();
    }

    @Override
    public boolean hasVar(VarTerm t, Unifier u) {
        if (super.hasVar(t, u)) {
            return true;
        }
        if (this.annots != null) {
            for (Term v : this.annots) {
                if (!v.hasVar(t, u)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void countVars(Map<VarTerm, Integer> c) {
        super.countVars(c);
        if (this.annots != null) {
            for (Term t : this.annots) {
                t.countVars(c);
            }
        }
    }

    @Override
    public boolean importAnnots(Literal p) {
        boolean imported = false;
        if (p.hasAnnot()) {
            Iterator i = p.getAnnots().iterator();
            while (i.hasNext()) {
                Term t = (Term)i.next();
                if (this.addAnnot(t.clone())) {
                    imported = true;
                    continue;
                }
                i.remove();
            }
        }
        return imported;
    }

    @Override
    public boolean delAnnots(List<Term> l) {
        boolean removed = false;
        if (l != null && this.hasAnnot()) {
            for (Term t : l) {
                boolean r = this.delAnnot(t);
                removed = removed || r;
            }
        }
        return removed;
    }

    @Override
    public ListTerm getAnnots(String functor) {
        ListTermImpl ls = new ListTermImpl();
        if (this.annots != null) {
            ListTerm tail = ls;
            for (Term ta : this.annots) {
                if (!ta.isLiteral() || !((Literal)ta).getFunctor().equals(functor)) continue;
                tail = tail.append(ta);
            }
        }
        return ls;
    }

    @Override
    public boolean hasSubsetAnnot(Literal p) {
        if (this.annots == null) {
            return true;
        }
        if (this.hasAnnot() && !p.hasAnnot()) {
            return false;
        }
        Iterator i2 = p.getAnnots().iterator();
        int c = -1;
        for (Term myAnnot : this.annots) {
            Term t;
            if (!i2.hasNext()) {
                return false;
            }
            while (i2.hasNext() && (c = myAnnot.compareTo(t = (Term)i2.next())) > 0) {
            }
            if (c == 0) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean hasSubsetAnnot(Literal p, Unifier u) {
        ListTerm lt;
        Term annot;
        if (this.annots == null) {
            return true;
        }
        if (!p.hasAnnot()) {
            return false;
        }
        VarTerm thisTail = null;
        ListTerm pAnnots = p.getAnnots().cloneLTShallow();
        VarTerm pTail = pAnnots.getTail();
        Comparable pAnnot = null;
        List pAnnotsTail = null;
        Iterator i2 = pAnnots.iterator();
        boolean i2Reset = false;
        Iterator<ListTerm> i1 = this.annots.listTermIterator();
        while (i1.hasNext() && (annot = (lt = i1.next()).getTerm()) != null) {
            if (lt.isTail()) {
                thisTail = lt.getTail();
            }
            if (annot.isVar() && !i2Reset) {
                i2Reset = true;
                i2 = pAnnots.iterator();
                pAnnot = null;
            }
            boolean ok = false;
            while (true) {
                if (pAnnot != null && u.unifiesNoUndo(annot, (Term)pAnnot)) {
                    ok = true;
                    i2.remove();
                    pAnnot = (Term)i2.next();
                    break;
                }
                if (pAnnot != null && pAnnot.compareTo(annot) > 0 || !i2.hasNext()) break;
                pAnnot = (Term)i2.next();
            }
            if (!ok && pTail != null) {
                if (pAnnotsTail == null && (pAnnotsTail = (ListTerm)u.get(pTail)) == null) {
                    pAnnotsTail = new ListTermImpl();
                    u.unifies(pTail, (Term)((Object)pAnnotsTail));
                    pAnnotsTail = (ListTerm)u.get(pTail);
                }
                pAnnotsTail.add(annot.clone());
                ok = true;
            }
            if (ok) continue;
            return false;
        }
        if (thisTail != null) {
            u.unifies(thisTail, pAnnots);
        }
        return true;
    }

    @Override
    public void addSource(Term agName) {
        if (agName != null) {
            this.addAnnot(Pred.createSource(agName));
        }
    }

    @Override
    public boolean delSource(Term agName) {
        if (this.annots != null) {
            return this.delAnnot(Pred.createSource(agName));
        }
        return false;
    }

    public static Pred createSource(Term source) {
        Pred s = source.isGround() ? new Pred("source", 1){

            @Override
            public Term clone() {
                return this;
            }

            @Override
            public Term capply(Unifier u) {
                return this;
            }

            @Override
            public boolean isGround() {
                return true;
            }

            @Override
            public Literal makeVarsAnnon() {
                return this;
            }

            @Override
            public Literal makeVarsAnnon(Unifier un) {
                return this;
            }
        } : new Pred("source", 1);
        s.addTerm(source);
        return s;
    }

    @Override
    public ListTerm getSources() {
        ListTermImpl ls = new ListTermImpl();
        if (this.annots != null) {
            ListTerm tail = ls;
            for (Term ta : this.annots) {
                Structure tas;
                if (!ta.isStructure() || !(tas = (Structure)ta).getFunctor().equals("source")) continue;
                tail = tail.append(tas.getTerm(0));
            }
        }
        return ls;
    }

    @Override
    public void delSources() {
        if (this.annots != null) {
            Iterator i = this.annots.iterator();
            while (i.hasNext()) {
                Term t = (Term)i.next();
                if (!t.isStructure() || !((Structure)t).getFunctor().equals("source")) continue;
                i.remove();
            }
        }
    }

    @Override
    public boolean hasSource() {
        if (this.annots != null) {
            for (Term ta : this.annots) {
                if (!ta.isStructure() || !((Structure)ta).getFunctor().equals("source")) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean hasSource(Term agName) {
        if (this.annots != null) {
            return this.hasAnnot(Pred.createSource(agName));
        }
        return false;
    }

    @Override
    public Literal makeVarsAnnon(Unifier un) {
        if (this.annots != null) {
            ListTerm lt = this.annots;
            while (!lt.isEmpty()) {
                Term ta = lt.getTerm();
                if (ta.isVar()) {
                    lt.setTerm(this.varToReplace(ta, un));
                } else if (ta instanceof Structure) {
                    ((Structure)ta).makeVarsAnnon(un);
                }
                if (lt.isTail() && lt.getNext().isVar()) {
                    lt.setNext(this.varToReplace(lt.getNext(), un));
                    break;
                }
                lt = lt.getNext();
            }
        }
        return super.makeVarsAnnon(un);
    }

    @Override
    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (o instanceof Pred) {
            Pred p = (Pred)o;
            return super.equals(o) && this.hasSubsetAnnot(p) && p.hasSubsetAnnot(this);
        }
        if (o instanceof Atom && !this.hasAnnot()) {
            return super.equals(o);
        }
        return false;
    }

    @Override
    public boolean equalsAsStructure(Object p) {
        return super.equals((Term)p);
    }

    @Override
    public int compareTo(Term t) {
        int c = super.compareTo(t);
        if (c != 0) {
            return c;
        }
        if (t.isPred()) {
            int ots;
            Pred tAsPred = (Pred)t;
            if (this.getAnnots() == null && tAsPred.getAnnots() == null) {
                return 0;
            }
            if (this.getAnnots() == null) {
                return -1;
            }
            if (tAsPred.getAnnots() == null) {
                return 1;
            }
            Iterator pai = tAsPred.getAnnots().iterator();
            for (Term a : this.getAnnots()) {
                c = a.compareTo(pai.next());
                if (c == 0) continue;
                return c;
            }
            int ats = this.getAnnots().size();
            if (ats < (ots = tAsPred.getAnnots().size())) {
                return -1;
            }
            if (ats > ots) {
                return 1;
            }
        }
        return 0;
    }

    @Override
    public Term capply(Unifier u) {
        return new Pred((Literal)this, u);
    }

    @Override
    public Term clone() {
        return new Pred(this);
    }

    @Override
    public Literal cloneNS(Atom newnamespace) {
        return new Pred(newnamespace, this);
    }

    public String toStringAsTerm() {
        return super.toString();
    }

    @Override
    public Element getAsDOM(Document document) {
        Element u = super.getAsDOM(document);
        if (this.hasAnnot()) {
            Element ea = document.createElement("annotations");
            ea.appendChild(this.getAnnots().getAsDOM(document));
            u.appendChild(ea);
        }
        return u;
    }
}

