/*
 * Decompiled with CFR 0.152.
 */
package jason.asSyntax;

import jason.asSyntax.DefaultTerm;
import jason.asSyntax.NumberTerm;
import jason.asSyntax.Term;
import jason.asSyntax.VarTerm;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public final class NumberTermImpl
extends DefaultTerm
implements NumberTerm {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger(NumberTermImpl.class.getName());
    private final double value;

    public NumberTermImpl() {
        this.value = 0.0;
    }

    public NumberTermImpl(String sn) {
        double t = 0.0;
        try {
            t = Double.parseDouble(sn);
        }
        catch (Exception e2) {
            logger.log(Level.SEVERE, "Error setting number term value from " + sn, e2);
        }
        this.value = t;
    }

    public NumberTermImpl(double vl) {
        this.value = vl;
    }

    public NumberTermImpl(NumberTermImpl t) {
        this.value = t.value;
        this.srcInfo = t.srcInfo;
    }

    @Override
    public double solve() {
        return this.value;
    }

    @Override
    public NumberTerm clone() {
        return this;
    }

    @Override
    public boolean isNumeric() {
        return true;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && o instanceof Term && ((Term)o).isNumeric() && !((Term)o).isArithExpr()) {
            NumberTerm st = (NumberTerm)o;
            try {
                return this.solve() == st.solve();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    @Override
    protected int calcHashCode() {
        return 37 * (int)this.value;
    }

    @Override
    public int compareTo(Term o) {
        if (o instanceof VarTerm) {
            return o.compareTo(this) * -1;
        }
        if (o instanceof NumberTermImpl) {
            NumberTermImpl st = (NumberTermImpl)o;
            if (this.value > st.value) {
                return 1;
            }
            if (this.value < st.value) {
                return -1;
            }
            return 0;
        }
        return -1;
    }

    public String toString() {
        long r = Math.round(this.value);
        if (this.value == (double)r) {
            return String.valueOf(r);
        }
        return String.valueOf(this.value);
    }

    @Override
    public Element getAsDOM(Document document) {
        Element u = document.createElement("number-term");
        u.appendChild(document.createTextNode(this.toString()));
        return u;
    }
}

