/*
 * Decompiled with CFR 0.152.
 */
package jason.asSyntax;

import jason.asSemantics.Agent;
import jason.asSemantics.Unifier;
import jason.asSyntax.ListTerm;
import jason.asSyntax.LogExpr;
import jason.asSyntax.NumberTerm;
import jason.asSyntax.StringTerm;
import jason.asSyntax.Structure;
import jason.asSyntax.Term;
import jason.asSyntax.VarTerm;
import jason.asSyntax.parser.as2j;
import java.io.StringReader;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ListTermImpl
extends Structure
implements ListTerm {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger(ListTermImpl.class.getName());
    public static final String LIST_FUNCTOR = ".";
    private Term term;
    private Term next;

    public ListTermImpl() {
        super(LIST_FUNCTOR, 0);
    }

    private ListTermImpl(Term t, Term n) {
        super(LIST_FUNCTOR, 0);
        this.term = t;
        this.next = n;
    }

    public static ListTerm parseList(String sList) {
        as2j parser = new as2j(new StringReader(sList));
        try {
            return parser.list();
        }
        catch (Exception e2) {
            logger.log(Level.SEVERE, "Error parsing list " + sList, e2);
            return null;
        }
    }

    @Override
    public ListTerm clone() {
        ListTermImpl t = new ListTermImpl();
        if (this.term != null) {
            t.term = this.term.clone();
        }
        if (this.next != null) {
            t.next = this.next.clone();
        }
        t.hashCodeCache = this.hashCodeCache;
        return t;
    }

    @Override
    public ListTerm cloneLT() {
        return this.clone();
    }

    @Override
    public ListTerm capply(Unifier u) {
        ListTermImpl t = new ListTermImpl();
        if (this.term != null) {
            t.term = this.term.capply(u);
        }
        if (this.next != null) {
            t.next = this.next.capply(u);
        }
        return t;
    }

    @Override
    public ListTerm cloneLTShallow() {
        ListTermImpl t = new ListTermImpl();
        if (this.term != null) {
            t.term = this.term;
        }
        if (this.next != null) {
            t.next = this.next.clone();
        }
        return t;
    }

    @Override
    public boolean equals(Object t) {
        if (t == null) {
            return false;
        }
        if (t == this) {
            return true;
        }
        if (t instanceof Term && ((Term)t).isVar()) {
            return false;
        }
        if (t instanceof ListTerm) {
            ListTerm tAsList = (ListTerm)t;
            if (this.term == null && tAsList.getTerm() != null) {
                return false;
            }
            if (this.term != null && !this.term.equals(tAsList.getTerm())) {
                return false;
            }
            if (this.next == null && tAsList.getNext() != null) {
                return false;
            }
            if (this.next != null) {
                return this.next.equals(tAsList.getNext());
            }
            return true;
        }
        return false;
    }

    @Override
    public int calcHashCode() {
        int code = 37;
        if (this.term != null) {
            code += this.term.hashCode();
        }
        if (this.next != null) {
            code += this.next.hashCode();
        }
        return code;
    }

    @Override
    public int compareTo(Term o) {
        if (o instanceof VarTerm) {
            return o.compareTo(this) * -1;
        }
        if (o instanceof NumberTerm) {
            return 1;
        }
        if (o instanceof StringTerm) {
            return 1;
        }
        return super.compareTo(o);
    }

    @Override
    public void setTerm(Term t) {
        this.term = t;
    }

    @Override
    public Term getTerm() {
        return this.term;
    }

    @Override
    public void setNext(Term l) {
        this.next = l;
    }

    @Override
    public ListTerm getNext() {
        if (this.next instanceof ListTerm) {
            return (ListTerm)this.next;
        }
        return null;
    }

    @Override
    public int getArity() {
        if (this.isEmpty()) {
            return 0;
        }
        return 2;
    }

    @Override
    public Term getTerm(int i) {
        if (i == 0) {
            return this.term;
        }
        if (i == 1) {
            return this.next;
        }
        return null;
    }

    @Override
    public void setTerm(int i, Term t) {
        if (i == 0) {
            this.term = t;
        }
        if (i == 1) {
            this.next = t;
        }
    }

    @Override
    public List<Term> getTerms() {
        logger.warning("Do not use getTerms in lists!");
        ArrayList<Term> l = new ArrayList<Term>(2);
        if (this.term != null) {
            l.add(this.term);
        }
        if (this.next != null) {
            l.add(this.next);
        }
        return l;
    }

    @Override
    public void addTerm(Term t) {
        logger.warning("Do not use addTerm in lists! Use add(Term).");
    }

    @Override
    public int size() {
        if (this.isEmpty()) {
            return 0;
        }
        if (this.isTail()) {
            return 1;
        }
        return this.getNext().size() + 1;
    }

    @Override
    public boolean isAtom() {
        return false;
    }

    @Override
    public boolean isList() {
        return true;
    }

    @Override
    public boolean isLiteral() {
        return false;
    }

    @Override
    public boolean isEmpty() {
        return this.term == null;
    }

    @Override
    public boolean isEnd() {
        return this.isEmpty() || this.isTail();
    }

    @Override
    public boolean isGround() {
        if (this.isEmpty()) {
            return true;
        }
        if (this.isTail()) {
            return false;
        }
        if (this.term != null && this.term.isGround()) {
            return this.getNext().isGround();
        }
        return false;
    }

    @Override
    public Iterator<Unifier> logicalConsequence(Agent ag, Unifier un) {
        logger.log(Level.WARNING, "ListTermImpl cannot be used for logical consequence!", new Exception());
        return LogExpr.EMPTY_UNIF_LIST.iterator();
    }

    @Override
    public boolean isTail() {
        return this.next != null && this.next.isVar();
    }

    @Override
    public VarTerm getTail() {
        if (this.isTail()) {
            return (VarTerm)this.next;
        }
        if (this.next != null) {
            return this.getNext().getTail();
        }
        return null;
    }

    @Override
    public void setTail(VarTerm v) {
        if (this.getNext().isEmpty()) {
            this.next = v;
        } else {
            this.getNext().setTail(v);
        }
    }

    @Override
    public ListTerm getLast() {
        ListTerm r = this;
        while (!r.isEnd() && r.getNext() != null) {
            r = r.getNext();
        }
        return r;
    }

    @Override
    public ListTerm getPenultimate() {
        if (this.getNext() == null) {
            return null;
        }
        if (this.isTail()) {
            return this;
        }
        if (this.getNext().isEnd() && !this.getNext().isTail()) {
            return this;
        }
        return this.getNext().getPenultimate();
    }

    @Override
    public Term removeLast() {
        ListTerm p = this.getPenultimate();
        if (p != null) {
            Term b = p.getTerm();
            p.setTerm(null);
            p.setNext(null);
            return b;
        }
        return null;
    }

    @Override
    public ListTerm append(Term t) {
        if (this.isEmpty()) {
            this.term = t;
            this.next = new ListTermImpl();
            return this;
        }
        if (this.isTail()) {
            return null;
        }
        return this.getNext().append(t);
    }

    @Override
    public ListTerm insert(Term t) {
        ListTermImpl n = new ListTermImpl(this.term, this.next);
        this.term = t;
        this.next = n;
        return n;
    }

    @Override
    public ListTerm concat(ListTerm lt) {
        if (this.isEmpty()) {
            this.setValuesFrom(lt);
        } else if (((ListTerm)this.next).isEmpty()) {
            this.next = lt;
        } else {
            ((ListTerm)this.next).concat(lt);
        }
        return lt.getLast();
    }

    @Override
    public ListTerm reverse() {
        return this.reverse_internal(new ListTermImpl());
    }

    private ListTerm reverse_internal(ListTerm r) {
        if (this.isEmpty()) {
            return r;
        }
        if (this.isTail()) {
            r = new ListTermImpl(this.term.clone(), r);
            r.setTail((VarTerm)this.next.clone());
            return r;
        }
        return ((ListTermImpl)this.next).reverse_internal(new ListTermImpl(this.term.clone(), r));
    }

    @Override
    public ListTerm union(ListTerm lt) {
        TreeSet<Term> set = new TreeSet<Term>();
        set.addAll(lt);
        set.addAll(this);
        return this.setToList(set);
    }

    @Override
    public ListTerm intersection(ListTerm lt) {
        TreeSet<Term> set = new TreeSet<Term>();
        set.addAll(lt);
        set.retainAll(this);
        return this.setToList(set);
    }

    @Override
    public ListTerm difference(ListTerm lt) {
        TreeSet<Term> set = new TreeSet<Term>();
        set.addAll(this);
        set.removeAll(lt);
        return this.setToList(set);
    }

    private ListTerm setToList(Set<Term> set) {
        ListTermImpl result;
        ListTerm tail = result = new ListTermImpl();
        for (Term t : set) {
            tail = tail.append(t.clone());
        }
        return result;
    }

    @Override
    public Iterator<List<Term>> subSets(final int k) {
        return new Iterator<List<Term>>(){
            LinkedList<SubSetSearchState> open = null;
            Term[] thisAsArray = new Term[0];
            List<Term> next = null;

            @Override
            public boolean hasNext() {
                if (this.open == null) {
                    this.open = new LinkedList();
                    this.thisAsArray = ListTermImpl.this.getAsList().toArray(this.thisAsArray);
                    this.open.add(new SubSetSearchState(0, k, null, null));
                }
                if (this.next == null) {
                    this.getNext();
                }
                return this.next != null;
            }

            @Override
            public List<Term> next() {
                if (this.next == null) {
                    this.getNext();
                }
                List<Term> r = this.next;
                this.next = null;
                return r;
            }

            void getNext() {
                while (!this.open.isEmpty()) {
                    SubSetSearchState s = this.open.removeFirst();
                    if (s.d == 0) {
                        this.next = s.getAsList();
                        return;
                    }
                    s.addNexts();
                }
                this.next = null;
            }

            @Override
            public void remove() {
            }

            class SubSetSearchState {
                int pos;
                int d;
                Term value = null;
                SubSetSearchState f = null;

                SubSetSearchState(int pos, int d, Term t, SubSetSearchState father) {
                    this.pos = pos;
                    this.d = d;
                    this.value = t;
                    this.f = father;
                }

                void addNexts() {
                    int pSize = k - this.d + thisAsArray.length;
                    for (int i = thisAsArray.length - 1; i >= this.pos; --i) {
                        if (pSize - i < k) continue;
                        open.addFirst(new SubSetSearchState(i + 1, this.d - 1, thisAsArray[i], this));
                    }
                }

                List<Term> getAsList() {
                    LinkedList<Term> np = new LinkedList<Term>();
                    SubSetSearchState c = this;
                    while (c.value != null) {
                        np.addFirst(c.value);
                        c = c.f;
                    }
                    return np;
                }
            }
        };
    }

    @Override
    public Iterator<ListTerm> listTermIterator() {
        return new ListTermIterator<ListTerm>((ListTerm)this){

            @Override
            public ListTerm next() {
                this.moveNext();
                return this.current;
            }
        };
    }

    @Override
    public Iterator<Term> iterator() {
        return new ListTermIterator<Term>((ListTerm)this){

            @Override
            public boolean hasNext() {
                return this.nextLT != null && !this.nextLT.isEmpty() && this.nextLT.isList();
            }

            @Override
            public Term next() {
                this.moveNext();
                return this.current.getTerm();
            }
        };
    }

    @Override
    public List<Term> getAsList() {
        ArrayList<Term> l = new ArrayList<Term>();
        for (Term t : this) {
            l.add(t);
        }
        return l;
    }

    @Override
    public String toString() {
        StringBuilder s = new StringBuilder("[");
        ListTerm l = this;
        while (!l.isEmpty()) {
            s.append(l.getTerm());
            if (l.isTail()) {
                s.append('|');
                s.append(l.getTail());
                break;
            }
            if ((l = l.getNext()) == null) break;
            if (l.isEmpty()) continue;
            s.append(',');
        }
        s.append(']');
        return s.toString();
    }

    @Override
    public void add(int index, Term o) {
        if (index == 0) {
            this.insert(o);
        } else if (index > 0 && this.getNext() != null) {
            this.getNext().add(index - 1, o);
        }
    }

    @Override
    public boolean add(Term o) {
        return this.getLast().append(o) != null;
    }

    @Override
    public boolean addAll(Collection c) {
        if (c == null) {
            return false;
        }
        ListTerm lt = this;
        Iterator i = c.iterator();
        while (i.hasNext()) {
            lt = lt.append((Term)i.next());
        }
        return true;
    }

    @Override
    public boolean addAll(int index, Collection c) {
        Iterator i = c.iterator();
        int p = index;
        while (i.hasNext()) {
            this.add(p, (Term)i.next());
            ++p;
        }
        return true;
    }

    @Override
    public void clear() {
        this.term = null;
        this.next = null;
    }

    @Override
    public boolean contains(Object o) {
        if (this.term != null && this.term.equals(o)) {
            return true;
        }
        if (this.getNext() != null) {
            return this.getNext().contains(o);
        }
        return false;
    }

    @Override
    public boolean containsAll(Collection c) {
        boolean r = true;
        Iterator i = c.iterator();
        while (i.hasNext() && r) {
            r = r && this.contains(i.next());
        }
        return r;
    }

    @Override
    public Term get(int index) {
        if (index == 0) {
            return this.term;
        }
        if (this.getNext() != null) {
            return (Term)this.getNext().get(index - 1);
        }
        return null;
    }

    @Override
    public int indexOf(Object o) {
        int n;
        if (this.term.equals(o)) {
            return 0;
        }
        if (this.getNext() != null && (n = this.getNext().indexOf(o)) >= 0) {
            return n + 1;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object arg0) {
        return this.getAsList().lastIndexOf(arg0);
    }

    @Override
    public ListIterator<Term> listIterator() {
        return this.listIterator(0);
    }

    @Override
    public ListIterator<Term> listIterator(final int startIndex) {
        final ListTermImpl list2 = this;
        return new ListIterator<Term>(){
            int pos;
            int last;
            int size;
            {
                this.pos = startIndex;
                this.last = -1;
                this.size = ListTermImpl.this.size();
            }

            @Override
            public void add(Term o) {
                list2.add(this.last, o);
            }

            @Override
            public boolean hasNext() {
                return this.pos < this.size;
            }

            @Override
            public boolean hasPrevious() {
                return this.pos > startIndex;
            }

            @Override
            public Term next() {
                this.last = this.pos++;
                return ListTermImpl.this.get(this.last);
            }

            @Override
            public int nextIndex() {
                return this.pos + 1;
            }

            @Override
            public Term previous() {
                this.last = this.pos--;
                return ListTermImpl.this.get(this.last);
            }

            @Override
            public int previousIndex() {
                return this.pos - 1;
            }

            @Override
            public void remove() {
                list2.remove(this.last);
            }

            @Override
            public void set(Term o) {
                this.remove();
                this.add(o);
            }
        };
    }

    protected void setValuesFrom(ListTerm lt) {
        this.term = lt.getTerm();
        this.next = lt.getNext();
    }

    @Override
    public Term remove(int index) {
        if (index == 0) {
            Term bt = this.term;
            if (this.getNext() != null) {
                this.setValuesFrom(this.getNext());
            } else {
                this.clear();
            }
            return bt;
        }
        if (this.getNext() != null) {
            return (Term)this.getNext().remove(index - 1);
        }
        return null;
    }

    @Override
    public boolean remove(Object o) {
        if (this.term != null && this.term.equals(o)) {
            if (this.getNext() != null) {
                this.setValuesFrom(this.getNext());
            } else {
                this.clear();
            }
            return true;
        }
        if (this.getNext() != null) {
            return this.getNext().remove(o);
        }
        return false;
    }

    @Override
    public boolean removeAll(Collection c) {
        boolean r = true;
        Iterator i = c.iterator();
        while (i.hasNext() && r) {
            r = r && this.remove(i.next());
        }
        return r;
    }

    @Override
    public boolean retainAll(Collection c) {
        boolean r = true;
        for (Term t : this) {
            if (c.contains(t)) continue;
            r = r && this.remove(t);
        }
        return r;
    }

    @Override
    public Term set(int index, Term t) {
        if (index == 0) {
            this.term = t;
            return t;
        }
        if (this.getNext() != null) {
            return this.getNext().set(index - 1, t);
        }
        return null;
    }

    @Override
    public List<Term> subList(int arg0, int arg1) {
        return this.getAsList().subList(arg0, arg1);
    }

    @Override
    public Object[] toArray() {
        return this.toArray(new Object[0]);
    }

    @Override
    public <T> T[] toArray(T[] a) {
        int s = this.size();
        if (a.length < s) {
            a = (Object[])Array.newInstance(a.getClass().getComponentType(), s);
        }
        int i = 0;
        for (Term t : this) {
            a[i++] = t;
        }
        if (a.length > s) {
            a[s] = null;
        }
        return a;
    }

    @Override
    public Element getAsDOM(Document document) {
        Element u = document.createElement("list-term");
        String c = "";
        for (Term t : this) {
            Element et = t.getAsDOM(document);
            et.setAttribute("sep", c);
            c = ",";
            u.appendChild(et);
        }
        VarTerm tail = this.getTail();
        if (tail != null) {
            Element et = tail.getAsDOM(document);
            et.setAttribute("sep", "|");
            u.appendChild(et);
        }
        return u;
    }

    private abstract class ListTermIterator<T>
    implements Iterator<T> {
        ListTerm nextLT;
        ListTerm current = null;

        public ListTermIterator(ListTerm lt) {
            this.nextLT = lt;
        }

        @Override
        public boolean hasNext() {
            return this.nextLT != null;
        }

        public void moveNext() {
            this.current = this.nextLT;
            this.nextLT = this.nextLT.getNext();
        }

        @Override
        public void remove() {
            if (this.current != null && this.nextLT != null) {
                this.current.setTerm(this.nextLT.getTerm());
                this.current.setNext(this.nextLT.getNext());
                this.nextLT = this.current;
            }
        }
    }
}

