/*
 * Decompiled with CFR 0.152.
 */
package jason.architecture;

import com.sun.net.httpserver.Headers;
import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import com.sun.net.httpserver.HttpServer;
import jason.architecture.AgArch;
import jason.architecture.MindInspectorAgArch;
import jason.architecture.MindInspectorWeb;
import jason.asSemantics.Agent;
import jason.util.Config;
import jason.util.asl2html;
import jason.util.asl2xml;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.net.BindException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.Executors;
import org.w3c.dom.Document;

public class MindInspectorWebImpl
extends MindInspectorWeb {
    private HttpServer httpServer = null;
    private Map<String, List<Document>> histories = new TreeMap<String, List<Document>>();
    private Map<String, Integer> lastStepSeenByUser = new HashMap<String, Integer>();
    private Map<String, Agent> registeredAgents = new HashMap<String, Agent>();
    protected asl2xml mindInspectorTransformer = null;
    Map<String, Boolean> show = new HashMap<String, Boolean>();

    @Override
    public synchronized String startHttpServer() {
        try {
            this.httpServer = HttpServer.create(new InetSocketAddress(this.httpServerPort), 0);
            this.httpServer.setExecutor(Executors.newCachedThreadPool());
            this.httpServer.start();
            this.httpServerURL = "http://" + InetAddress.getLocalHost().getHostAddress() + ":" + this.httpServerPort;
            System.out.println("Jason Http Server running on " + this.httpServerURL);
            this.registerRootBrowserView();
            this.registerAgentsBrowserView();
            this.registerAgView("no_ag");
            return this.httpServerURL;
        }
        catch (BindException e2) {
            ++this.httpServerPort;
            return this.startHttpServer();
        }
        catch (Exception e3) {
            e3.printStackTrace();
            return null;
        }
    }

    private void registerRootBrowserView() {
        if (this.httpServer == null) {
            return;
        }
        try {
            this.httpServer.createContext("/", new HttpHandler(){

                @Override
                public void handle(HttpExchange exchange) throws IOException {
                    String requestMethod = exchange.getRequestMethod();
                    Headers responseHeaders = exchange.getResponseHeaders();
                    responseHeaders.set("Content-Type", "text/html");
                    exchange.sendResponseHeaders(200, 0L);
                    OutputStream responseBody = exchange.getResponseBody();
                    if (requestMethod.equalsIgnoreCase("GET")) {
                        String path = exchange.getRequestURI().getPath();
                        StringWriter so = new StringWriter();
                        if (path.length() < 2) {
                            so.append("<html><head><title>Jason Mind Inspector -- Web View</title></head><body>");
                            so.append("<iframe width=\"20%\" height=\"100%\" align=left src=\"/agents\" border=5 frameborder=0 ></iframe>");
                            so.append("<iframe width=\"78%\" height=\"100%\" align=left src=\"/agent-mind/no_ag\" name=\"am\" border=5 frameborder=0></iframe>");
                            so.append("</body></html>");
                        } else if (path.indexOf("agent-mind") >= 0) {
                            if (MindInspectorWebImpl.this.tryToIncludeMindInspectorForAg(path)) {
                                so.append("<meta http-equiv=\"refresh\" content=0>");
                            } else {
                                so.append("unkown agent!");
                            }
                        }
                        responseBody.write(so.toString().getBytes());
                    }
                    responseBody.close();
                }
            });
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    private String getAgNameFromPath(String path) {
        int nameStart = path.indexOf("agent-mind");
        if (nameStart < 0) {
            return null;
        }
        int nameEnd = path.indexOf("/", (nameStart += "agent-mind".length() + 1) + 1);
        if (nameEnd >= 0) {
            return path.substring(nameStart, nameEnd).trim();
        }
        return path.substring(nameStart).trim();
    }

    private boolean tryToIncludeMindInspectorForAg(String path) {
        try {
            AgArch arch;
            Agent ag = this.registeredAgents.get(this.getAgNameFromPath(path));
            if (ag != null && (arch = ag.getTS().getUserAgArch()) != null) {
                arch.getTS().getSettings().addOption("mindinspector", "web(cycle,html,no_history)");
                MindInspectorAgArch miArch = new MindInspectorAgArch();
                arch.insertAgArch(miArch);
                miArch.init();
                miArch.addAgState();
                return true;
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        return false;
    }

    private void registerAgentsBrowserView() {
        if (this.httpServer == null) {
            return;
        }
        try {
            this.httpServer.createContext("/agents", new HttpHandler(){

                @Override
                public void handle(HttpExchange exchange) throws IOException {
                    String requestMethod = exchange.getRequestMethod();
                    Headers responseHeaders = exchange.getResponseHeaders();
                    responseHeaders.set("Content-Type", "text/html");
                    exchange.sendResponseHeaders(200, 0L);
                    OutputStream responseBody = exchange.getResponseBody();
                    if (requestMethod.equalsIgnoreCase("GET")) {
                        responseBody.write(("<html><head><title>Jason (list of agents)</title><meta http-equiv=\"refresh\" content=\"" + MindInspectorWebImpl.this.refreshInterval + "\" ></head><body>").getBytes());
                        responseBody.write("<font size=\"+2\"><p style='color: red; font-family: arial;'>Agents</p></font>".getBytes());
                        for (String a : MindInspectorWebImpl.this.histories.keySet()) {
                            responseBody.write(("- <a href=\"/agent-mind/" + a + "/latest\" target=\"am\" style=\"font-family: arial; text-decoration: none\">" + a + "</a><br/>").getBytes());
                        }
                    }
                    responseBody.write("<hr/>by <a href=\"http://jason.sf.net\" target=\"_blank\">Jason</a>".getBytes());
                    responseBody.write("</body></html>".getBytes());
                    responseBody.close();
                }
            });
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    @Override
    public synchronized void registerAg(Agent ag) {
        String agName = ag.getTS().getUserAgArch().getAgName();
        if (!agName.equals("no-named")) {
            this.registeredAgents.put(agName, ag);
            this.histories.put(agName, new ArrayList());
        }
    }

    @Override
    public synchronized void removeAg(Agent ag) {
        String agName = ag.getTS().getUserAgArch().getAgName();
        this.registeredAgents.remove(agName);
        this.histories.remove(agName);
    }

    @Override
    public synchronized void addAgState(Agent ag, Document mind, boolean hasHistory) {
        String agName = ag.getTS().getUserAgArch().getAgName();
        List<Document> h = this.histories.get(agName);
        if (h == null) {
            h = new ArrayList<Document>();
            this.histories.put(agName, h);
        }
        if (h.isEmpty()) {
            this.registerAgView(agName);
        }
        if (hasHistory || h.isEmpty()) {
            h.add(mind);
        } else {
            h.set(0, mind);
        }
    }

    String registerAgView(final String agName) {
        if (this.httpServer == null) {
            return null;
        }
        try {
            String url = "/agent-mind/" + agName;
            this.httpServer.createContext(url, new HttpHandler(){

                @Override
                public void handle(HttpExchange exchange) throws IOException {
                    String requestMethod = exchange.getRequestMethod();
                    Headers responseHeaders = exchange.getResponseHeaders();
                    exchange.sendResponseHeaders(200, 0L);
                    OutputStream responseBody = exchange.getResponseBody();
                    responseHeaders.set("Content-Type", "text/html");
                    if (requestMethod.equalsIgnoreCase("GET")) {
                        try {
                            StringWriter so = new StringWriter();
                            so.append("<html><head><title>" + agName + "</title>");
                            String path = exchange.getRequestURI().getPath();
                            if (!MindInspectorWebImpl.this.getAgNameFromPath(path).equals(agName)) {
                                if (MindInspectorWebImpl.this.tryToIncludeMindInspectorForAg(path)) {
                                    so.append("<meta http-equiv=\"refresh\" content=0>");
                                } else {
                                    so.append("unkown agent!");
                                }
                            } else {
                                List h = (List)MindInspectorWebImpl.this.histories.get(agName);
                                if (h != null && h.size() > 0) {
                                    Document agState;
                                    int i = -1;
                                    exchange.getRemoteAddress();
                                    String query = exchange.getRequestURI().getRawQuery();
                                    String remote = exchange.getRemoteAddress().toString();
                                    if (path.endsWith("hide")) {
                                        MindInspectorWebImpl.this.show.put(query, false);
                                        Integer ii = (Integer)MindInspectorWebImpl.this.lastStepSeenByUser.get(remote);
                                        if (ii != null) {
                                            i = ii;
                                        }
                                    } else if (path.endsWith("show")) {
                                        MindInspectorWebImpl.this.show.put(query, true);
                                        Integer ii = (Integer)MindInspectorWebImpl.this.lastStepSeenByUser.get(remote);
                                        if (ii != null) {
                                            i = ii;
                                        }
                                    } else if (path.endsWith("clear")) {
                                        agState = (Document)h.get(h.size() - 1);
                                        h.clear();
                                        h.add(agState);
                                    } else {
                                        try {
                                            int pos = path.lastIndexOf("/");
                                            String n = path.substring(pos + 1).trim();
                                            i = new Integer(n);
                                        }
                                        catch (Exception e2) {
                                            // empty catch block
                                        }
                                    }
                                    if (i == -1) {
                                        so.append("<meta http-equiv=\"refresh\" content=\"" + MindInspectorWebImpl.this.refreshInterval + "\">");
                                        agState = (Document)h.get(h.size() - 1);
                                    } else {
                                        agState = (Document)h.get(i - 1);
                                    }
                                    try {
                                        MindInspectorWebImpl.this.lastStepSeenByUser.put(remote, i);
                                    }
                                    catch (Exception e3) {
                                        e3.printStackTrace();
                                    }
                                    so.append("</head><body>");
                                    if (h.size() > 1) {
                                        so.append("<a href=/agent-mind/" + agName + "/latest>latest state</a> ");
                                        for (i = h.size() - 1; i > 0; --i) {
                                            so.append("<a href=\"/agent-mind/" + agName + "/" + i + "\" style=\"text-decoration: none\">" + i + "</a> ");
                                        }
                                        so.append("<a href=\"/agent-mind/" + agName + "/clear\">clear history</a> ");
                                        so.append("<hr/>");
                                    }
                                    so.append(MindInspectorWebImpl.this.getAgStateAsString(agState, false));
                                } else {
                                    so.append("select an agent");
                                }
                            }
                            responseBody.write(so.toString().getBytes());
                            responseBody.write("</body></html>".getBytes());
                        }
                        catch (Exception e4) {
                            e4.printStackTrace();
                        }
                    }
                    responseBody.close();
                }
            });
            return this.httpServerURL + url;
        }
        catch (Exception e2) {
            e2.printStackTrace();
            return null;
        }
    }

    synchronized String getAgStateAsString(Document ag, boolean full) {
        try {
            if (this.mindInspectorTransformer == null) {
                this.mindInspectorTransformer = new asl2html("/xml/agInspection.xsl");
                this.show.put("bels", true);
                this.show.put("annots", Config.get().getBoolean("showAnnots"));
                this.show.put("rules", false);
                this.show.put("evt", true);
                this.show.put("mb", false);
                this.show.put("int", false);
                this.show.put("int-details", false);
                this.show.put("plan", false);
                this.show.put("plan-details", false);
            }
            for (String p : this.show.keySet()) {
                if (full) {
                    this.mindInspectorTransformer.setParameter("show-" + p, "true");
                    continue;
                }
                this.mindInspectorTransformer.setParameter("show-" + p, this.show.get(p) + "");
            }
            return this.mindInspectorTransformer.transform(ag);
        }
        catch (Exception e2) {
            e2.printStackTrace();
            return "Error XML transformation (MindInspector)";
        }
    }
}

