/*
 * Decompiled with CFR 0.152.
 */
package jason.architecture;

import jason.NoValueException;
import jason.architecture.AgArch;
import jason.architecture.MindInspectorWeb;
import jason.asSyntax.ASSyntax;
import jason.asSyntax.NumberTerm;
import jason.asSyntax.Structure;
import jason.control.ExecutionControlGUI;
import jason.util.Config;
import jason.util.asl2html;
import jason.util.asl2xml;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Toolkit;
import java.io.File;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTabbedPane;
import javax.swing.JTextPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.w3c.dom.Document;

public class MindInspectorAgArch
extends AgArch {
    protected boolean hasMindInspectorByCycle = false;
    protected int updateInterval = 0;
    protected static JFrame mindInspectorFrame = null;
    protected static JTabbedPane mindInspectorTab = null;
    protected JTextPane mindInspectorPanel = null;
    protected JSlider mindInspectorHistorySlider = null;
    protected JCheckBox mindInspectorFreeze = null;
    protected List<Document> mindInspectorHistory = null;
    protected asl2xml mindInspectorTransformer = null;
    protected String mindInspectorDirectory;
    Map<String, Boolean> show = new HashMap<String, Boolean>();
    Document agState = null;
    MindInspectorWeb webServer = null;
    boolean hasHistory = false;
    private String lastHistoryText = "";
    private int fileCounter = 0;
    private String previousShownText = "";

    @Override
    public void init() {
        this.setupMindInspector(this.getTS().getSettings().getUserParameter("mindinspector"));
    }

    @Override
    public void stop() {
        if (mindInspectorFrame != null) {
            mindInspectorFrame.dispose();
        }
        super.stop();
    }

    @Override
    public void reasoningCycleStarting() {
        if (this.hasMindInspectorByCycle) {
            this.addAgState();
        }
        super.reasoningCycleStarting();
    }

    protected void setupMindInspector(String configuration) {
        Structure sConf = null;
        try {
            sConf = ASSyntax.parseStructure(configuration);
        }
        catch (Exception e2) {
            this.getTS().getLogger().warning("The mindinspector argument does not parse as a predicate! " + configuration + " --  (see Jason FAQ) -- error: " + e2);
            return;
        }
        this.hasMindInspectorByCycle = sConf.getTerm(0).toString().equals("cycle");
        if (!this.hasMindInspectorByCycle) {
            try {
                this.updateInterval = (int)((NumberTerm)sConf.getTerm(0)).solve();
            }
            catch (NoValueException e1) {
                e1.printStackTrace();
            }
            new Thread("update agent mind inspector"){

                @Override
                public void run() {
                    try {
                        while (MindInspectorAgArch.this.isRunning()) {
                            Thread.sleep(MindInspectorAgArch.this.updateInterval);
                            MindInspectorAgArch.this.addAgState();
                        }
                    }
                    catch (Exception e2) {
                        e2.printStackTrace();
                    }
                }
            }.start();
        }
        if (sConf.getFunctor().equals("gui")) {
            this.createGUIMindInspector(sConf);
        } else if (sConf.getFunctor().equals("file")) {
            this.createFileMindInspector(sConf);
        } else if (sConf.getFunctor().equals("web")) {
            this.createWebMindInspector(sConf);
        }
    }

    private void createGUIMindInspector(Structure sConf) {
        boolean hasHistory;
        String format = "text/html";
        if (mindInspectorFrame == null) {
            mindInspectorFrame = new JFrame(ExecutionControlGUI.title);
            mindInspectorTab = new JTabbedPane(2);
            mindInspectorFrame.getContentPane().add(mindInspectorTab);
            Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
            mindInspectorFrame.setBounds(100, 200, (int)((double)(screenSize.width - 100) * 0.7), (int)((double)(screenSize.height - 100) * 0.9));
            mindInspectorFrame.setVisible(true);
        }
        this.mindInspectorPanel = new JTextPane();
        this.mindInspectorPanel.setEditable(false);
        this.mindInspectorPanel.setContentType(format);
        this.mindInspectorPanel.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent evt) {
                MindInspectorAgArch.this.hyperLink(evt);
            }
        });
        this.show.put("bels", true);
        this.show.put("annots", Config.get().getBoolean("showAnnots"));
        this.show.put("rules", false);
        this.show.put("evt", true);
        this.show.put("mb", false);
        this.show.put("int", false);
        this.show.put("int-details", false);
        this.show.put("plan", false);
        this.show.put("plan-details", false);
        boolean bl = hasHistory = sConf.getArity() == 3 && sConf.getTerm(2).toString().equals("history");
        if (!hasHistory) {
            mindInspectorTab.add(this.getAgName(), new JScrollPane(this.mindInspectorPanel));
        } else {
            this.mindInspectorHistory = new ArrayList<Document>();
            JPanel pHistory = new JPanel(new BorderLayout());
            pHistory.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Agent History", 1, 2));
            this.mindInspectorHistorySlider = new JSlider();
            this.mindInspectorHistorySlider.setMaximum(1);
            this.mindInspectorHistorySlider.setMinimum(0);
            this.mindInspectorHistorySlider.setValue(0);
            this.mindInspectorHistorySlider.setPaintTicks(true);
            this.mindInspectorHistorySlider.setPaintLabels(true);
            this.mindInspectorHistorySlider.setMajorTickSpacing(10);
            this.mindInspectorHistorySlider.setMinorTickSpacing(1);
            this.setupSlider();
            this.mindInspectorHistorySlider.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e2) {
                    try {
                        int c = MindInspectorAgArch.this.mindInspectorHistorySlider.getValue();
                        MindInspectorAgArch.this.showAgState(MindInspectorAgArch.this.mindInspectorHistory.get(c));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
            pHistory.add("Center", this.mindInspectorHistorySlider);
            this.mindInspectorFreeze = new JCheckBox();
            JPanel pf = new JPanel(new FlowLayout());
            pf.add(this.mindInspectorFreeze);
            pf.add(new JLabel("freeze"));
            pHistory.add("East", pf);
            JPanel pAg = new JPanel(new BorderLayout());
            pAg.add("Center", new JScrollPane(this.mindInspectorPanel));
            pAg.add("South", pHistory);
            mindInspectorTab.add(this.getAgName(), pAg);
        }
        if (format.equals("text/html")) {
            this.mindInspectorTransformer = new asl2html("/xml/agInspection.xsl");
        }
    }

    private void hyperLink(HyperlinkEvent evt) {
        if (evt.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            String uri = "show?";
            int pos = evt.getDescription().indexOf(uri);
            if (pos >= 0) {
                String par = evt.getDescription().substring(pos + uri.length());
                this.show.put(par, true);
            } else {
                uri = "hide?";
                pos = evt.getDescription().indexOf(uri);
                if (pos >= 0) {
                    String par = evt.getDescription().substring(pos + uri.length());
                    this.show.put(par, false);
                }
            }
            this.showAgState(this.agState);
        }
    }

    private void setupSlider() {
        int size = this.mindInspectorHistory.size() - 1;
        if (size < 0) {
            return;
        }
        Hashtable<Integer, JLabel> labelTable = new Hashtable<Integer, JLabel>();
        labelTable.put(0, new JLabel("mind 0"));
        labelTable.put(size, new JLabel("mind " + size));
        this.mindInspectorHistorySlider.setLabelTable(labelTable);
        this.mindInspectorHistorySlider.setMaximum(size);
    }

    private void createFileMindInspector(Structure sConf) {
        this.mindInspectorDirectory = sConf.getArity() <= 2 ? "log" : sConf.getTerm(2).toString();
        this.mindInspectorTransformer = new asl2xml();
        this.mindInspectorDirectory = this.mindInspectorDirectory + "/" + this.getAgName();
        File dirmind = new File(this.mindInspectorDirectory);
        if (!dirmind.exists()) {
            dirmind.mkdirs();
        }
        int c = 0;
        String d = this.mindInspectorDirectory + "/run-" + c;
        while (new File(d).exists()) {
            d = this.mindInspectorDirectory + "/run-" + c++;
        }
        this.mindInspectorDirectory = d;
        new File(this.mindInspectorDirectory).mkdirs();
    }

    private void createWebMindInspector(Structure sConf) {
        this.webServer = MindInspectorWeb.get();
        this.hasHistory = sConf.getArity() == 3 && sConf.getTerm(2).toString().equals("history");
        this.mindInspectorTransformer = new asl2html("/xml/agInspection.xsl");
    }

    protected void addAgState() {
        try {
            Document state = this.getTS().getAg().getAgState();
            String sMind = this.getAgStateAsString(state, true);
            if (sMind.equals(this.lastHistoryText)) {
                return;
            }
            this.lastHistoryText = sMind;
            if (this.mindInspectorPanel != null) {
                if (this.mindInspectorFreeze == null || !this.mindInspectorFreeze.isSelected()) {
                    this.showAgState(state);
                }
                if (this.mindInspectorHistory != null) {
                    this.mindInspectorHistory.add(state);
                    this.setupSlider();
                    this.mindInspectorHistorySlider.setValue(this.mindInspectorHistory.size() - 1);
                }
            } else if (this.mindInspectorDirectory != null) {
                String filename = String.format("%6d.xml", this.fileCounter++).replaceAll(" ", "0");
                FileWriter outmind = new FileWriter(new File(this.mindInspectorDirectory + "/" + filename));
                outmind.write(sMind);
                outmind.close();
            } else if (this.webServer != null) {
                this.webServer.addAgState(this.getTS().getAg(), state, this.hasHistory);
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    void showAgState(Document state) {
        if (state != null) {
            try {
                String sMind = this.getAgStateAsString(state, false);
                if (sMind.equals(this.previousShownText)) {
                    return;
                }
                this.previousShownText = sMind;
                this.agState = state;
                this.mindInspectorPanel.setText(sMind);
            }
            catch (Exception e2) {
                this.mindInspectorPanel.setText("Error in XML transformation!" + e2);
                e2.printStackTrace();
            }
        }
    }

    String getAgStateAsString(Document ag, boolean full) {
        try {
            for (String p : this.show.keySet()) {
                if (full) {
                    this.mindInspectorTransformer.setParameter("show-" + p, "true");
                    continue;
                }
                this.mindInspectorTransformer.setParameter("show-" + p, this.show.get(p) + "");
            }
            return this.mindInspectorTransformer.transform(ag);
        }
        catch (Exception e2) {
            if (this.mindInspectorPanel != null) {
                this.mindInspectorPanel.setText("Error in XML transformation!" + e2);
            }
            e2.printStackTrace();
            return "Error XML transformation (MindInspector)";
        }
    }
}

