/*
 * Decompiled with CFR 0.152.
 */
package jade.util;

import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.Map;
import java.util.Set;

public class ThreadDumpManager {
    public static String dumpAllThreads() {
        ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
        StringBuffer sb = new StringBuffer();
        Thread.currentThread();
        Map<Thread, StackTraceElement[]> allStackTraces = Thread.getAllStackTraces();
        Set<Thread> threads = allStackTraces.keySet();
        for (Thread thread : threads) {
            ThreadInfo threadInfo = threadMXBean.getThreadInfo(thread.getId());
            sb.append(ThreadDumpManager.dumpThread("", thread, threadInfo));
        }
        long[] threadIds = threadMXBean.findMonitorDeadlockedThreads();
        if (threadIds != null) {
            ThreadInfo[] threadInfoInDeadlock = threadMXBean.getThreadInfo(threadIds);
            sb.append("\n\n\n**************** WARNING ****************: Threads ");
            for (int i = 0; i < threadInfoInDeadlock.length; ++i) {
                sb.append(" \"" + threadInfoInDeadlock[i].getThreadName() + "\"");
            }
            sb.append(" are in deadlock!");
        }
        return sb.toString();
    }

    public static String dumpThread(String prefix2, Thread t) {
        ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
        ThreadInfo threadInfo = threadMXBean.getThreadInfo(t.getId());
        return ThreadDumpManager.dumpThread(prefix2, t, threadInfo);
    }

    public static String dumpThread(String prefix2, Thread t, ThreadInfo threadInfo) {
        String lockedOn;
        StringBuffer sb = new StringBuffer();
        sb.append(prefix2 + "\"" + t.getName() + "\"");
        if (t.isDaemon()) {
            sb.append(" daemon");
        }
        String threadId = threadInfo != null ? String.valueOf(threadInfo.getThreadId()) : String.valueOf(t.getId());
        sb.append(" tid=" + threadId);
        sb.append(" " + t.getState().toString().toLowerCase());
        if (threadInfo != null && (lockedOn = threadInfo.getLockName()) != null) {
            String lockedBy = threadInfo.getLockOwnerName();
            sb.append(" on " + lockedOn);
            if (lockedBy != null) {
                sb.append(" held by " + lockedBy);
            }
        }
        sb.append("\n");
        StackTraceElement[] ste = t.getStackTrace();
        for (int i = 0; i < ste.length; ++i) {
            sb.append(prefix2 + "\t at " + ste[i] + "\n");
        }
        return sb.toString();
    }
}

