/*
 * Decompiled with CFR 0.152.
 */
package jade.util;

import jade.util.ClassFinderFilter;
import jade.util.ClassFinderListener;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class ClassFinder {
    private Class searchClass = null;
    private Map locations = new HashMap();
    private Map results = new HashMap();
    private List errors = new ArrayList();
    private boolean working = false;
    private ClassFinderListener listener;
    private ClassFinderFilter filter;
    private boolean useClassPathLocations;
    private static final FileFilter DIRECTORIES_ONLY = new FileFilter(){

        public boolean accept(File f) {
            return f.exists() && f.isDirectory();
        }
    };
    private static final FileFilter CLASSES_ONLY = new FileFilter(){

        public boolean accept(File f) {
            if (f.exists() && f.isFile() && f.canRead()) {
                return f.getName().endsWith(".class");
            }
            return false;
        }
    };
    private static final Comparator URL_COMPARATOR = new Comparator(){

        public int compare(Object u1, Object u2) {
            return String.valueOf(u1).compareTo(String.valueOf(u2));
        }
    };
    private static final Comparator CLASS_COMPARATOR = new Comparator(){

        public int compare(Object c1, Object c2) {
            return String.valueOf(c1).compareTo(String.valueOf(c2));
        }
    };

    public boolean isWorking() {
        return this.working;
    }

    public ClassFinder() {
        this.useClassPathLocations = true;
        this.refreshLocations();
    }

    public ClassFinder(String[] jarNames) {
        this.useClassPathLocations = false;
        this.locations = new HashMap();
        for (String jarName : jarNames) {
            File jarFile = new File(jarName);
            if (!jarFile.exists()) continue;
            this.includeJar(jarFile, this.locations);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void refreshLocations() {
        if (this.useClassPathLocations) {
            Map map = this.locations;
            synchronized (map) {
                this.locations = this.getClasspathLocations();
            }
        }
    }

    public final Vector findSubclasses(String fqcn) {
        return this.findSubclasses(fqcn, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final Vector findSubclasses(String fqcn, ClassFinderListener aListener, ClassFinderFilter aFilter) {
        Map map = this.locations;
        synchronized (map) {
            Map map2 = this.results;
            synchronized (map2) {
                Vector vector;
                this.listener = aListener;
                this.filter = aFilter;
                try {
                    this.working = true;
                    this.searchClass = null;
                    this.errors = new ArrayList();
                    this.results = new TreeMap(CLASS_COMPARATOR);
                    if (fqcn.startsWith(".") || fqcn.endsWith(".")) {
                        Vector vector2 = new Vector();
                        Object var9_9 = null;
                        this.working = false;
                        return vector2;
                    }
                    try {
                        this.searchClass = this.callClassForName(fqcn);
                    }
                    catch (Throwable t) {
                        this.errors.add(t);
                        Vector vector3 = new Vector();
                        Object var9_10 = null;
                        this.working = false;
                        return vector3;
                    }
                    vector = this.findSubclasses(this.searchClass, this.locations);
                }
                catch (Throwable throwable) {
                    Object var9_12 = null;
                    this.working = false;
                    throw throwable;
                }
                Object var9_11 = null;
                this.working = false;
                return vector;
            }
        }
    }

    public final List getErrors() {
        return new ArrayList(this.errors);
    }

    public final URL getLocationOf(Class cls) {
        if (this.results != null) {
            return (URL)this.results.get(cls);
        }
        return null;
    }

    public final Map getClasspathLocations() {
        TreeMap map = new TreeMap(URL_COMPARATOR);
        File file = null;
        String pathSep = System.getProperty("path.separator");
        String classpath = System.getProperty("java.class.path");
        StringTokenizer st = new StringTokenizer(classpath, pathSep);
        while (st.hasMoreTokens()) {
            String path = st.nextToken();
            file = new File(path);
            this.include(null, file, map);
        }
        for (URL url : map.keySet()) {
        }
        return map;
    }

    private final void include(String name, File file, Map map) {
        if (!file.exists()) {
            return;
        }
        if (!file.isDirectory()) {
            this.includeJar(file, map);
            return;
        }
        name = name == null ? "" : name + ".";
        File[] dirs = file.listFiles(DIRECTORIES_ONLY);
        for (int i = 0; i < dirs.length; ++i) {
            try {
                map.put(new URL("file://" + dirs[i].getCanonicalPath()), name + dirs[i].getName());
            }
            catch (IOException ioe) {
                return;
            }
            this.include(name + dirs[i].getName(), dirs[i], map);
        }
    }

    private void includeJar(File file, Map map) {
        if (file.isDirectory()) {
            return;
        }
        URL jarURL = null;
        JarFile jar = null;
        try {
            String canonicalPath = file.getCanonicalPath();
            if (!canonicalPath.startsWith("/")) {
                canonicalPath = "/" + canonicalPath;
            }
            jarURL = new URL("file:" + canonicalPath);
            jarURL = new URL("jar:" + jarURL.toExternalForm() + "!/");
            JarURLConnection conn = (JarURLConnection)jarURL.openConnection();
            jar = conn.getJarFile();
        }
        catch (Exception e2) {
            return;
        }
        if (jar == null || jarURL == null) {
            return;
        }
        map.put(jarURL, "");
        Enumeration<JarEntry> e3 = jar.entries();
        while (e3.hasMoreElements()) {
            JarEntry entry = e3.nextElement();
            if (!entry.isDirectory() || entry.getName().toUpperCase().equals("META-INF/")) continue;
            try {
                map.put(new URL(jarURL.toExternalForm() + entry.getName()), ClassFinder.packageNameFor(entry));
            }
            catch (MalformedURLException murl) {}
        }
    }

    private static String packageNameFor(JarEntry entry) {
        if (entry == null) {
            return "";
        }
        String s = entry.getName();
        if (s == null) {
            return "";
        }
        if (s.length() == 0) {
            return s;
        }
        if (s.startsWith("/")) {
            s = s.substring(1, s.length());
        }
        if (s.endsWith("/")) {
            s = s.substring(0, s.length() - 1);
        }
        return s.replace('/', '.');
    }

    private final Vector findSubclasses(Class superClass, Map locations) {
        TreeSet setOfClasses = new TreeSet(CLASS_COMPARATOR);
        Vector v = new Vector();
        for (URL url : locations.keySet()) {
            this.findSubclasses(url, (String)locations.get(url), superClass, setOfClasses);
        }
        Iterator iterator = setOfClasses.iterator();
        while (iterator.hasNext()) {
            v.add(iterator.next());
        }
        return v;
    }

    private void manageClass(Set setOfClasses, Class superClass, Class c, URL url) {
        boolean include2 = superClass.isAssignableFrom(c);
        if (include2 && this.filter != null) {
            include2 = this.filter.include(superClass, c);
        }
        if (include2) {
            this.results.put(c, url);
            if (setOfClasses.add(c) && this.listener != null) {
                this.listener.add(c, url);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void findSubclasses(URL location, String packageName, Class superClass, Set setOfClasses) {
        Map map = this.results;
        synchronized (map) {
            String fqcn = this.searchClass.getName();
            ArrayList<URL> knownLocations = new ArrayList<URL>();
            knownLocations.add(location);
            for (int loc = 0; loc < knownLocations.size(); ++loc) {
                URL url = (URL)knownLocations.get(loc);
                File directory = new File(url.getFile());
                if (directory.exists()) {
                    File[] files = directory.listFiles(CLASSES_ONLY);
                    for (int i = 0; i < files.length; ++i) {
                        String filename = files[i].getName();
                        String classname = filename.substring(0, filename.length() - 6);
                        try {
                            if (fqcn.equals(packageName + "." + classname)) continue;
                            Class c = this.callClassForName(packageName + "." + classname);
                            this.manageClass(setOfClasses, superClass, c, url);
                            continue;
                        }
                        catch (Throwable t) {
                            this.errors.add(t);
                        }
                    }
                    continue;
                }
                try {
                    JarURLConnection conn = (JarURLConnection)url.openConnection();
                    JarFile jarFile = conn.getJarFile();
                    Enumeration<JarEntry> e2 = jarFile.entries();
                    while (e2.hasMoreElements()) {
                        JarEntry entry = e2.nextElement();
                        String entryname = entry.getName();
                        if (entry.isDirectory() || !entryname.endsWith(".class")) continue;
                        String classname = entryname.substring(0, entryname.length() - 6);
                        if (classname.startsWith("/")) {
                            classname = classname.substring(1);
                        }
                        classname = classname.replace('/', '.');
                        try {
                            if (fqcn.equals(classname)) continue;
                            Class c = this.callClassForName(classname);
                            this.manageClass(setOfClasses, superClass, c, url);
                        }
                        catch (Throwable t) {
                            this.errors.add(t);
                        }
                    }
                    continue;
                }
                catch (IOException ioex) {
                    this.errors.add(ioex);
                }
            }
        }
    }

    private Class callClassForName(String classname) throws ClassNotFoundException {
        return Class.forName(classname, false, this.getClass().getClassLoader());
    }
}

