/*
 * Decompiled with CFR 0.152.
 */
package jade.tools.rma;

import jade.core.Agent;
import jade.gui.ClassSelectionDialog;
import jade.util.ClassFinderFilter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;

public class StartDialog
extends JDialog
implements ActionListener {
    protected static ExtTextField extTextFieldAgentName;
    protected static Panel panelClassname;
    protected static JButton jButtonSelectClassname;
    protected static JComboBox jComboBoxClassnameCombo;
    protected static DefaultComboBoxModel modelClassnameCombo;
    protected static JTextField jTextFieldContainer;
    protected static JTextField jTextFieldArguments;
    protected static JTextField jTextFieldAgentUser;
    protected static JLabel jLabelAgentName;
    protected static JLabel jLabelClassname;
    protected static JLabel jLabelArguments;
    protected static JLabel jLabelOwner;
    protected static JLabel jLabelContainer;
    protected static JButton jButtonOk;
    protected static JButton jButtonCancel;
    private static final String ttAgentName = "Name of the Agent to start";
    private static final String ttClassname = "Class Name of the Agent to start";
    private static final String ttArguments = "Arguments passed to the agent constructor";
    private static final String ttOwner = "The user under which the agent has to be started";
    private static final String ttContainer = "Container on which the Agent will start";
    private static final String ttSelectClassname = "Search in classpath for classes extending Agent";
    public static final int OK_BUTTON = 0;
    public static final int CANCEL_BUTTON = 1;
    private static StartDialog dialog;
    private static int choice;
    private static String classname;
    private static String agentname;
    private ClassSelectionDialog csd;

    protected StartDialog() {
        super((Frame)null, "Insert Start Parameters", true);
        this.getContentPane().setLayout(new GridLayout(6, 2));
        this.getContentPane().add(jLabelAgentName);
        this.getContentPane().add(extTextFieldAgentName);
        this.getContentPane().add(jLabelClassname);
        this.getContentPane().add(panelClassname);
        this.getContentPane().add(jLabelArguments);
        this.getContentPane().add(jTextFieldArguments);
        this.getContentPane().add(jLabelOwner);
        this.getContentPane().add(jTextFieldAgentUser);
        this.getContentPane().add(jLabelContainer);
        this.getContentPane().add(jTextFieldContainer);
        jButtonOk.addActionListener(this);
        jButtonCancel.addActionListener(this);
        jButtonSelectClassname.addActionListener(this);
        jComboBoxClassnameCombo.addActionListener(this);
        extTextFieldAgentName.setStartDialog(this);
        this.getContentPane().add(jButtonOk);
        this.getContentPane().add(jButtonCancel);
    }

    public void doShow(String agentNameP) {
        extTextFieldAgentName.setText(agentNameP);
        jComboBoxClassnameCombo.setSelectedItem(classname);
        jButtonOk.setEnabled(false);
        this.pack();
        this.setLocationRelativeTo(null);
        this.setVisible(true);
    }

    public Dimension getPreferredSize() {
        return new Dimension(540, 150);
    }

    private void insertOrMoveComboItem(String s) {
        if (s != null) {
            s = s.trim();
            for (int i = modelClassnameCombo.getSize() - 1; i >= 0; --i) {
                if (!s.equals(modelClassnameCombo.getElementAt(i))) continue;
                modelClassnameCombo.removeElementAt(i);
            }
            modelClassnameCombo.insertElementAt(s, 0);
        }
    }

    void updateOkButtonEnabled() {
        String selClassname = (String)jComboBoxClassnameCombo.getSelectedItem();
        String currAgentName = extTextFieldAgentName.getText();
        boolean okEnabled = selClassname != null && selClassname.length() > 0 && currAgentName != null && currAgentName.length() > 0;
        jButtonOk.setEnabled(okEnabled);
    }

    public void actionPerformed(ActionEvent evt) {
        if (evt.getSource() == jComboBoxClassnameCombo) {
            this.updateOkButtonEnabled();
        } else if (evt.getSource() == jButtonSelectClassname) {
            if (this.csd == null) {
                this.csd = new ClassSelectionDialog((Dialog)this, "Select Agent class", Agent.class.getName(), new AgentClassFilter());
            }
            ArrayList<String> l = new ArrayList<String>(1);
            l.add(0, "jade.core.Agent");
            if (this.csd.doShow(l) == 1) {
                StartDialog.setClassName(this.csd.getSelectedClassname());
            }
        } else {
            choice = 1;
            if (evt.getSource() == jButtonOk) {
                choice = 0;
                agentname = extTextFieldAgentName.getText();
                classname = (String)jComboBoxClassnameCombo.getSelectedItem();
                this.insertOrMoveComboItem(classname);
            }
            this.dispose();
        }
    }

    public static int showStartNewDialog(String containerName, Frame owner) {
        choice = 1;
        extTextFieldAgentName.setEditable(true);
        jTextFieldContainer.setEditable(false);
        StartDialog.setContainer(containerName);
        dialog.doShow("");
        return choice;
    }

    public static String getAgentName() {
        return agentname;
    }

    public static String getClassName() {
        return classname;
    }

    public static String getArguments() {
        return jTextFieldArguments.getText().trim();
    }

    public static String getAgentUser() {
        return jTextFieldAgentUser.getText().trim();
    }

    public static String getContainer() {
        return jTextFieldContainer.getText();
    }

    public static void setAgentName(String agentNameP) {
        extTextFieldAgentName.setText(agentNameP);
    }

    public static void setClassName(String classNameP) {
        jComboBoxClassnameCombo.setSelectedItem(classNameP);
    }

    public static void setContainer(String containerP) {
        jTextFieldContainer.setText(containerP);
    }

    static {
        jLabelAgentName = new JLabel("Agent Name");
        jLabelClassname = new JLabel("Class Name");
        jLabelArguments = new JLabel("Arguments");
        jLabelOwner = new JLabel("Owner");
        jLabelContainer = new JLabel("Container");
        jButtonOk = new JButton("OK");
        jButtonCancel = new JButton("Cancel");
        choice = 1;
        classname = "";
        agentname = "";
        extTextFieldAgentName = new ExtTextField();
        extTextFieldAgentName.setEditable(false);
        extTextFieldAgentName.setToolTipText(ttAgentName);
        jLabelAgentName.setToolTipText(ttAgentName);
        jLabelClassname.setToolTipText(ttClassname);
        modelClassnameCombo = new DefaultComboBoxModel();
        jComboBoxClassnameCombo = new JComboBox(modelClassnameCombo);
        jComboBoxClassnameCombo.setEditable(true);
        jComboBoxClassnameCombo.setToolTipText(ttClassname);
        jComboBoxClassnameCombo.setSelectedItem(classname);
        jButtonSelectClassname = new JButton("...");
        jButtonSelectClassname.setToolTipText(ttSelectClassname);
        jButtonSelectClassname.setPreferredSize(new Dimension(20, 0));
        panelClassname = new Panel(new BorderLayout());
        panelClassname.add((Component)jComboBoxClassnameCombo, "Center");
        panelClassname.add((Component)jButtonSelectClassname, "East");
        jTextFieldArguments = new JTextField();
        jTextFieldArguments.setEditable(true);
        jTextFieldArguments.setToolTipText(ttArguments);
        jLabelArguments.setToolTipText(ttArguments);
        jTextFieldAgentUser = new JTextField();
        jTextFieldAgentUser.setEditable(true);
        jTextFieldAgentUser.setToolTipText(ttOwner);
        jLabelOwner.setToolTipText(ttOwner);
        jTextFieldContainer = new JTextField("0");
        jTextFieldContainer.setEditable(true);
        jTextFieldContainer.setToolTipText(ttContainer);
        jLabelContainer.setToolTipText(ttContainer);
        dialog = new StartDialog();
    }

    private static class ExtTextField
    extends JTextField
    implements ActionListener,
    DocumentListener {
        private StartDialog startDialog;

        public ExtTextField() {
            super(0);
            this.addActionListener(this);
            Document doc = this.getDocument();
            doc.addDocumentListener(this);
        }

        public void setStartDialog(StartDialog startDialog) {
            this.startDialog = startDialog;
        }

        public void actionPerformed(ActionEvent e2) {
        }

        public void insertUpdate(DocumentEvent e2) {
            this.startDialog.updateOkButtonEnabled();
        }

        public void removeUpdate(DocumentEvent e2) {
            this.startDialog.updateOkButtonEnabled();
        }

        public void changedUpdate(DocumentEvent e2) {
        }
    }

    private static class AgentClassFilter
    implements ClassFinderFilter {
        private static final String[] excluded = new String[]{"jade.domain.ams", "jade.tools.ToolNotifier", "jade.tools.logging.LogHelperAgent"};

        private AgentClassFilter() {
        }

        public boolean include(Class superClazz, Class clazz) {
            boolean doInclude;
            String clazzName = clazz.getName();
            int modifiers = clazz.getModifiers();
            boolean bl = doInclude = (modifiers & 0x600) == 0;
            if (doInclude && clazzName.startsWith("jade.core")) {
                doInclude = Agent.class.getName().equals(clazzName);
            }
            if (doInclude) {
                for (int i = 0; i < excluded.length; ++i) {
                    if (!excluded[i].equals(clazzName)) continue;
                    doInclude = false;
                    break;
                }
            }
            return doInclude;
        }
    }
}

