/*
 * Decompiled with CFR 0.152.
 */
package jade.tools.rma;

import jade.core.AID;
import jade.gui.APDescriptionPanel;
import jade.gui.AgentTree;
import jade.lang.acl.ACLMessage;
import jade.lang.acl.ACLParser;
import jade.lang.acl.ParseException;
import jade.tools.rma.MainWindow;
import jade.tools.rma.PopupMouser;
import jade.tools.rma.TablePanel;
import jade.tools.rma.rma;
import jade.util.Logger;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;

class MainPanel
extends JPanel
implements DropTargetListener,
TreeSelectionListener {
    private APDescriptionPanel APDescription_panel;
    AgentTree treeAgent;
    private TablePanel table;
    private JScrollPane scroll;
    private JSplitPane pan;
    private JSplitPane pane;
    private MainWindow mainWnd;
    private PopupMouser popM;
    private rma myRma = null;
    private static Logger logger = Logger.getMyLogger(MainPanel.class.getName());

    public MainPanel(rma anRMA, MainWindow mainWnd) {
        this.myRma = anRMA;
        this.table = new TablePanel();
        this.mainWnd = mainWnd;
        Font f = new Font("SanSerif", 0, 14);
        this.setFont(f);
        this.setLayout(new BorderLayout(10, 10));
        this.treeAgent = new AgentTree(f);
        new DropTarget(this.treeAgent.tree, this);
        this.pan = new JSplitPane(1, new JScrollPane(this.treeAgent.tree), this.table.createTable());
        this.pan.setContinuousLayout(true);
        this.add(this.pan);
        this.treeAgent.tree.addTreeSelectionListener(this);
    }

    public void dragOver(DropTargetDragEvent p1) {
        if (logger.isLoggable(Logger.FINEST)) {
            logger.log(Logger.FINEST, "dragOver");
        }
    }

    public void dropActionChanged(DropTargetDragEvent p1) {
        if (logger.isLoggable(Logger.FINEST)) {
            logger.log(Logger.FINEST, "dropActionChanged");
        }
    }

    public void dragEnter(DropTargetDragEvent dragEvent) {
        if (this.treeAgent.tree.getSelectionCount() < 1) {
            if (logger.isLoggable(Logger.FINEST)) {
                logger.log(Logger.FINEST, "No agents selected!");
            }
            dragEvent.rejectDrag();
        }
    }

    public void dragExit(DropTargetEvent p1) {
        if (logger.isLoggable(Logger.FINEST)) {
            logger.log(Logger.FINEST, "dragExit");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void drop(DropTargetDropEvent dropEvent) {
        List fileList;
        TreePath[] selectedItems;
        block18: {
            Object var7_6;
            boolean completionStatus = false;
            selectedItems = null;
            fileList = null;
            try {
                try {
                    selectedItems = this.treeAgent.tree.getSelectionPaths();
                    if (selectedItems == null) {
                        if (logger.isLoggable(Logger.WARNING)) {
                            logger.log(Logger.WARNING, "No agents selected!");
                        }
                        dropEvent.rejectDrop();
                        dropEvent.dropComplete(completionStatus);
                        Object var7_5 = null;
                        dropEvent.dropComplete(completionStatus);
                        return;
                    }
                    dropEvent.acceptDrop(1);
                    Transferable xferInfo = dropEvent.getTransferable();
                    fileList = (List)xferInfo.getTransferData(DataFlavor.javaFileListFlavor);
                    completionStatus = true;
                }
                catch (UnsupportedFlavorException exc) {
                    completionStatus = false;
                    var7_6 = null;
                    dropEvent.dropComplete(completionStatus);
                    break block18;
                }
                catch (IOException exc) {
                    if (logger.isLoggable(Logger.WARNING)) {
                        logger.log(Logger.WARNING, "DragAndDrop operation failed: " + exc);
                    }
                    completionStatus = false;
                    var7_6 = null;
                    dropEvent.dropComplete(completionStatus);
                    break block18;
                }
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                dropEvent.dropComplete(completionStatus);
                throw throwable;
            }
            var7_6 = null;
            dropEvent.dropComplete(completionStatus);
        }
        if (fileList != null && selectedItems != null) {
            Iterator fileItor = fileList.iterator();
            ACLParser aclParser = ACLParser.create();
            while (fileItor.hasNext()) {
                try {
                    File f = (File)fileItor.next();
                    FileReader aclMsgFile = new FileReader(f);
                    ACLMessage msg = aclParser.parse(aclMsgFile);
                    msg.clearAllReceiver();
                    msg.clearAllReplyTo();
                    msg.setSender(this.myRma.getAID());
                    for (int i = 0; i < selectedItems.length; ++i) {
                        Object lastPath = selectedItems[i].getLastPathComponent();
                        if (!(lastPath instanceof AgentTree.Node)) continue;
                        AgentTree.Node node = (AgentTree.Node)lastPath;
                        AID recipient = new AID(node.getName(), true);
                        msg.addReceiver(recipient);
                    }
                    this.myRma.send(msg);
                }
                catch (IOException exc) {
                    if (!logger.isLoggable(Logger.WARNING)) continue;
                    logger.log(Logger.WARNING, "Unable to send message: " + exc);
                }
                catch (ParseException exc) {
                    if (!logger.isLoggable(Logger.WARNING)) continue;
                    logger.log(Logger.WARNING, "Unable to send message: " + exc);
                }
                catch (Exception exc) {
                    if (!logger.isLoggable(Logger.WARNING)) continue;
                    logger.log(Logger.WARNING, "Unable to send message: " + exc);
                }
                catch (Error exc) {
                    if (!logger.isLoggable(Logger.WARNING)) continue;
                    logger.log(Logger.WARNING, "Unable to send message: " + exc);
                }
                catch (Throwable exc) {
                    if (!logger.isLoggable(Logger.WARNING)) continue;
                    logger.log(Logger.WARNING, "Unable to send message: " + exc);
                }
            }
        }
    }

    public void valueChanged(TreeSelectionEvent e2) {
        TreePath[] paths = this.treeAgent.tree.getSelectionPaths();
        if (paths != null) {
            ArrayList<TreePath> agentPaths = new ArrayList<TreePath>();
            for (int i = 0; i < paths.length; ++i) {
                Object[] relCur = paths[i].getPath();
                for (int j = 0; j < relCur.length; ++j) {
                    if (relCur[j] instanceof AgentTree.AgentNode) {
                        agentPaths.add(paths[i]);
                        continue;
                    }
                    if (!(relCur[j] instanceof AgentTree.SuperContainer)) continue;
                }
            }
            TreePath[] agents = new TreePath[agentPaths.size()];
            for (int i = 0; i < agentPaths.size(); ++i) {
                agents[i] = (TreePath)agentPaths.get(i);
            }
            this.table.setData(agents);
        }
    }

    public void adjustDividersLocation() {
        this.pan.setDividerLocation(300);
    }

    public Dimension getPreferredSize() {
        return new Dimension(200, 200);
    }
}

