/*
 * Decompiled with CFR 0.152.
 */
package jade.tools.logging;

import jade.content.AgentAction;
import jade.content.lang.Codec;
import jade.content.lang.sl.SLCodec;
import jade.content.onto.basic.Action;
import jade.content.onto.basic.Result;
import jade.core.AID;
import jade.core.Agent;
import jade.domain.FIPAAgentManagement.FailureException;
import jade.domain.FIPAAgentManagement.NotUnderstoodException;
import jade.domain.FIPAAgentManagement.RefuseException;
import jade.domain.introspection.AMSSubscriber;
import jade.domain.introspection.DeadAgent;
import jade.domain.introspection.Event;
import jade.lang.acl.ACLMessage;
import jade.lang.acl.MessageTemplate;
import jade.proto.SimpleAchieveREResponder;
import jade.tools.logging.LogManager;
import jade.tools.logging.ontology.GetAllLoggers;
import jade.tools.logging.ontology.LogManagementOntology;
import jade.tools.logging.ontology.SetFile;
import jade.tools.logging.ontology.SetLevel;
import jade.util.Logger;
import jade.util.leap.List;
import java.util.Map;

public class LogHelperAgent
extends Agent {
    private String logManagerClass = "jade.tools.logging.JavaLoggingLogManagerImpl";
    private Logger logger;
    private Codec codec = new SLCodec();
    private LogManager logManager = null;
    private AMSSubscriber myAMSSubscriber = null;

    protected void setup() {
        this.logger = Logger.getMyLogger(this.getLocalName());
        Object[] args = this.getArguments();
        if (args != null && args.length > 0 && args[0] instanceof AID) {
            this.amsSubscribe((AID)args[0]);
        }
        this.getContentManager().registerLanguage(this.codec);
        this.getContentManager().registerOntology(LogManagementOntology.getInstance());
        MessageTemplate mt = MessageTemplate.MatchOntology("Log-Management-Ontology");
        this.addBehaviour(new LogHelperAgentBehaviour(this, mt));
        this.logger.log(Logger.INFO, this.getName() + " started using " + this.logManagerClass);
    }

    protected void takeDown() {
        if (this.myAMSSubscriber != null) {
            this.send(this.myAMSSubscriber.getCancel());
        }
    }

    private void amsSubscribe(final AID owner) {
        this.myAMSSubscriber = new AMSSubscriber(){

            protected void installHandlers(Map handlersTable) {
                handlersTable.put("dead-agent", new AMSSubscriber.EventHandler(){

                    public void handle(Event ev) {
                        DeadAgent da = (DeadAgent)ev;
                        if (da.getAgent().equals(owner)) {
                            LogHelperAgent.this.doDelete();
                        }
                    }
                });
            }
        };
        this.addBehaviour(this.myAMSSubscriber);
    }

    private class LogHelperAgentBehaviour
    extends SimpleAchieveREResponder {
        private Action actExpr;
        private AgentAction action;

        public LogHelperAgentBehaviour(Agent a, MessageTemplate mt) {
            super(a, mt);
        }

        protected ACLMessage prepareResponse(ACLMessage request) throws NotUnderstoodException, RefuseException {
            try {
                this.actExpr = (Action)LogHelperAgent.this.getContentManager().extractContent(request);
                this.action = (AgentAction)this.actExpr.getAction();
                return null;
            }
            catch (Exception e2) {
                String errorMsg = "Error decoding request. " + e2;
                LogHelperAgent.this.logger.log(Logger.WARNING, errorMsg);
                throw new NotUnderstoodException(errorMsg);
            }
        }

        protected ACLMessage prepareResultNotification(ACLMessage request, ACLMessage response) throws FailureException {
            ACLMessage reply = request.createReply();
            if (this.action instanceof GetAllLoggers) {
                this.handleGetAllLoggers((GetAllLoggers)this.action, this.actExpr, reply);
            } else if (this.action instanceof SetFile) {
                this.handleSetFile((SetFile)this.action, this.actExpr, reply);
            } else if (this.action instanceof SetLevel) {
                this.handleSetLevel((SetLevel)this.action, this.actExpr, reply);
            } else {
                throw new FailureException("Action " + this.action.getClass().getName() + " not supported.");
            }
            return reply;
        }

        private void handleGetAllLoggers(GetAllLoggers action, Action actExpr, ACLMessage reply) throws FailureException {
            try {
                String className = action.getType();
                if (className != null) {
                    LogHelperAgent.this.logManagerClass = className;
                }
                LogHelperAgent.this.logger.log(Logger.CONFIG, "Log manager class defined: " + LogHelperAgent.this.logManagerClass);
                LogHelperAgent.this.logManager = (LogManager)Class.forName(LogHelperAgent.this.logManagerClass).newInstance();
                List logInfo = LogHelperAgent.this.logManager.getAllLogInfo();
                Result r = new Result(actExpr, logInfo);
                LogHelperAgent.this.getContentManager().fillContent(reply, r);
                reply.setPerformative(7);
            }
            catch (Exception any) {
                String errorMsg = "Error initializing LogManager. " + any;
                LogHelperAgent.this.logger.log(Logger.WARNING, errorMsg);
                any.printStackTrace();
                throw new FailureException(errorMsg);
            }
        }

        private void handleSetFile(SetFile action, Action actExpr, ACLMessage reply) throws FailureException {
            if (LogHelperAgent.this.logManager == null) {
                throw new FailureException("LogManager not initialized");
            }
            LogHelperAgent.this.logManager.setFile(action.getFile(), action.getLogger());
            reply.setPerformative(7);
        }

        private void handleSetLevel(SetLevel action, Action actExpr, ACLMessage reply) throws FailureException {
            if (LogHelperAgent.this.logManager == null) {
                throw new FailureException("LogManager not initialized");
            }
            LogHelperAgent.this.logManager.setLogLevel(action.getLogger(), action.getLevel());
            reply.setPerformative(7);
        }
    }
}

