/*
 * Decompiled with CFR 0.152.
 */
package jade.tools.logging;

import jade.tools.logging.LogManager;
import jade.tools.logging.ontology.LevelInfo;
import jade.tools.logging.ontology.LoggerInfo;
import jade.util.leap.List;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;

public class JavaLoggingLogManagerImpl
implements LogManager {
    public static final String JAVA_LOGGING_LOG_MANAGER_CLASS = "jade.tools.logging.JavaLoggingLogManagerImpl";
    private static final String DEFAULT_ROOT_LOGGER_NAME = "__ROOT_LOGGER";
    private static List levels = new jade.util.leap.ArrayList();
    private java.util.logging.LogManager logManager = java.util.logging.LogManager.getLogManager();
    private static final String LOGGER_FRIENDLY_NAME = "Java Util Logging";
    private List loggers = null;
    private ArrayList rootHandlers = null;

    public String getName() {
        return LOGGER_FRIENDLY_NAME;
    }

    public List getAllLogInfo() {
        String handlers;
        boolean fhExists = false;
        if (this.rootHandlers == null && (handlers = this.logManager.getProperty("handlers")) != null) {
            int index = handlers.indexOf(",");
            String separator = ",";
            if (index == -1) {
                separator = " ";
            }
            StringTokenizer st = new StringTokenizer(handlers, separator);
            while (st.hasMoreTokens()) {
                String handlerName;
                if (this.rootHandlers == null) {
                    this.rootHandlers = new ArrayList();
                }
                fhExists = (handlerName = st.nextToken().trim()).indexOf("java.util.logging.FileHandler") > -1;
                this.rootHandlers.add(handlerName);
            }
        }
        if (this.loggers == null) {
            this.loggers = new jade.util.leap.ArrayList();
            Enumeration<String> e2 = this.logManager.getLoggerNames();
            while (e2.hasMoreElements()) {
                String logName = e2.nextElement();
                try {
                    jade.util.leap.ArrayList loggerHandlers;
                    Logger theLogger = this.logManager.getLogger(logName);
                    Level level = this.getLevel(theLogger);
                    int loggerLevel = level.intValue();
                    if (logName == null || logName.length() == 0) {
                        logName = DEFAULT_ROOT_LOGGER_NAME;
                    }
                    LoggerInfo logInfoElem = new LoggerInfo(logName, loggerLevel);
                    jade.util.leap.ArrayList arrayList = loggerHandlers = this.rootHandlers == null ? new jade.util.leap.ArrayList() : new jade.util.leap.ArrayList(this.rootHandlers);
                    if (!logName.equals("")) {
                        Handler[] handlers2 = theLogger.getHandlers();
                        for (int i = 0; i < handlers2.length; ++i) {
                            String temp = handlers2[i].toString();
                            if (fhExists) continue;
                            String userHandler = temp.indexOf(64) < 0 ? temp : temp.substring(0, temp.indexOf(64));
                            loggerHandlers.add(userHandler);
                        }
                    }
                    logInfoElem.setHandlers(loggerHandlers);
                    this.loggers.add(logInfoElem);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
        return this.loggers;
    }

    private Level getLevel(Logger logger) {
        if (logger != null) {
            Level l = logger.getLevel();
            if (l != null) {
                return l;
            }
            return this.getLevel(logger.getParent());
        }
        return Level.INFO;
    }

    public void setLogLevel(String name, int level) {
        for (int i = 0; i < this.loggers.size(); ++i) {
            LoggerInfo lInfo = (LoggerInfo)this.loggers.get(i);
            if (!lInfo.getName().equalsIgnoreCase(name)) continue;
            lInfo.setLevel(level);
            break;
        }
        if (name.equals(DEFAULT_ROOT_LOGGER_NAME)) {
            name = "";
        }
        Logger logger = this.logManager.getLogger(name);
        Level newLoggerLevel = Level.INFO;
        if (level == Level.ALL.intValue()) {
            newLoggerLevel = Level.ALL;
        } else if (level == Level.SEVERE.intValue()) {
            newLoggerLevel = Level.SEVERE;
        } else if (level == Level.WARNING.intValue()) {
            newLoggerLevel = Level.WARNING;
        } else if (level == Level.INFO.intValue()) {
            newLoggerLevel = Level.INFO;
        } else if (level == Level.CONFIG.intValue()) {
            newLoggerLevel = Level.CONFIG;
        } else if (level == Level.FINE.intValue()) {
            newLoggerLevel = Level.FINE;
        } else if (level == Level.FINER.intValue()) {
            newLoggerLevel = Level.FINER;
        } else if (level == Level.FINEST.intValue()) {
            newLoggerLevel = Level.FINEST;
        } else if (level == Level.OFF.intValue()) {
            newLoggerLevel = Level.OFF;
        }
        logger.setLevel(newLoggerLevel);
        if (logger.getParent() != null) {
            Handler[] pHandlers = logger.getParent().getHandlers();
            for (int i = 0; i < pHandlers.length; ++i) {
                pHandlers[i].setLevel(newLoggerLevel);
            }
        }
        Handler[] handlers = logger.getHandlers();
        for (int j = 0; j < handlers.length; ++j) {
            handlers[j].setLevel(newLoggerLevel);
        }
    }

    public void setFile(String name, String fileHandler) {
        try {
            for (int i = 0; i < this.loggers.size(); ++i) {
                LoggerInfo lInfo = (LoggerInfo)this.loggers.get(i);
                if (!lInfo.getName().equalsIgnoreCase(name)) continue;
                lInfo.setFile(fileHandler);
                break;
            }
            if (name.equals(DEFAULT_ROOT_LOGGER_NAME)) {
                name = "";
            }
            Logger logger = this.logManager.getLogger(name);
            logger.addHandler(new FileHandler(fileHandler));
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
    }

    public List getLogLevels() {
        return levels;
    }

    static {
        levels.add(new LevelInfo(Level.ALL.getName(), Level.ALL.intValue()));
        levels.add(new LevelInfo(Level.SEVERE.getName(), Level.SEVERE.intValue()));
        levels.add(new LevelInfo(Level.WARNING.getName(), Level.WARNING.intValue()));
        levels.add(new LevelInfo(Level.INFO.getName(), Level.INFO.intValue()));
        levels.add(new LevelInfo(Level.CONFIG.getName(), Level.CONFIG.intValue()));
        levels.add(new LevelInfo(Level.FINE.getName(), Level.FINE.intValue()));
        levels.add(new LevelInfo(Level.FINER.getName(), Level.FINER.intValue()));
        levels.add(new LevelInfo(Level.FINEST.getName(), Level.FINEST.intValue()));
        levels.add(new LevelInfo(Level.OFF.getName(), Level.OFF.intValue()));
    }
}

