/*
 * Decompiled with CFR 0.152.
 */
package jade.tools.gui;

import jade.core.AID;
import jade.util.leap.Iterator;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class AIDAddressList
extends JPanel {
    private GridBagLayout gridBagLayout1 = new GridBagLayout();
    private JList contentList = new JList();
    private JButton viewButton = new JButton();
    private JButton addButton = new JButton();
    private JButton deleteButton = new JButton();
    private DefaultListModel listModel = new DefaultListModel();
    private JScrollPane contentScrollPane = new JScrollPane();
    private boolean editable = true;
    private AIDAddressListListener theDataListener;
    private AID theAID;

    public AIDAddressList() {
        try {
            this.jbInit();
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    public void setEditable(boolean theBool) {
        if (!theBool) {
            this.editable = false;
            this.addButton.setEnabled(false);
            this.deleteButton.setEnabled(false);
        }
    }

    public void register(AID theAID) {
        this.listModel.removeAllElements();
        this.theAID = theAID;
        Iterator itor = theAID.getAllAddresses();
        while (itor.hasNext()) {
            String theAddresss = (String)itor.next();
            this.listModel.addElement(theAddresss);
        }
        this.theDataListener = new AIDAddressListListener();
        this.theDataListener.register(theAID, "Address");
        this.listModel.addListDataListener(this.theDataListener);
        this.contentList.setModel(this.listModel);
    }

    public void doDelete() {
        int index = this.contentList.getSelectedIndex();
        if (index >= 0) {
            this.theDataListener.registerRemovedAddress((String)this.listModel.getElementAt(index));
            this.listModel.remove(index);
        }
    }

    public void doAdd() {
        AIDAddressDialog theDialog = new AIDAddressDialog();
        theDialog.setTitle("<new address>");
        theDialog.setLocation((int)this.getLocationOnScreen().getX(), (int)this.getLocationOnScreen().getY());
        theDialog.setVisible(true);
        if (theDialog.getOK()) {
            this.listModel.addElement(theDialog.getItsAddress());
        }
    }

    public void doView() {
        String currentAddress;
        int index = this.contentList.getSelectedIndex();
        if (index < 0) {
            return;
        }
        String editAddress = currentAddress = (String)this.listModel.getElementAt(index);
        AIDAddressDialog theDialog = new AIDAddressDialog();
        theDialog.setLocation((int)this.getLocationOnScreen().getX(), (int)this.getLocationOnScreen().getY());
        theDialog.setEditable(this.editable);
        theDialog.setTitle(this.editable ? "Edit address: " + currentAddress : "View address:" + currentAddress);
        theDialog.setItsAddress(editAddress);
        theDialog.setVisible(true);
        if (theDialog.getOK()) {
            this.theDataListener.registerChangedAddress(currentAddress);
            this.listModel.setElementAt(theDialog.getItsAddress(), index);
        }
    }

    void deleteButton_actionPerformed(ActionEvent e2) {
        this.doDelete();
    }

    void addButton_actionPerformed(ActionEvent e2) {
        this.doAdd();
    }

    void viewButton_actionPerformed(ActionEvent e2) {
        this.doView();
    }

    void contentList_keyPressed(KeyEvent e2) {
        if (e2.getKeyCode() == 10) {
            this.doView();
        }
        if (!this.editable) {
            return;
        }
        if (e2.getKeyCode() == 155) {
            this.doAdd();
        }
        if (e2.getKeyCode() == 127) {
            this.doDelete();
        }
    }

    void contentList_mouseClicked(MouseEvent e2) {
        if (e2.getClickCount() > 1) {
            this.doView();
        }
    }

    private void jbInit() throws Exception {
        this.setLayout(this.gridBagLayout1);
        this.viewButton.setBackground(Color.white);
        this.viewButton.setFont(new Font("Dialog", 0, 11));
        this.viewButton.setForeground(new Color(0, 0, 83));
        this.viewButton.setMinimumSize(new Dimension(13, 5));
        this.viewButton.setPreferredSize(new Dimension(13, 25));
        this.viewButton.setToolTipText("edit/view address");
        this.viewButton.setMargin(new Insets(0, 0, 0, 0));
        this.viewButton.setText("v");
        this.viewButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e2) {
                AIDAddressList.this.viewButton_actionPerformed(e2);
            }
        });
        this.addButton.setBackground(Color.white);
        this.addButton.setFont(new Font("Dialog", 0, 11));
        this.addButton.setForeground(new Color(0, 0, 83));
        this.addButton.setMinimumSize(new Dimension(13, 5));
        this.addButton.setToolTipText("add address");
        this.addButton.setMargin(new Insets(0, 0, 0, 0));
        this.addButton.setText("+");
        this.addButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e2) {
                AIDAddressList.this.addButton_actionPerformed(e2);
            }
        });
        this.deleteButton.setBackground(Color.white);
        this.deleteButton.setFont(new Font("Dialog", 0, 11));
        this.deleteButton.setForeground(new Color(0, 0, 83));
        this.deleteButton.setMinimumSize(new Dimension(13, 5));
        this.deleteButton.setToolTipText("delete address");
        this.deleteButton.setMargin(new Insets(0, 0, 0, 0));
        this.deleteButton.setText("x");
        this.deleteButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e2) {
                AIDAddressList.this.deleteButton_actionPerformed(e2);
            }
        });
        this.contentList.setFont(new Font("Dialog", 0, 11));
        this.contentList.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e2) {
                AIDAddressList.this.contentList_mouseClicked(e2);
            }
        });
        this.contentList.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e2) {
                AIDAddressList.this.contentList_keyPressed(e2);
            }
        });
        this.contentScrollPane.setBorder(BorderFactory.createLineBorder(Color.black));
        this.contentScrollPane.getViewport().add((Component)this.contentList, null);
        this.add((Component)this.contentScrollPane, new GridBagConstraints(0, 1, 1, 3, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.addButton, new GridBagConstraints(1, 2, 1, 1, 0.0, 1.0, 10, 3, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.deleteButton, new GridBagConstraints(1, 3, 1, 1, 0.0, 1.0, 10, 3, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.viewButton, new GridBagConstraints(1, 1, 1, 1, 0.0, 1.0, 14, 3, new Insets(0, 0, 0, 0), 0, 0));
    }

    private class AIDAddressDialog
    extends JDialog {
        GridBagLayout gridBagLayout1 = new GridBagLayout();
        JTextField theAddressField = new JTextField();
        JLabel jLabel1 = new JLabel();
        JPanel buttonPanel = new JPanel();
        JButton okButton = new JButton();
        JButton cancelButton = new JButton();
        private String OK = "ok";
        private String CANCELLED = "cancelled";
        private String userAction;
        private String itsAddress;

        public AIDAddressDialog() {
            this.setModal(true);
            try {
                this.jbInit();
                this.setSize(380, 100);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }

        public String getItsAddress() {
            return this.itsAddress;
        }

        public boolean getOK() {
            return this.userAction.equals(this.OK);
        }

        public void setEditable(boolean theBool) {
            if (!theBool) {
                this.OK = "CLOSED";
                this.cancelButton.setVisible(false);
                this.theAddressField.setEnabled(false);
            }
        }

        public void setItsAddress(String newItsAddress) {
            this.itsAddress = newItsAddress;
            this.theAddressField.setText(this.itsAddress);
        }

        void jbInit() throws Exception {
            this.getContentPane().setLayout(this.gridBagLayout1);
            this.jLabel1.setFont(new Font("Dialog", 0, 11));
            this.jLabel1.setText("address");
            this.getContentPane().setBackground(Color.white);
            this.theAddressField.setFont(new Font("Dialog", 0, 11));
            this.theAddressField.setDisabledTextColor(Color.black);
            this.buttonPanel.setBackground(Color.white);
            this.okButton.setBackground(Color.white);
            this.okButton.setFont(new Font("Dialog", 0, 12));
            this.okButton.setText("ok");
            this.okButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e2) {
                    AIDAddressDialog.this.okButton_actionPerformed(e2);
                }
            });
            this.cancelButton.setBackground(Color.white);
            this.cancelButton.setFont(new Font("Dialog", 0, 12));
            this.cancelButton.setText("cancel");
            this.cancelButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e2) {
                    AIDAddressDialog.this.cancelButton_actionPerformed(e2);
                }
            });
            this.getContentPane().add((Component)this.theAddressField, new GridBagConstraints(1, 0, 2, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.getContentPane().add((Component)this.jLabel1, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.getContentPane().add((Component)this.buttonPanel, new GridBagConstraints(0, 2, 3, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.buttonPanel.add((Component)this.okButton, null);
            this.buttonPanel.add((Component)this.cancelButton, null);
        }

        void cancelButton_actionPerformed(ActionEvent e2) {
            this.setUserAction(this.CANCELLED);
            this.setVisible(false);
        }

        void okButton_actionPerformed(ActionEvent e2) {
            this.setItsAddress(this.theAddressField.getText());
            this.setUserAction(this.OK);
            this.setVisible(false);
        }

        private String getUserAction() {
            return this.userAction;
        }

        private void setUserAction(String newUserAction) {
            this.userAction = newUserAction;
        }
    }

    private class AIDAddressListListener
    implements ListDataListener {
        private String theRemovedAddress;
        private String theChangedAddress;
        private AID itsAID;

        public void register(Object obj, String arg) {
            this.itsAID = (AID)obj;
        }

        public void intervalAdded(ListDataEvent parm1) {
            DefaultListModel lm = (DefaultListModel)parm1.getSource();
            int index = parm1.getIndex0();
            String newAddress = (String)lm.elementAt(index);
            this.itsAID.addAddresses(newAddress);
        }

        public void registerRemovedAddress(String theRemovedAddress) {
            this.theRemovedAddress = theRemovedAddress;
        }

        public void intervalRemoved(ListDataEvent parm1) {
            this.itsAID.removeAddresses(this.theRemovedAddress);
        }

        public void registerChangedAddress(String theChangedAddress) {
            this.theChangedAddress = theChangedAddress;
        }

        public void contentsChanged(ListDataEvent parm1) {
            DefaultListModel lm = (DefaultListModel)parm1.getSource();
            int index = parm1.getIndex0();
            String currentAddress = (String)lm.getElementAt(index);
            this.itsAID.removeAddresses(currentAddress);
            this.itsAID.addAddresses(this.theChangedAddress);
        }
    }
}

