/*
 * Decompiled with CFR 0.152.
 */
package jade.tools.gui;

import jade.tools.gui.ACLSytntaxStyle;
import jade.tools.gui.ACLToken;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import javax.swing.JComponent;
import javax.swing.text.Segment;
import javax.swing.text.TabExpander;
import javax.swing.text.Utilities;

public class ACLSyntaxUtilities {
    private ACLSyntaxUtilities() {
    }

    public static ACLSytntaxStyle[] getDefaultSyntaxStyles(JComponent theComp) {
        ACLSytntaxStyle[] styles = new ACLSytntaxStyle[11];
        styles[1] = new ACLSytntaxStyle(Color.black, true, false, theComp);
        styles[2] = new ACLSytntaxStyle(new Color(0x990033), true, false, theComp);
        styles[6] = new ACLSytntaxStyle(Color.darkGray, false, false, theComp);
        styles[7] = new ACLSytntaxStyle(new Color(17, 0, 154), false, false, theComp);
        styles[8] = new ACLSytntaxStyle(new Color(38400), false, false, theComp);
        styles[3] = new ACLSytntaxStyle(new Color(6619289), false, false, theComp);
        styles[4] = new ACLSytntaxStyle(new Color(6619289), false, false, theComp);
        styles[5] = new ACLSytntaxStyle(new Color(0x990033), false, false, theComp);
        styles[9] = new ACLSytntaxStyle(Color.black, false, true, theComp);
        styles[10] = new ACLSytntaxStyle(Color.red, false, false, theComp);
        return styles;
    }

    public static boolean regionMatches(boolean ignoreCase, Segment text, int offset, String match) {
        int length2 = offset + match.length();
        char[] textArray = text.array;
        if (length2 > text.offset + text.count) {
            return false;
        }
        int i = offset;
        int j = 0;
        while (i < length2) {
            char c1 = textArray[i];
            char c2 = match.charAt(j);
            if (ignoreCase) {
                c1 = Character.toUpperCase(c1);
                c2 = Character.toUpperCase(c2);
            }
            if (c1 != c2) {
                return false;
            }
            ++i;
            ++j;
        }
        return true;
    }

    public static boolean regionMatches(boolean ignoreCase, Segment text, int offset, char[] match) {
        int length2 = offset + match.length;
        char[] textArray = text.array;
        if (length2 > text.offset + text.count) {
            return false;
        }
        int i = offset;
        int j = 0;
        while (i < length2) {
            char c1 = textArray[i];
            char c2 = match[j];
            if (ignoreCase) {
                c1 = Character.toUpperCase(c1);
                c2 = Character.toUpperCase(c2);
            }
            if (c1 != c2) {
                return false;
            }
            ++i;
            ++j;
        }
        return true;
    }

    public static int paintSyntaxLine(Segment line, ACLToken tokens, ACLSytntaxStyle[] styles, TabExpander expander, Graphics gfx, int x, int y) {
        byte id;
        Font defaultFont = gfx.getFont();
        Color defaultColor = gfx.getColor();
        int offset = 0;
        while ((id = tokens.id) != 127) {
            int length2 = tokens.length;
            if (id == 0) {
                if (!defaultColor.equals(gfx.getColor())) {
                    gfx.setColor(defaultColor);
                }
                if (!defaultFont.equals(gfx.getFont())) {
                    gfx.setFont(defaultFont);
                }
            } else {
                styles[id].setGraphicsFlags(gfx, defaultFont);
            }
            line.count = length2;
            x = Utilities.drawTabbedText(line, x, y, gfx, expander, 0);
            line.offset += length2;
            offset += length2;
            tokens = tokens.next;
        }
        return x;
    }
}

