/*
 * Decompiled with CFR 0.152.
 */
package jade.tools.gui;

import jade.tools.gui.ACLSyntaxUtilities;
import jade.tools.gui.ACLToken;
import javax.swing.text.Segment;

public class ACLSLTokenMarker {
    public static final byte S_ONE = 100;
    public static final byte S_TWO = 101;
    public static final byte S_END = 102;
    private static KeywordMap aclSLKeywords;
    protected ACLToken firstToken;
    protected ACLToken lastToken;
    protected LineInfo[] lineInfo;
    protected int length;
    protected int lastLine = -1;
    protected boolean nextLineRequested;
    private KeywordMap keywords;
    private byte token;
    private int lastOffset;
    private int lastKeyword;
    private char matchChar;
    private boolean matchCharBracket;
    private boolean matchSpacesAllowed;

    public ACLSLTokenMarker() {
        this(ACLSLTokenMarker.getKeywords());
        this.lastLine = -1;
    }

    public ACLSLTokenMarker(KeywordMap keywords) {
        this.keywords = keywords;
    }

    private static KeywordMap getKeywords() {
        if (aclSLKeywords == null) {
            aclSLKeywords = new KeywordMap(false);
            aclSLKeywords.add("inv", (byte)10);
            aclSLKeywords.add("ams", (byte)5);
            aclSLKeywords.add("df", (byte)5);
            aclSLKeywords.add("rma", (byte)5);
            aclSLKeywords.add("l1", (byte)3);
            aclSLKeywords.add("l2", (byte)4);
            aclSLKeywords.add("wantarray", (byte)8);
            aclSLKeywords.add("warn", (byte)8);
            aclSLKeywords.add("write", (byte)8);
            aclSLKeywords.add("m", (byte)100);
            aclSLKeywords.add("q", (byte)100);
            aclSLKeywords.add("qq", (byte)100);
            aclSLKeywords.add("qw", (byte)100);
            aclSLKeywords.add("qx", (byte)100);
            aclSLKeywords.add("s", (byte)101);
            aclSLKeywords.add("tr", (byte)101);
            aclSLKeywords.add("y", (byte)101);
        }
        return aclSLKeywords;
    }

    public boolean isNextLineRequested() {
        return this.nextLineRequested;
    }

    public ACLToken markTokens(Segment line, int lineIndex) {
        byte token;
        if (lineIndex >= this.length) {
            throw new IllegalArgumentException("Tokenizing invalid line: " + lineIndex);
        }
        this.lastToken = null;
        LineInfo info = this.lineInfo[lineIndex];
        LineInfo prev = lineIndex == 0 ? null : this.lineInfo[lineIndex - 1];
        byte oldToken = info.token;
        info.token = token = this.markTokensImpl(prev == null ? (byte)0 : prev.token, line, lineIndex);
        if (this.lastLine != lineIndex || !this.nextLineRequested) {
            this.nextLineRequested = oldToken != token;
        }
        this.lastLine = lineIndex;
        this.addToken(0, (byte)127);
        return this.firstToken;
    }

    public boolean supportsMultilineTokens() {
        return true;
    }

    public void insertLines(int index, int lines) {
        if (lines <= 0) {
            return;
        }
        this.length += lines;
        this.ensureCapacity(this.length);
        int len = index + lines;
        System.arraycopy(this.lineInfo, index, this.lineInfo, len, this.lineInfo.length - len);
        for (int i = index + lines - 1; i >= index; --i) {
            this.lineInfo[i] = new LineInfo();
        }
    }

    public void deleteLines(int index, int lines) {
        if (lines <= 0) {
            return;
        }
        int len = index + lines;
        this.length -= lines;
        System.arraycopy(this.lineInfo, len, this.lineInfo, index, this.lineInfo.length - len);
    }

    public byte markTokensImpl(byte _token, Segment line, int lineIndex) {
        char[] array = line.array;
        int offset = line.offset;
        this.token = _token;
        this.lastOffset = offset;
        this.lastKeyword = offset;
        this.matchChar = '\u0000';
        this.matchCharBracket = false;
        this.matchSpacesAllowed = false;
        int length2 = line.count + offset;
        if (this.token == 3 && lineIndex != 0 && this.lineInfo[lineIndex - 1].obj != null) {
            String str = (String)this.lineInfo[lineIndex - 1].obj;
            if (str != null && str.length() == line.count && ACLSyntaxUtilities.regionMatches(false, line, offset, str)) {
                this.addToken(line.count, this.token);
                return 0;
            }
            this.addToken(line.count, this.token);
            this.lineInfo[lineIndex].obj = str;
            return this.token;
        }
        boolean backslash = false;
        block33: for (int i = offset; i < length2; ++i) {
            int i1 = i + 1;
            char c = array[i];
            if (c == '\\') {
                backslash = !backslash;
                continue;
            }
            switch (this.token) {
                case 0: {
                    switch (c) {
                        case '#': {
                            if (backslash) {
                                backslash = false;
                                break;
                            }
                            if (this.doKeyword(line, i, c)) break;
                            this.addToken(i - this.lastOffset, this.token);
                            this.addToken(length2 - i, (byte)1);
                            this.lastOffset = this.lastKeyword = length2;
                            break block33;
                        }
                        case '.': 
                        case '@': {
                            backslash = false;
                            if (length2 - i <= 1) continue block33;
                            if (this.doKeyword(line, i, c)) break;
                            this.addToken(i - this.lastOffset, this.token);
                            this.lastOffset = this.lastKeyword = i;
                            this.token = (byte)7;
                            break;
                        }
                        case '=': {
                            backslash = false;
                            if (i == offset) {
                                this.token = (byte)2;
                                this.addToken(length2 - i, this.token);
                                this.lastOffset = this.lastKeyword = length2;
                                break block33;
                            }
                            this.doKeyword(line, i, c);
                            break;
                        }
                        case '$': 
                        case '%': 
                        case '&': {
                            backslash = false;
                            if (length2 - i <= 1) continue block33;
                            if (this.doKeyword(line, i, c)) break;
                            if (c == '&' && (array[i1] == '&' || Character.isWhitespace(array[i1]))) {
                                ++i;
                                break;
                            }
                            this.addToken(i - this.lastOffset, this.token);
                            this.lastOffset = this.lastKeyword = i;
                            this.token = (byte)7;
                            break;
                        }
                        case '\"': {
                            if (backslash) {
                                backslash = false;
                                break;
                            }
                            if (this.doKeyword(line, i, c)) break;
                            this.addToken(i - this.lastOffset, this.token);
                            this.token = (byte)3;
                            this.lineInfo[lineIndex].obj = null;
                            this.lastOffset = this.lastKeyword = i;
                            break;
                        }
                        case '\'': {
                            if (backslash) {
                                backslash = false;
                                break;
                            }
                            int oldLastKeyword = this.lastKeyword;
                            if (this.doKeyword(line, i, c) || i != oldLastKeyword) break;
                            this.addToken(i - this.lastOffset, this.token);
                            this.token = (byte)4;
                            this.lastOffset = this.lastKeyword = i;
                            break;
                        }
                        case '`': {
                            if (backslash) {
                                backslash = false;
                                break;
                            }
                            if (this.doKeyword(line, i, c)) break;
                            this.addToken(i - this.lastOffset, this.token);
                            this.token = (byte)9;
                            this.lastOffset = this.lastKeyword = i;
                            break;
                        }
                        case '<': {
                            if (backslash) {
                                backslash = false;
                                break;
                            }
                            if (this.doKeyword(line, i, c)) break;
                            if (length2 - i <= 2 || array[i1] != '<' || Character.isWhitespace(array[i + 2])) continue block33;
                            this.addToken(i - this.lastOffset, this.token);
                            this.lastOffset = this.lastKeyword = i;
                            this.token = (byte)3;
                            int len = length2 - (i + 2);
                            if (array[length2 - 1] == ';') {
                                --len;
                            }
                            this.lineInfo[lineIndex].obj = new String(array, i + 2, len);
                            break;
                        }
                        case '?': {
                            if (i != this.lastKeyword || length2 - i <= 1) continue block33;
                            if (this.doKeyword(line, i, c)) break;
                            backslash = false;
                            char ch = array[i1];
                            if (Character.isWhitespace(ch)) break;
                            this.matchChar = c;
                            this.matchSpacesAllowed = false;
                            this.addToken(i - this.lastOffset, this.token);
                            this.token = (byte)100;
                            this.lastOffset = this.lastKeyword = i;
                            break;
                        }
                        default: {
                            backslash = false;
                            if (Character.isLetterOrDigit(c) || c == '_' || c == '-') continue block33;
                            this.doKeyword(line, i, c);
                            break;
                        }
                    }
                    continue block33;
                }
                case 7: {
                    backslash = false;
                    if (Character.isLetterOrDigit(c) || c == '_' || c == '#' || c == '\'' || c == '-' || c == '.') continue block33;
                    if (i != offset && array[i - 1] == '$') {
                        this.addToken(i1 - this.lastOffset, this.token);
                        this.lastOffset = this.lastKeyword = i1;
                        continue block33;
                    }
                    this.addToken(i - this.lastOffset, this.token);
                    this.lastOffset = this.lastKeyword = i;
                    this.token = 0;
                    continue block33;
                }
                case 100: 
                case 101: {
                    if (backslash) {
                        backslash = false;
                        continue block33;
                    }
                    if (this.matchChar == '\u0000') {
                        if (Character.isWhitespace(this.matchChar) && !this.matchSpacesAllowed) continue block33;
                        this.matchChar = c;
                        continue block33;
                    }
                    switch (this.matchChar) {
                        case '(': {
                            this.matchChar = (char)41;
                            this.matchCharBracket = true;
                            break;
                        }
                        case '[': {
                            this.matchChar = (char)93;
                            this.matchCharBracket = true;
                            break;
                        }
                        case '{': {
                            this.matchChar = (char)125;
                            this.matchCharBracket = true;
                            break;
                        }
                        case '<': {
                            this.matchChar = (char)62;
                            this.matchCharBracket = true;
                            break;
                        }
                        default: {
                            this.matchCharBracket = false;
                        }
                    }
                    if (c != this.matchChar) continue block33;
                    if (this.token == 101) {
                        this.token = (byte)100;
                        if (!this.matchCharBracket) continue block33;
                        this.matchChar = '\u0000';
                        continue block33;
                    }
                    this.token = (byte)102;
                    this.addToken(i1 - this.lastOffset, (byte)4);
                    this.lastOffset = this.lastKeyword = i1;
                    continue block33;
                }
                case 102: {
                    backslash = false;
                    if (Character.isLetterOrDigit(c) || c == '_' || c == '-') continue block33;
                    this.doKeyword(line, i, c);
                    continue block33;
                }
                case 2: {
                    backslash = false;
                    if (i != offset) continue block33;
                    this.addToken(line.count, this.token);
                    if (length2 - i > 3 && ACLSyntaxUtilities.regionMatches(false, line, offset, "=cut")) {
                        this.token = 0;
                    }
                    this.lastOffset = this.lastKeyword = length2;
                    break block33;
                }
                case 3: {
                    if (backslash) {
                        backslash = false;
                        continue block33;
                    }
                    if (c == '$') {
                        backslash = true;
                        continue block33;
                    }
                    if (c != '\"') continue block33;
                    this.addToken(i1 - this.lastOffset, this.token);
                    this.token = 0;
                    this.lastOffset = this.lastKeyword = i1;
                    continue block33;
                }
                case 4: {
                    if (backslash) {
                        backslash = false;
                        continue block33;
                    }
                    if (c == '$') {
                        backslash = true;
                        continue block33;
                    }
                    if (c != '\'') continue block33;
                    this.addToken(i1 - this.lastOffset, (byte)3);
                    this.token = 0;
                    this.lastOffset = this.lastKeyword = i1;
                    continue block33;
                }
                case 9: {
                    if (backslash) {
                        backslash = false;
                        continue block33;
                    }
                    if (c != '`') continue block33;
                    this.addToken(i1 - this.lastOffset, this.token);
                    this.token = 0;
                    this.lastOffset = this.lastKeyword = i1;
                    continue block33;
                }
                default: {
                    throw new InternalError("Invalid state: " + this.token);
                }
            }
        }
        if (this.token == 0) {
            this.doKeyword(line, length2, '\u0000');
        }
        switch (this.token) {
            case 0: {
                this.addToken(length2 - this.lastOffset, this.token);
                break;
            }
            case 7: {
                this.addToken(length2 - this.lastOffset, this.token);
                this.token = 0;
                break;
            }
            case 102: {
                this.addToken(length2 - this.lastOffset, (byte)4);
                this.token = 0;
                break;
            }
            case 100: 
            case 101: {
                this.addToken(length2 - this.lastOffset, (byte)10);
                this.token = 0;
                break;
            }
            default: {
                this.addToken(length2 - this.lastOffset, this.token);
            }
        }
        return this.token;
    }

    protected void ensureCapacity(int index) {
        if (this.lineInfo == null) {
            this.lineInfo = new LineInfo[index + 1];
        } else if (this.lineInfo.length <= index) {
            LineInfo[] lineInfoN = new LineInfo[(index + 1) * 2];
            System.arraycopy(this.lineInfo, 0, lineInfoN, 0, this.lineInfo.length);
            this.lineInfo = lineInfoN;
        }
    }

    protected void addToken(int length2, byte id) {
        if (id >= 100 && id <= 126) {
            throw new InternalError("Invalid id: " + id);
        }
        if (length2 == 0 && id != 127) {
            return;
        }
        if (this.firstToken == null) {
            this.lastToken = this.firstToken = new ACLToken(length2, id);
        } else if (this.lastToken == null) {
            this.lastToken = this.firstToken;
            this.firstToken.length = length2;
            this.firstToken.id = id;
        } else if (this.lastToken.next == null) {
            this.lastToken = this.lastToken.next = new ACLToken(length2, id);
        } else {
            this.lastToken = this.lastToken.next;
            this.lastToken.length = length2;
            this.lastToken.id = id;
        }
    }

    private boolean doKeyword(Segment line, int i, char c) {
        int i1 = i + 1;
        if (this.token == 102) {
            this.addToken(i - this.lastOffset, (byte)4);
            this.token = 0;
            this.lastOffset = i;
            this.lastKeyword = i1;
            return false;
        }
        int len = i - this.lastKeyword;
        byte id = this.keywords.lookup(line, this.lastKeyword, len);
        if (id == 100 || id == 101) {
            if (this.lastKeyword != this.lastOffset) {
                this.addToken(this.lastKeyword - this.lastOffset, (byte)0);
            }
            this.addToken(len, (byte)4);
            this.lastOffset = i;
            this.lastKeyword = i1;
            this.matchChar = Character.isWhitespace(c) ? (char)'\u0000' : c;
            this.matchSpacesAllowed = true;
            this.token = id;
            return true;
        }
        if (id != 0) {
            if (this.lastKeyword != this.lastOffset) {
                this.addToken(this.lastKeyword - this.lastOffset, (byte)0);
            }
            this.addToken(len, id);
            this.lastOffset = i;
        }
        this.lastKeyword = i1;
        return false;
    }

    public class LineInfo {
        public byte token;
        public Object obj;

        public LineInfo() {
        }

        public LineInfo(byte token, Object obj) {
            this.token = token;
            this.obj = obj;
        }
    }

    private static class KeywordMap {
        protected int mapLength;
        private Keyword[] map;
        private boolean ignoreCase;

        public KeywordMap(boolean ignoreCase) {
            this(ignoreCase, 52);
            this.ignoreCase = ignoreCase;
        }

        public KeywordMap(boolean ignoreCase, int mapLength) {
            this.mapLength = mapLength;
            this.ignoreCase = ignoreCase;
            this.map = new Keyword[mapLength];
        }

        public boolean getIgnoreCase() {
            return this.ignoreCase;
        }

        public void setIgnoreCase(boolean ignoreCase) {
            this.ignoreCase = ignoreCase;
        }

        public byte lookup(Segment text, int offset, int length2) {
            if (length2 == 0) {
                return 0;
            }
            Keyword k = this.map[this.getSegmentMapKey(text, offset, length2)];
            while (k != null) {
                if (length2 != k.keyword.length) {
                    k = k.next;
                    continue;
                }
                if (ACLSyntaxUtilities.regionMatches(this.ignoreCase, text, offset, k.keyword)) {
                    return k.id;
                }
                k = k.next;
            }
            return 0;
        }

        public void add(String keyword, byte id) {
            int key = this.getStringMapKey(keyword);
            this.map[key] = new Keyword(keyword.toCharArray(), id, this.map[key]);
        }

        protected int getStringMapKey(String s) {
            return (Character.toUpperCase(s.charAt(0)) + Character.toUpperCase(s.charAt(s.length() - 1))) % this.mapLength;
        }

        protected int getSegmentMapKey(Segment s, int off, int len) {
            return (Character.toUpperCase(s.array[off]) + Character.toUpperCase(s.array[off + len - 1])) % this.mapLength;
        }

        class Keyword {
            public char[] keyword;
            public byte id;
            public Keyword next;

            public Keyword(char[] keyword, byte id, Keyword next) {
                this.keyword = keyword;
                this.id = id;
                this.next = next;
            }
        }
    }
}

