/*
 * Decompiled with CFR 0.152.
 */
package jade.tools.gui;

import jade.core.AID;
import jade.core.Agent;
import jade.domain.FIPAAgentManagement.Envelope;
import jade.lang.acl.ACLCodec;
import jade.lang.acl.ACLMessage;
import jade.lang.acl.ISO8601;
import jade.lang.acl.StringACLCodec;
import jade.tools.gui.ACLAIDDialog;
import jade.tools.gui.ACLAIDList;
import jade.tools.gui.ACLComboBox;
import jade.tools.gui.ACLContentDialog;
import jade.tools.gui.ACLPropertyList;
import jade.tools.gui.ACLTextArea;
import jade.tools.gui.ACLTextField;
import jade.tools.gui.ACLTimeChooserDialog;
import jade.tools.gui.EnvCommentsTextArea;
import jade.util.Logger;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Date;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.filechooser.FileFilter;

public class ACLPanel
extends JPanel {
    private Logger logger = Logger.getMyLogger(this.getClass().getName());
    GridBagLayout gridBagLayout1 = new GridBagLayout();
    JLabel senderLabel = new JLabel();
    JLabel receiverLabel = new JLabel();
    JLabel replytoLabel = new JLabel();
    JLabel contentLabel = new JLabel();
    JLabel languageLabel = new JLabel();
    JLabel encodingLabel = new JLabel();
    JLabel ontologyjLabel = new JLabel();
    JLabel protocolLabel = new JLabel();
    JLabel inreplytoLabel = new JLabel();
    JLabel replywithLabel = new JLabel();
    JLabel replybyLabel = new JLabel();
    JLabel userpropLabel = new JLabel();
    JLabel convidLabel = new JLabel();
    JLabel performativeLabel = new JLabel();
    JButton senderButton = new JButton();
    JButton replyByButton = new JButton();
    JLabel toLabel = new JLabel();
    JLabel fromLabel = new JLabel();
    JLabel commentsLabel = new JLabel();
    JLabel aclRepreLabel = new JLabel();
    JLabel payLoadLabel = new JLabel();
    JLabel envDateLabel = new JLabel();
    JLabel intReceiversLabel = new JLabel();
    JLabel jLabel1 = new JLabel();
    JTextField envDateTextField = new JTextField();
    JButton defaultEnvelopeButton = new JButton();
    JButton fromButton = new JButton();
    JButton envDateButton = new JButton();
    JButton contentZoomButton = new JButton();
    ACLTextArea contentTextArea = new ACLTextArea();
    private ACLTextField envACLReprTextField = new ACLTextField();
    private ACLTextField envPayloadLengthTextField = new ACLTextField();
    private ACLTextField envPayloadEncodingTextField = new ACLTextField();
    private JTextField envFromTextField = new JTextField();
    private boolean editable = true;
    private JTextField senderTextField = new JTextField();
    private ACLPropertyList userpropList = new ACLPropertyList();
    private ACLTextField conversationTextField = new ACLTextField();
    private ACLTextField languageTextField = new ACLTextField();
    private ACLTextField encodingTextField = new ACLTextField();
    private ACLTextField ontologyTextField = new ACLTextField();
    private ACLComboBox protocolComboBox = new ACLComboBox();
    private ACLTextField inreplytoTextField = new ACLTextField();
    private ACLTextField replywithTextField = new ACLTextField();
    private JTextField replybyTextField = new JTextField();
    private ACLComboBox performativesComboBox = new ACLComboBox();
    private ACLMessage itsMsg = new ACLMessage(7);
    private Vector editsVector = new Vector();
    private JPanel aclTab = new JPanel();
    private GridBagLayout gridBagLayout2 = new GridBagLayout();
    private JTabbedPane theTabbedPane = new JTabbedPane();
    private JPanel envelopeTab = new JPanel();
    private GridBagLayout gridBagLayout3 = new GridBagLayout();
    private JScrollPane commentsScrollPane = new JScrollPane();
    private EnvCommentsTextArea envCommentsTextArea = new EnvCommentsTextArea();
    private ImageIcon zoomIcon = new ImageIcon(this.getClass().getResource("images/zoom.gif"));
    private ImageIcon dateIcon = new ImageIcon(this.getClass().getResource("images/date.gif"));
    private ImageIcon envelopeIcon = new ImageIcon(this.getClass().getResource("images/envelope.gif"));
    private ImageIcon messageIcon = new ImageIcon(this.getClass().getResource("images/message.gif"));
    private ACLAIDList envToList;
    private ACLAIDList envIntendedReceiversList;
    private Agent agent;
    private ACLAIDList receiverList;
    private ACLAIDList replytoList;
    private File currentDir;
    private Envelope itsEnvelope;

    public ACLPanel(Agent agent) {
        try {
            this.agent = agent;
            this.receiverList = new ACLAIDList(agent);
            this.replytoList = new ACLAIDList(agent);
            this.envToList = new ACLAIDList(agent);
            this.envIntendedReceiversList = new ACLAIDList(agent);
            this.jbInit();
            this.itsMsg.setSender(agent.getAID());
            this.setItsMsg(this.itsMsg);
            this.editsVector.add(this.performativesComboBox);
            this.editsVector.add(this.languageTextField);
            this.editsVector.add(this.ontologyTextField);
            this.editsVector.add(this.encodingTextField);
            this.editsVector.add(this.protocolComboBox);
            this.editsVector.add(this.inreplytoTextField);
            this.editsVector.add(this.replywithTextField);
            this.editsVector.add(this.ontologyTextField);
            this.editsVector.add(this.conversationTextField);
            this.editsVector.add(this.receiverList);
            this.editsVector.add(this.replytoList);
            this.editsVector.add(this.contentTextArea);
            this.editsVector.add(this.userpropList);
            this.editsVector.add(this.envToList);
            this.editsVector.add(this.envCommentsTextArea);
            this.editsVector.add(this.envACLReprTextField);
            this.editsVector.add(this.envPayloadEncodingTextField);
            this.editsVector.add(this.envPayloadLengthTextField);
            this.editsVector.add(this.envIntendedReceiversList);
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    public ACLMessage getItsMsg() {
        return this.itsMsg;
    }

    public void setItsMsg(ACLMessage msg) {
        this.itsMsg = msg;
        this.itsEnvelope = msg.getEnvelope();
        if (this.itsEnvelope == null) {
            this.itsEnvelope = new Envelope();
            msg.setEnvelope(this.itsEnvelope);
        }
        this.senderTextField.setText(this.itsMsg.getSender() != null ? this.itsMsg.getSender().getName() : "");
        this.performativesComboBox.registerPerformatives(this.itsMsg);
        this.languageTextField.register(this.itsMsg, "Language");
        this.ontologyTextField.register(this.itsMsg, "Ontology");
        this.encodingTextField.register(this.itsMsg, "Encoding");
        this.protocolComboBox.registerProtocol(this.itsMsg);
        this.inreplytoTextField.register(this.itsMsg, "InReplyTo");
        this.replywithTextField.register(this.itsMsg, "ReplyWith");
        this.replybyTextField.setText(this.itsMsg.getReplyByDate() != null ? ISO8601.toString(this.itsMsg.getReplyByDate()) : "");
        this.conversationTextField.register(this.itsMsg, "ConversationId");
        this.receiverList.register(this.itsMsg, "Receiver");
        this.replytoList.register(this.itsMsg, "ReplyTo");
        this.contentTextArea.register(this.itsMsg, "Content");
        this.userpropList.register(this.itsMsg, "");
        this.envToList.register(this.itsEnvelope, "To");
        this.envFromTextField.setText(this.itsEnvelope.getFrom() != null ? this.itsEnvelope.getFrom().getName() : "");
        this.envCommentsTextArea.register(this.itsEnvelope, "Comments");
        this.envACLReprTextField.register(this.itsEnvelope, "AclRepresentation");
        this.envPayloadEncodingTextField.register(this.itsEnvelope, "PayloadEncoding");
        this.envPayloadLengthTextField.register(this.itsEnvelope, "PayloadLength");
        this.envDateTextField.setText(this.itsEnvelope.getDate() != null ? ISO8601.toString(this.itsEnvelope.getDate()) : "");
        this.envIntendedReceiversList.register(this.itsEnvelope, "IntendedReceiver");
    }

    public void setReadOnly() {
        this.setEnabled(false);
        this.editable = false;
    }

    public void setEnabled(boolean theBool) {
        this.editable = theBool;
        this.defaultEnvelopeButton.setEnabled(theBool);
        String methodName = "setEditable";
        for (int i = 0; i < this.editsVector.size(); ++i) {
            Object obj = this.editsVector.get(i);
            try {
                Method sn = obj.getClass().getMethod(methodName, Boolean.TYPE);
                Boolean os = new Boolean(this.editable);
                sn.invoke(obj, os);
                continue;
            }
            catch (Exception ex) {
                if (!this.logger.isLoggable(Logger.WARNING)) continue;
                this.logger.log(Logger.WARNING, "Obj: " + obj.getClass().toString() + " " + ex.getMessage());
            }
        }
    }

    public void doSystemOut() {
        if (this.logger.isLoggable(Logger.WARNING)) {
            this.logger.log(Logger.INFO, "\n" + this.itsMsg.toString() + "\n");
        }
    }

    public void saveACL() {
        block7: {
            int returnVal;
            UIManager.put("FileChooser.saveButtonToolTipText", "Save ACLMessage");
            JFileChooser chooser = new JFileChooser();
            chooser.setFileFilter(new ACLFileFilter());
            chooser.setSelectedFile(new File("itsmessage.acl"));
            chooser.setDialogTitle("Save ACLMessage");
            if (this.currentDir != null) {
                chooser.setCurrentDirectory(this.currentDir);
            }
            if ((returnVal = chooser.showSaveDialog(null)) == 0) {
                this.currentDir = chooser.getCurrentDirectory();
                String fileName = chooser.getSelectedFile().getAbsolutePath();
                if (!fileName.endsWith(".acl")) {
                    fileName = fileName + ".acl";
                }
                try {
                    FileWriter f = new FileWriter(fileName);
                    StringACLCodec codec = new StringACLCodec(null, f);
                    codec.write(this.itsMsg);
                    f.close();
                }
                catch (FileNotFoundException e3) {
                    if (this.logger.isLoggable(Logger.WARNING)) {
                        this.logger.log(Logger.WARNING, "Can't open file: " + fileName);
                    }
                }
                catch (IOException e4) {
                    if (!this.logger.isLoggable(Logger.WARNING)) break block7;
                    this.logger.log(Logger.WARNING, "IO Exception");
                }
            }
        }
    }

    public void loadACL() {
        int returnVal;
        UIManager.put("FileChooser.openButtonToolTipText", "Open ACLMessage");
        JFileChooser chooser = new JFileChooser();
        chooser.setFileFilter(new ACLFileFilter());
        chooser.setDialogTitle("Open ACLMessage");
        if (this.currentDir != null) {
            chooser.setCurrentDirectory(this.currentDir);
        }
        if ((returnVal = chooser.showOpenDialog(null)) == 0) {
            this.currentDir = chooser.getCurrentDirectory();
            String fileName = chooser.getSelectedFile().getAbsolutePath();
            try {
                StringACLCodec codec = new StringACLCodec(new FileReader(fileName), null);
                ACLMessage msg = codec.decode();
                this.setItsMsg(msg);
            }
            catch (FileNotFoundException e1) {
                JOptionPane.showMessageDialog(null, "File not found: " + fileName + e1.getMessage(), "Error Message", 0);
                if (this.logger.isLoggable(Logger.WARNING)) {
                    this.logger.log(Logger.WARNING, "File Not Found: " + fileName);
                }
            }
            catch (ACLCodec.CodecException e2) {
                if (this.logger.isLoggable(Logger.WARNING)) {
                    this.logger.log(Logger.WARNING, "Wrong ACL Message in file: " + fileName);
                }
                JOptionPane.showMessageDialog(null, "Wrong ACL Message in file: " + fileName + "\n" + e2.getMessage(), "Error Message", 0);
            }
        }
    }

    public void doZoomContent() {
        ACLContentDialog theDialog = new ACLContentDialog(null, "ACLMessage content", true);
        theDialog.setItsContent(this.getItsMsg());
        theDialog.setEditable(this.editable);
        theDialog.setLocation((int)this.getLocationOnScreen().getX(), (int)this.getLocationOnScreen().getY());
        theDialog.setVisible(true);
        this.contentTextArea.update();
    }

    void setDefaultEnvelope() {
        this.itsMsg.setDefaultEnvelope();
        this.setItsMsg(this.itsMsg);
        if (this.logger.isLoggable(Logger.WARNING)) {
            this.logger.log(Logger.CONFIG, ":" + this.itsEnvelope.toString());
        }
    }

    void senderButton_actionPerformed(ActionEvent e2) {
        this.doShowSender();
    }

    void doShowSender() {
        ACLAIDDialog aidGui = new ACLAIDDialog(this.agent);
        AID currentAID = this.itsMsg.getSender();
        AID editAID = (AID)currentAID.clone();
        aidGui.setItsAID(editAID);
        aidGui.setLocation((int)this.getLocationOnScreen().getX(), (int)this.getLocationOnScreen().getY());
        aidGui.setTitle(this.editable ? "edit ACL: " + editAID.getName() : "view ACL: " + editAID.getName());
        aidGui.setEditable(this.editable);
        aidGui.setVisible(true);
        if (aidGui.getOK()) {
            this.itsMsg.setSender(aidGui.getItsAID());
            this.senderTextField.setText(this.itsMsg.getSender().getName());
        }
    }

    void doShowFrom() {
        ACLAIDDialog aidGui = new ACLAIDDialog(this.agent);
        AID currentAID = this.itsMsg.getEnvelope().getFrom() != null ? this.itsMsg.getEnvelope().getFrom() : new AID();
        AID editAID = (AID)currentAID.clone();
        aidGui.setLocation((int)this.getLocationOnScreen().getX(), (int)this.getLocationOnScreen().getY());
        aidGui.setItsAID(editAID);
        aidGui.setTitle(this.editable ? "edit ACL: " + editAID.getName() : "view ACL: " + editAID.getName());
        aidGui.setEditable(this.editable);
        aidGui.setVisible(true);
        if (aidGui.getOK()) {
            this.itsMsg.getEnvelope().setFrom(aidGui.getItsAID());
            this.envFromTextField.setText(this.itsMsg.getEnvelope().getFrom().getName());
        }
    }

    void replyByButton_actionPerformed(ActionEvent e2) {
        this.doShowTimeDialog();
    }

    void doShowTimeDialog() {
        ACLTimeChooserDialog t = new ACLTimeChooserDialog();
        Date theDate = this.itsMsg.getReplyByDate();
        if (theDate != null) {
            try {
                t.setDate(theDate);
            }
            catch (Exception ee) {
                JOptionPane.showMessageDialog(this, ee.getMessage(), "Incorrect date format", 0);
                if (this.logger.isLoggable(Logger.WARNING)) {
                    this.logger.log(Logger.WARNING, "Incorrect date format");
                }
                return;
            }
        }
        if (this.editable && t.showEditTimeDlg(null) == 1) {
            this.itsMsg.setReplyByDate(t.getDate());
            if (this.itsMsg.getReplyByDate() == null) {
                this.replybyTextField.setText("");
            } else {
                this.replybyTextField.setText(ISO8601.toString(this.itsMsg.getReplyByDate()));
            }
        }
        if (!this.editable) {
            t.showViewTimeDlg(null);
        }
    }

    void doShowEnvTimeDialog() {
        ACLTimeChooserDialog t = new ACLTimeChooserDialog();
        Date theDate = this.itsMsg.getEnvelope().getDate();
        if (theDate != null) {
            try {
                t.setDate(theDate);
            }
            catch (Exception ee) {
                JOptionPane.showMessageDialog(this, ee.getMessage(), "Incorrect date format", 0);
                if (this.logger.isLoggable(Logger.WARNING)) {
                    this.logger.log(Logger.WARNING, "Incorrect date format");
                }
                return;
            }
        }
        if (this.editable && t.showEditTimeDlg(null) == 1) {
            this.itsMsg.getEnvelope().setDate(t.getDate());
            if (this.itsMsg.getEnvelope().getDate() == null) {
                this.envDateTextField.setText("");
            } else {
                this.envDateTextField.setText(ISO8601.toString(this.itsMsg.getEnvelope().getDate()));
            }
        }
        if (!this.editable) {
            t.showViewTimeDlg(null);
        }
    }

    void contentTextArea_mouseClicked(MouseEvent e2) {
        if (e2.getClickCount() > 2 && this.logger.isLoggable(Logger.WARNING)) {
            this.logger.log(Logger.WARNING, "to do display content dialog");
        }
    }

    void senderTextField_mouseClicked(MouseEvent e2) {
        this.doShowSender();
    }

    void replybyTextField_mouseClicked(MouseEvent e2) {
        this.doShowTimeDialog();
    }

    void defaultEnvelopeButton_actionPerformed(ActionEvent e2) {
        this.setDefaultEnvelope();
    }

    void fromButton_actionPerformed(ActionEvent e2) {
        this.doShowFrom();
    }

    void envDateButton_actionPerformed(ActionEvent e2) {
        this.doShowEnvTimeDialog();
    }

    void contentZoomButton_actionPerformed(ActionEvent e2) {
        this.doZoomContent();
    }

    void envFromTextField_mouseClicked(MouseEvent e2) {
        this.doShowFrom();
    }

    void envDateTextField_mouseClicked(MouseEvent e2) {
        this.doShowEnvTimeDialog();
    }

    private void jbInit() throws Exception {
        this.senderLabel.setFont(new Font("Dialog", 0, 11));
        this.senderLabel.setText("sender:");
        this.setBackground(Color.white);
        this.setOpaque(false);
        this.setLayout(this.gridBagLayout1);
        this.receiverLabel.setFont(new Font("Dialog", 0, 11));
        this.receiverLabel.setText("receivers:");
        this.replytoLabel.setFont(new Font("Dialog", 0, 11));
        this.replytoLabel.setText("reply-to");
        this.contentLabel.setFont(new Font("Dialog", 0, 11));
        this.contentLabel.setText("content");
        this.languageLabel.setFont(new Font("Dialog", 0, 11));
        this.languageLabel.setText("language");
        this.encodingLabel.setFont(new Font("Dialog", 0, 11));
        this.encodingLabel.setText("encoding");
        this.ontologyjLabel.setFont(new Font("Dialog", 0, 11));
        this.ontologyjLabel.setText("ontology");
        this.protocolLabel.setFont(new Font("Dialog", 0, 11));
        this.protocolLabel.setText("protocol");
        this.inreplytoLabel.setFont(new Font("Dialog", 0, 11));
        this.inreplytoLabel.setText("in-reply-to");
        this.replywithLabel.setFont(new Font("Dialog", 0, 11));
        this.replywithLabel.setText("reply-with");
        this.replybyLabel.setFont(new Font("Dialog", 0, 11));
        this.replybyLabel.setText("reply-by");
        this.userpropLabel.setFont(new Font("Dialog", 0, 11));
        this.userpropLabel.setText("User-prop.");
        this.protocolComboBox.setBackground(Color.white);
        this.protocolComboBox.setFont(new Font("Dialog", 0, 11));
        this.replytoList.setFont(new Font("Dialog", 0, 11));
        this.convidLabel.setFont(new Font("Dialog", 0, 11));
        this.convidLabel.setText("conv.-id");
        this.userpropList.setFont(new Font("Dialog", 0, 11));
        this.performativeLabel.setFont(new Font("Dialog", 0, 11));
        this.performativeLabel.setText("performative");
        this.senderButton.setBackground(Color.white);
        this.senderButton.setFont(new Font("Dialog", 0, 12));
        this.senderButton.setBorder(null);
        this.senderButton.setMaximumSize(new Dimension(23, 20));
        this.senderButton.setMinimumSize(new Dimension(25, 20));
        this.senderButton.setPreferredSize(new Dimension(25, 20));
        this.senderButton.setToolTipText("Edit/View Sender");
        this.senderButton.setIcon(this.zoomIcon);
        this.senderButton.setMargin(new Insets(0, 0, 0, 0));
        this.senderButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e2) {
                ACLPanel.this.senderButton_actionPerformed(e2);
            }
        });
        this.replyByButton.setBackground(Color.white);
        this.replyByButton.setFont(new Font("Dialog", 0, 12));
        this.replyByButton.setBorder(null);
        this.replyByButton.setMaximumSize(new Dimension(23, 20));
        this.replyByButton.setMinimumSize(new Dimension(23, 20));
        this.replyByButton.setPreferredSize(new Dimension(23, 20));
        this.replyByButton.setToolTipText("Edit/View Reply-by");
        this.replyByButton.setIcon(this.dateIcon);
        this.replyByButton.setMargin(new Insets(0, 0, 0, 0));
        this.replyByButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e2) {
                ACLPanel.this.replyByButton_actionPerformed(e2);
            }
        });
        this.senderTextField.setFont(new Font("Dialog", 0, 11));
        this.senderTextField.setDisabledTextColor(Color.black);
        this.senderTextField.setEnabled(false);
        this.senderTextField.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e2) {
                ACLPanel.this.senderTextField_mouseClicked(e2);
            }
        });
        this.replybyTextField.setFont(new Font("Dialog", 0, 11));
        this.replybyTextField.setDisabledTextColor(Color.black);
        this.replybyTextField.setEnabled(false);
        this.replybyTextField.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e2) {
                ACLPanel.this.replybyTextField_mouseClicked(e2);
            }
        });
        this.performativesComboBox.setBackground(Color.white);
        this.aclTab.setLayout(this.gridBagLayout2);
        this.theTabbedPane.setBackground(Color.white);
        this.theTabbedPane.setFont(new Font("Dialog", 0, 12));
        this.theTabbedPane.setBorder(BorderFactory.createLineBorder(Color.black));
        this.aclTab.setBackground(Color.white);
        this.aclTab.setBorder(BorderFactory.createLoweredBevelBorder());
        this.envelopeTab.setLayout(this.gridBagLayout3);
        this.envelopeTab.setBackground(Color.white);
        this.toLabel.setFont(new Font("Dialog", 0, 11));
        this.toLabel.setText("to");
        this.fromLabel.setFont(new Font("Dialog", 0, 11));
        this.fromLabel.setText("from");
        this.commentsLabel.setFont(new Font("Dialog", 0, 11));
        this.commentsLabel.setText("comments");
        this.aclRepreLabel.setFont(new Font("Dialog", 0, 11));
        this.aclRepreLabel.setToolTipText("ACL Repr");
        this.aclRepreLabel.setText("acl repr.");
        this.payLoadLabel.setFont(new Font("Dialog", 0, 11));
        this.payLoadLabel.setToolTipText("Payload Length");
        this.payLoadLabel.setText("payload len.");
        this.envDateLabel.setFont(new Font("Dialog", 0, 11));
        this.envDateLabel.setToolTipText("Date");
        this.envDateLabel.setText("date");
        this.intReceiversLabel.setFont(new Font("Dialog", 0, 11));
        this.intReceiversLabel.setToolTipText("Intended Receivers");
        this.intReceiversLabel.setText("int. receivers");
        this.jLabel1.setFont(new Font("Dialog", 0, 11));
        this.jLabel1.setToolTipText("Payload Encoding");
        this.jLabel1.setText("payload enc.");
        this.envDateTextField.setFont(new Font("Dialog", 0, 11));
        this.envDateTextField.setToolTipText("");
        this.envDateTextField.setDisabledTextColor(Color.black);
        this.envDateTextField.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e2) {
                ACLPanel.this.envDateTextField_mouseClicked(e2);
            }
        });
        this.envDateTextField.setEnabled(false);
        this.defaultEnvelopeButton.setBackground(Color.white);
        this.defaultEnvelopeButton.setFont(new Font("Dialog", 0, 12));
        this.defaultEnvelopeButton.setIcon(this.envelopeIcon);
        this.defaultEnvelopeButton.setText("set Default Envelope");
        this.defaultEnvelopeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e2) {
                ACLPanel.this.defaultEnvelopeButton_actionPerformed(e2);
            }
        });
        this.fromButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e2) {
                ACLPanel.this.fromButton_actionPerformed(e2);
            }
        });
        this.fromButton.setMargin(new Insets(0, 0, 0, 0));
        this.fromButton.setToolTipText("Edit/View From");
        this.fromButton.setIcon(this.zoomIcon);
        this.fromButton.setPreferredSize(new Dimension(23, 20));
        this.fromButton.setMinimumSize(new Dimension(23, 20));
        this.fromButton.setMaximumSize(new Dimension(23, 20));
        this.fromButton.setFont(new Font("Dialog", 0, 12));
        this.fromButton.setBackground(Color.white);
        this.envFromTextField.setFont(new Font("Dialog", 0, 11));
        this.envFromTextField.setDisabledTextColor(Color.black);
        this.envFromTextField.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e2) {
                ACLPanel.this.envFromTextField_mouseClicked(e2);
            }
        });
        this.envFromTextField.setEnabled(false);
        this.envDateButton.setBackground(Color.white);
        this.envDateButton.setFont(new Font("Dialog", 0, 12));
        this.envDateButton.setMaximumSize(new Dimension(23, 20));
        this.envDateButton.setMinimumSize(new Dimension(23, 20));
        this.envDateButton.setPreferredSize(new Dimension(23, 20));
        this.envDateButton.setToolTipText("Edit/View Date");
        this.envDateButton.setIcon(this.dateIcon);
        this.envDateButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e2) {
                ACLPanel.this.envDateButton_actionPerformed(e2);
            }
        });
        this.contentZoomButton.setBorder(null);
        this.contentZoomButton.setMaximumSize(new Dimension(23, 20));
        this.contentZoomButton.setMinimumSize(new Dimension(23, 20));
        this.contentZoomButton.setToolTipText("Zoom Content Of ACLMessage");
        this.contentZoomButton.setIcon(this.zoomIcon);
        this.contentZoomButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e2) {
                ACLPanel.this.contentZoomButton_actionPerformed(e2);
            }
        });
        this.contentTextArea.setText("");
        this.contentTextArea.setAutoscrolls(true);
        this.contentTextArea.setFont(new Font("Dialog", 0, 11));
        this.aclTab.add((Component)this.senderLabel, new GridBagConstraints(0, 1, 2, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.aclTab.add((Component)this.senderTextField, new GridBagConstraints(2, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.aclTab.add((Component)this.receiverLabel, new GridBagConstraints(0, 2, 2, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.aclTab.add((Component)this.replytoLabel, new GridBagConstraints(0, 3, 2, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.aclTab.add((Component)this.replytoList, new GridBagConstraints(2, 3, 3, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.aclTab.add((Component)this.languageLabel, new GridBagConstraints(0, 6, 2, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.aclTab.add((Component)this.encodingLabel, new GridBagConstraints(0, 7, 2, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.aclTab.add((Component)this.ontologyjLabel, new GridBagConstraints(0, 8, 2, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.aclTab.add((Component)this.protocolLabel, new GridBagConstraints(0, 9, 2, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.aclTab.add((Component)this.inreplytoLabel, new GridBagConstraints(0, 11, 2, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.aclTab.add((Component)this.replywithLabel, new GridBagConstraints(0, 12, 2, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.aclTab.add((Component)this.replybyLabel, new GridBagConstraints(0, 13, 2, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.aclTab.add((Component)this.userpropLabel, new GridBagConstraints(0, 14, 2, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.aclTab.add((Component)this.userpropList, new GridBagConstraints(2, 14, 3, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.aclTab.add((Component)this.encodingTextField, new GridBagConstraints(2, 7, 3, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.aclTab.add((Component)this.ontologyTextField, new GridBagConstraints(2, 8, 3, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.aclTab.add((Component)this.protocolComboBox, new GridBagConstraints(2, 9, 3, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.aclTab.add((Component)this.replywithTextField, new GridBagConstraints(2, 12, 3, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.aclTab.add((Component)this.replybyTextField, new GridBagConstraints(2, 13, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.aclTab.add((Component)this.convidLabel, new GridBagConstraints(0, 10, 2, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.aclTab.add((Component)this.inreplytoTextField, new GridBagConstraints(2, 11, 3, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.aclTab.add((Component)this.conversationTextField, new GridBagConstraints(2, 10, 3, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.aclTab.add((Component)this.receiverList, new GridBagConstraints(2, 2, 3, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.aclTab.add((Component)this.languageTextField, new GridBagConstraints(2, 6, 3, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.aclTab.add((Component)this.performativesComboBox, new GridBagConstraints(2, 0, 3, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.aclTab.add((Component)this.performativeLabel, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.aclTab.add((Component)this.senderButton, new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.aclTab.add((Component)this.replyByButton, new GridBagConstraints(3, 13, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.aclTab.add((Component)this.contentLabel, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 12, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.aclTab.add((Component)this.contentZoomButton, new GridBagConstraints(3, 4, 1, 1, 0.0, 0.0, 11, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.aclTab.add((Component)this.contentTextArea, new GridBagConstraints(0, 5, 4, 1, 2.0, 2.0, 15, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.envelopeTab.add((Component)this.toLabel, new GridBagConstraints(0, 1, 2, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.envelopeTab.add((Component)this.commentsLabel, new GridBagConstraints(0, 2, 2, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.envelopeTab.add((Component)this.aclRepreLabel, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.envelopeTab.add((Component)this.payLoadLabel, new GridBagConstraints(0, 4, 2, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.envelopeTab.add((Component)this.envDateLabel, new GridBagConstraints(0, 6, 2, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.envelopeTab.add((Component)this.intReceiversLabel, new GridBagConstraints(0, 7, 2, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.envelopeTab.add((Component)this.envACLReprTextField, new GridBagConstraints(2, 3, 2, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.envelopeTab.add((Component)this.jLabel1, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.envelopeTab.add((Component)this.envPayloadLengthTextField, new GridBagConstraints(2, 4, 2, 1, 1.0, 0.0, 11, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.envelopeTab.add((Component)this.envPayloadEncodingTextField, new GridBagConstraints(2, 5, 2, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.envelopeTab.add((Component)this.fromLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.envelopeTab.add((Component)this.envToList, new GridBagConstraints(2, 1, 2, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.envelopeTab.add((Component)this.envDateTextField, new GridBagConstraints(2, 6, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.envelopeTab.add((Component)this.envIntendedReceiversList, new GridBagConstraints(2, 7, 2, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.envelopeTab.add((Component)this.defaultEnvelopeButton, new GridBagConstraints(2, 8, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 0, 0, 0), 0, 0));
        this.envelopeTab.add((Component)this.envFromTextField, new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.envelopeTab.add((Component)this.fromButton, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.envelopeTab.add((Component)this.envDateButton, new GridBagConstraints(3, 6, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.envelopeTab.add((Component)this.commentsScrollPane, new GridBagConstraints(2, 2, 2, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.commentsScrollPane.getViewport().add((Component)this.envCommentsTextArea, null);
        this.add((Component)this.theTabbedPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.theTabbedPane.addTab("message", this.messageIcon, this.aclTab, "<html><h1>Message Tab</h1>This tab represents an ACL message compliant to the <p><b>FIPA 2000</b> <p>FIPA ACL Message Structure Specification <p>(fipa000061) specifications. <p>All parameters are couples of <p><em>keyword: value</em> </html>");
        this.theTabbedPane.addTab("envelope", this.envelopeIcon, this.envelopeTab, "<html><h1>Envelope Tab</h1> This tab represents an envelope <p>attached to the ACLMessage. <p>The envelope is used by the <p><b><it>ACC</it></b> for inter-platform messaging.</html>");
    }

    private class ACLFileFilter
    extends FileFilter {
        private String[] extensions = new String[]{".acl"};

        public String getDescription() {
            return "ACLMessage files (*.acl)";
        }

        public boolean accept(File pathName) {
            if (pathName.isDirectory()) {
                return true;
            }
            return pathName.isFile() && pathName.getName().endsWith(".acl");
        }
    }
}

