/*
 * Decompiled with CFR 0.152.
 */
package jade.tools.gui;

import jade.core.AID;
import jade.core.Agent;
import jade.lang.acl.ACLMessage;
import jade.tools.gui.ACLPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;

public class ACLFrame
extends JFrame {
    private GridBagLayout gridBagLayout1 = new GridBagLayout();
    private JPanel buttonPanel = new JPanel();
    private JButton closeButton = new JButton();
    private JMenuBar theMenuBar = new JMenuBar();
    private JMenu fileMenu = new JMenu();
    private JMenuItem saveMenuItem = new JMenuItem();
    private JMenuItem exitMenuItem = new JMenuItem();
    private JMenu toolsMenu = new JMenu();
    private JMenuItem systemoutMenuItem = new JMenuItem();
    private ACLPanel aclPanel;
    private ACLMessage msg;
    private Agent agent;

    public ACLFrame(Agent agent) {
        this.agent = agent;
        try {
            this.aclPanel = new ACLPanel(agent);
            this.jbInit();
            this.setSize(300, 500);
            this.setFrameIcon("images/details.gif");
            Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
            this.setLocation(screenSize.width / 2 - this.getSize().width / 2, screenSize.height / 2 - this.getSize().height / 2);
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    public static void show(ACLMessage theMsg, Agent agent) {
        ACLFrame theFrame = new ACLFrame(agent);
        theFrame.setMsg(theMsg);
        theFrame.disableACLPanel();
    }

    public void setMsg(ACLMessage msg) {
        this.aclPanel.setReadOnly();
        this.aclPanel.setItsMsg(msg);
        String theSender = msg.getSender().getLocalName();
        String theReceiver = "<none>";
        if (msg.getAllReceiver().hasNext()) {
            theReceiver = ((AID)msg.getAllReceiver().next()).getLocalName();
        }
        String theTitle = "(" + ACLMessage.getPerformative(msg.getPerformative()) + ": from " + theSender + " to " + theReceiver + ")";
        this.setTitle(theTitle);
        this.setVisible(true);
    }

    public void disableACLPanel() {
        this.aclPanel.setReadOnly();
    }

    void closeButton_actionPerformed(ActionEvent e2) {
        this.doExit();
    }

    void exitMenuItem_actionPerformed(ActionEvent e2) {
        this.doExit();
    }

    void doExit() {
        this.setVisible(false);
    }

    void systemoutMenuItem_actionPerformed(ActionEvent e2) {
        this.doSystemOut();
    }

    void doSystemOut() {
        this.aclPanel.doSystemOut();
    }

    void saveMenuItem_actionPerformed(ActionEvent e2) {
        this.aclPanel.saveACL();
    }

    private void setFrameIcon(String iconpath) {
        ImageIcon image = new ImageIcon(this.getClass().getResource(iconpath));
        this.setIconImage(image.getImage());
    }

    private void jbInit() throws Exception {
        this.getContentPane().setBackground(Color.white);
        this.setJMenuBar(this.theMenuBar);
        this.getContentPane().setLayout(this.gridBagLayout1);
        this.closeButton.setBackground(Color.white);
        this.closeButton.setFont(new Font("Dialog", 0, 10));
        this.closeButton.setText("close");
        this.closeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e2) {
                ACLFrame.this.closeButton_actionPerformed(e2);
            }
        });
        this.buttonPanel.setBackground(Color.white);
        this.fileMenu.setBackground(Color.white);
        this.fileMenu.setFont(new Font("Dialog", 0, 12));
        this.fileMenu.setMnemonic('F');
        this.fileMenu.setText("File");
        this.saveMenuItem.setBackground(Color.white);
        this.saveMenuItem.setFont(new Font("Dialog", 0, 12));
        this.saveMenuItem.setActionCommand("Save as");
        this.saveMenuItem.setMnemonic('S');
        this.saveMenuItem.setText("Save As...");
        this.saveMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e2) {
                ACLFrame.this.saveMenuItem_actionPerformed(e2);
            }
        });
        this.exitMenuItem.setBackground(Color.white);
        this.exitMenuItem.setFont(new Font("Dialog", 0, 12));
        this.exitMenuItem.setMnemonic('E');
        this.exitMenuItem.setText("Exit");
        this.exitMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e2) {
                ACLFrame.this.exitMenuItem_actionPerformed(e2);
            }
        });
        this.toolsMenu.setBackground(Color.white);
        this.toolsMenu.setFont(new Font("Dialog", 0, 12));
        this.toolsMenu.setText("Tools");
        this.systemoutMenuItem.setBackground(Color.white);
        this.systemoutMenuItem.setFont(new Font("Dialog", 0, 12));
        this.systemoutMenuItem.setMnemonic('S');
        this.systemoutMenuItem.setText("System.out");
        this.systemoutMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e2) {
                ACLFrame.this.systemoutMenuItem_actionPerformed(e2);
            }
        });
        this.theMenuBar.setBackground(Color.white);
        this.theMenuBar.setFont(new Font("Dialog", 0, 12));
        this.getContentPane().add((Component)this.aclPanel, new GridBagConstraints(0, 0, 2, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.getContentPane().add((Component)this.buttonPanel, new GridBagConstraints(0, 1, 2, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.buttonPanel.add((Component)this.closeButton, null);
        this.theMenuBar.add(this.fileMenu);
        this.theMenuBar.add(this.toolsMenu);
        this.fileMenu.add(this.saveMenuItem);
        this.fileMenu.addSeparator();
        this.fileMenu.add(this.exitMenuItem);
        this.toolsMenu.add(this.systemoutMenuItem);
    }
}

