/*
 * Decompiled with CFR 0.152.
 */
package jade.tools.gui;

import jade.core.AID;
import jade.core.Agent;
import jade.lang.acl.ACLMessage;
import jade.tools.gui.ACLAIDDialog;
import jade.util.leap.Iterator;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.lang.reflect.Method;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class ACLAIDList
extends JPanel {
    private String MSG = "msg";
    private String AID = "Aid";
    private JScrollPane contentScrollPane = new JScrollPane();
    private JList contentList = new JList();
    private GridBagLayout gridBagLayout1 = new GridBagLayout();
    private JButton viewButton = new JButton();
    private JButton addButton = new JButton();
    private JButton deleteButton = new JButton();
    private DefaultListModel listModel = new DefaultListModel();
    private AIDListCellRenderer aidListCellRenderer = new AIDListCellRenderer();
    private boolean editable = true;
    private String fieldName = "";
    private String mode = this.MSG;
    private Agent agent;
    private AIDListListener theDataListener;
    private ACLMessage itsMsg;
    private AID itsAid;
    private Object itsObj;

    public ACLAIDList(Agent agent) {
        this.agent = agent;
        try {
            this.jbInit();
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    public void setEditable(boolean theBool) {
        if (!theBool) {
            this.editable = false;
            this.addButton.setEnabled(false);
            this.deleteButton.setEnabled(false);
        }
    }

    public void register(Object o, String fieldName) {
        this.listModel.removeAllElements();
        this.itsObj = o;
        this.mode = this.MSG;
        this.fieldName = fieldName;
        String methodName = "getAll" + fieldName;
        try {
            Method sn = this.itsObj.getClass().getMethod(methodName, null);
            Iterator itor = (Iterator)sn.invoke(this.itsObj, new Object[0]);
            while (itor.hasNext()) {
                AID theAID = (AID)itor.next();
                this.listModel.addElement(theAID);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.theDataListener = new AIDListListener();
        this.theDataListener.register(this.itsObj, fieldName);
        this.listModel.addListDataListener(this.theDataListener);
        this.contentList.setModel(this.listModel);
    }

    public void register(AID aid, String fieldName) {
        this.itsAid = aid;
        this.mode = this.AID;
        this.fieldName = fieldName;
        String methodName = "getAll" + fieldName;
        try {
            Method sn = aid.getClass().getMethod(methodName, null);
            Iterator itor = (Iterator)sn.invoke((Object)aid, new Object[0]);
            while (itor.hasNext()) {
                AID theAID = (AID)itor.next();
                this.listModel.addElement(theAID);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.theDataListener = new AIDListListener();
        this.theDataListener.register(aid, fieldName);
        this.listModel.addListDataListener(this.theDataListener);
        this.contentList.setModel(this.listModel);
    }

    void doView() {
        int index = this.contentList.getSelectedIndex();
        if (index < 0) {
            return;
        }
        AID currentAID = (AID)this.listModel.getElementAt(index);
        AID editAID = (AID)currentAID.clone();
        ACLAIDDialog theDialog = new ACLAIDDialog(this.agent);
        theDialog.setLocation((int)this.getLocationOnScreen().getX(), (int)this.getLocationOnScreen().getY());
        theDialog.setItsAID(editAID);
        theDialog.setEditable(this.editable);
        theDialog.setTitle(this.editable ? "Edit AID of: " + currentAID.getName() : "View AID of:" + currentAID.getName());
        theDialog.setVisible(true);
        if (theDialog.getOK()) {
            this.theDataListener.registerChangedAID(theDialog.getItsAID());
            this.listModel.setElementAt(editAID, index);
        }
    }

    void deleteButton_actionPerformed(ActionEvent e2) {
        this.doDelete();
    }

    void doDelete() {
        int index = this.contentList.getSelectedIndex();
        if (index >= 0) {
            this.theDataListener.registerRemovedAID((AID)this.listModel.getElementAt(index));
            this.listModel.remove(index);
        }
    }

    void addButton_actionPerformed(ActionEvent e2) {
        this.doAdd();
    }

    void doAdd() {
        ACLAIDDialog theGui = new ACLAIDDialog(this.agent);
        theGui.setTitle("<new AID>");
        theGui.setLocation((int)this.getLocationOnScreen().getX(), (int)this.getLocationOnScreen().getY());
        theGui.localCheckBox.setSelected(false);
        theGui.setVisible(true);
        if (theGui.getOK()) {
            this.listModel.addElement(theGui.getItsAID());
        }
    }

    void viewButton_actionPerformed(ActionEvent e2) {
        this.doView();
    }

    void contentList_mouseClicked(MouseEvent e2) {
        if (e2.getClickCount() > 1) {
            this.doView();
        }
    }

    void contentList_keyPressed(KeyEvent e2) {
        if (e2.getKeyCode() == 10) {
            this.doView();
        }
        if (!this.editable) {
            return;
        }
        if (e2.getKeyCode() == 155) {
            this.doAdd();
        }
        if (e2.getKeyCode() == 127) {
            this.doDelete();
        }
    }

    private void jbInit() throws Exception {
        this.setLayout(this.gridBagLayout1);
        this.viewButton.setBackground(Color.white);
        this.viewButton.setFont(new Font("Dialog", 0, 11));
        this.viewButton.setForeground(new Color(0, 0, 83));
        this.viewButton.setMinimumSize(new Dimension(13, 5));
        this.viewButton.setPreferredSize(new Dimension(13, 11));
        this.viewButton.setToolTipText("edit/view AgentIDentifier (AID)");
        this.viewButton.setMargin(new Insets(0, 0, 0, 0));
        this.viewButton.setText("v");
        this.viewButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e2) {
                ACLAIDList.this.viewButton_actionPerformed(e2);
            }
        });
        this.addButton.setBackground(Color.white);
        this.addButton.setFont(new Font("Dialog", 0, 11));
        this.addButton.setForeground(new Color(0, 0, 83));
        this.addButton.setMinimumSize(new Dimension(13, 5));
        this.addButton.setPreferredSize(new Dimension(13, 11));
        this.addButton.setToolTipText("add AgentIDentifier (AID)");
        this.addButton.setMargin(new Insets(0, 0, 0, 0));
        this.addButton.setText("+");
        this.addButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e2) {
                ACLAIDList.this.addButton_actionPerformed(e2);
            }
        });
        this.deleteButton.setBackground(Color.white);
        this.deleteButton.setFont(new Font("Dialog", 0, 11));
        this.deleteButton.setForeground(new Color(0, 0, 83));
        this.deleteButton.setMinimumSize(new Dimension(13, 5));
        this.deleteButton.setPreferredSize(new Dimension(13, 11));
        this.deleteButton.setToolTipText("delete AgentIDentifier (AID)");
        this.deleteButton.setMargin(new Insets(0, 0, 0, 0));
        this.deleteButton.setText("x");
        this.deleteButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e2) {
                ACLAIDList.this.deleteButton_actionPerformed(e2);
            }
        });
        this.contentList.setCellRenderer(this.aidListCellRenderer);
        this.contentList.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e2) {
                ACLAIDList.this.contentList_keyPressed(e2);
            }
        });
        this.contentList.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e2) {
                ACLAIDList.this.contentList_mouseClicked(e2);
            }
        });
        this.contentScrollPane.setBorder(BorderFactory.createLineBorder(Color.black));
        this.add((Component)this.addButton, new GridBagConstraints(2, 1, 0, 1, 0.0, 1.0, 10, 3, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.deleteButton, new GridBagConstraints(2, 2, 0, 1, 0.0, 1.0, 10, 3, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.viewButton, new GridBagConstraints(2, 0, 0, 1, 0.0, 1.0, 10, 3, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.contentScrollPane, new GridBagConstraints(0, 0, 1, 3, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.contentScrollPane.getViewport().add((Component)this.contentList, null);
    }

    public class AIDListListener
    implements ListDataListener {
        String fieldName = "";
        private AID theRemovedAID;
        private AID theChangedAID;
        private Object itsObj;

        public void register(Object obj, String fieldName) {
            this.itsObj = obj;
            this.fieldName = fieldName;
        }

        public void intervalAdded(ListDataEvent parm1) {
            DefaultListModel lm = (DefaultListModel)parm1.getSource();
            int index = parm1.getIndex0();
            AID newAID = (AID)lm.elementAt(index);
            String methodName = "add" + this.fieldName;
            String theType = "jade.core.AID";
            try {
                Method sn = this.itsObj.getClass().getMethod(methodName, Class.forName(theType));
                AID os = newAID;
                sn.invoke(this.itsObj, os);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }

        public void registerRemovedAID(AID theRemovedAID) {
            this.theRemovedAID = theRemovedAID;
        }

        public void registerChangedAID(AID theChangedAID) {
            this.theChangedAID = theChangedAID;
        }

        public void intervalRemoved(ListDataEvent parm1) {
            String methodName = "remove" + this.fieldName;
            String theType = "jade.core.AID";
            try {
                Method sn = this.itsObj.getClass().getMethod(methodName, Class.forName(theType));
                AID os = this.theRemovedAID;
                sn.invoke(this.itsObj, os);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }

        public void contentsChanged(ListDataEvent parm1) {
            DefaultListModel lm = (DefaultListModel)parm1.getSource();
            int index = parm1.getIndex0();
            if (index < 0) {
                return;
            }
            String removeMethodName = "remove" + this.fieldName;
            String addMethodName = "remove" + this.fieldName;
            AID currentAID = (AID)lm.get(index);
            String theType = "jade.core.AID";
            try {
                Method removeMethod = this.itsObj.getClass().getMethod(removeMethodName, Class.forName(theType));
                removeMethod.invoke(this.itsObj, currentAID);
                Method addMethod = this.itsObj.getClass().getMethod(addMethodName, Class.forName(theType));
                removeMethod.invoke(this.itsObj, this.theChangedAID);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public class AIDListCellRenderer
    extends JLabel
    implements ListCellRenderer {
        public AIDListCellRenderer() {
            this.setOpaque(true);
            this.setFont(new Font("Dialog", 0, 11));
        }

        public Component getListCellRendererComponent(JList list2, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (value != null && value instanceof AID) {
                AID theAID = (AID)value;
                this.setText(theAID.getName());
            }
            this.setBackground(isSelected ? Color.blue : Color.white);
            this.setForeground(isSelected ? Color.white : Color.black);
            return this;
        }
    }
}

