/*
 * Decompiled with CFR 0.152.
 */
package jade.tools.applet;

import jade.core.AID;
import jade.domain.DFGUIAdapter;
import jade.domain.FIPAAgentManagement.DFAgentDescription;
import jade.domain.FIPAAgentManagement.SearchConstraints;
import jade.domain.FIPAAgentManagement.ServiceDescription;
import jade.domain.FIPAException;
import jade.gui.GuiEvent;
import jade.lang.acl.ACLParser;
import jade.tools.applet.FIPAAppletRequestProto;
import jade.tools.applet.JADEAppletRequestProto;
import jade.tools.dfgui.DFGUI;
import jade.util.Logger;
import jade.util.leap.ArrayList;
import jade.util.leap.Iterator;
import jade.util.leap.List;
import java.applet.Applet;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.net.Socket;

public class DFAppletCommunicator
implements DFGUIAdapter {
    private Applet a;
    private DataInputStream in;
    private PrintStream out;
    private static final int DEFAULT_PORT = 6789;
    private ACLParser parser;
    private DFGUI gui;
    private String address;
    private String hap;
    private DFAgentDescription thisDF = null;
    private Logger logger = Logger.getMyLogger(this.getClass().getName());

    public DFAppletCommunicator(Applet applet) {
        try {
            this.a = applet;
            this.hap = this.a.getParameter("HAP");
            if (this.logger.isLoggable(Logger.FINEST)) {
                this.logger.log(Logger.FINEST, "HAP:" + this.hap);
            }
            Socket s = new Socket(this.a.getCodeBase().getHost(), 6789);
            if (this.logger.isLoggable(Logger.CONFIG)) {
                this.logger.log(Logger.CONFIG, "DFAppletClient connected to local port " + s.getLocalPort() + " and remote port " + s.getPort());
            }
            this.in = new DataInputStream(s.getInputStream());
            this.parser = new ACLParser(this.in);
            this.out = new PrintStream(s.getOutputStream(), true);
        }
        catch (IOException e2) {
            e2.printStackTrace();
            this.a.stop();
        }
    }

    void setGUI(DFGUI g) {
        this.gui = g;
    }

    DFGUI getGUI() {
        return this.gui;
    }

    public void doDelete() {
        this.gui.showStatusMsg("Operation not authorized");
    }

    public String getName() {
        String dfName = "df@" + this.hap;
        return dfName;
    }

    public void postGuiEvent(GuiEvent event) {
        switch (event.getType()) {
            case 0: {
                this.gui.dispose();
                this.a.destroy();
                break;
            }
            case 1: {
                this.gui.dispose();
                this.a.destroy();
                break;
            }
            case 1006: {
                this.refreshDFGUI();
                break;
            }
            case 1001: {
                this.RegisterNewAgent(event);
                break;
            }
            case 1002: {
                this.DeregisterAgent(event);
                break;
            }
            case 1004: {
                this.SearchAgents(event);
                break;
            }
            case 1003: {
                this.Modify(event);
                break;
            }
            case 1005: {
                this.Federate(event);
            }
        }
    }

    public void refreshDFGUI() {
        AID df2 = this.getDescriptionOfThisDF().getName();
        DFAgentDescription dfd = new DFAgentDescription();
        SearchConstraints sc = new SearchConstraints();
        try {
            FIPAAppletRequestProto arp = new FIPAAppletRequestProto(this, df2, "search", dfd, sc);
            arp.doProto();
            Iterator result = arp.getSearchResult().iterator();
            ArrayList listOfAID = new ArrayList();
            ArrayList listOfChildren = new ArrayList();
            while (result.hasNext()) {
                DFAgentDescription next = (DFAgentDescription)result.next();
                listOfAID.add(next.getName());
                if (!this.isADF(next)) continue;
                listOfChildren.add(next.getName());
            }
            JADEAppletRequestProto getParent = new JADEAppletRequestProto(this, this.getDescriptionOfThisDF().getName(), "getparents", null, null);
            getParent.doProto();
            Iterator parents = getParent.getResult().iterator();
            this.gui.refresh(listOfAID.iterator(), parents, listOfChildren.iterator());
        }
        catch (FIPAAppletRequestProto.NotYetReady nyr) {
            nyr.printStackTrace();
        }
        catch (JADEAppletRequestProto.NotYetReady ex) {
            ex.printStackTrace();
        }
        catch (FIPAException e2) {
            e2.printStackTrace();
        }
    }

    private void RegisterNewAgent(GuiEvent event) {
        AID df2 = (AID)event.getParameter(0);
        DFAgentDescription dfd = (DFAgentDescription)event.getParameter(1);
        if (df2.getName().equalsIgnoreCase(this.thisDF.getName().getName())) {
            try {
                FIPAAppletRequestProto rf = new FIPAAppletRequestProto(this, df2, "register", dfd, null);
                rf.doProto();
            }
            catch (FIPAException e2) {
                e2.printStackTrace();
            }
        } else {
            try {
                JADEAppletRequestProto requestBehav = new JADEAppletRequestProto(this, this.getDescriptionOfThisDF().getName(), "registerwith", dfd, df2);
                requestBehav.doProto();
            }
            catch (FIPAException e3) {
                e3.printStackTrace();
            }
        }
    }

    private void DeregisterAgent(GuiEvent event) {
        AID df2 = (AID)event.getParameter(0);
        DFAgentDescription dfd = (DFAgentDescription)event.getParameter(1);
        if (df2.getName().equalsIgnoreCase(this.thisDF.getName().getName())) {
            try {
                FIPAAppletRequestProto rf = new FIPAAppletRequestProto(this, df2, "deregister", dfd, null);
                rf.doProto();
            }
            catch (FIPAException e2) {
                e2.printStackTrace();
            }
        } else {
            try {
                JADEAppletRequestProto rf = new JADEAppletRequestProto(this, this.getDescriptionOfThisDF().getName(), "deregisterfrom", dfd, df2);
                rf.doProto();
            }
            catch (FIPAException e3) {
                e3.printStackTrace();
            }
        }
    }

    private void SearchAgents(GuiEvent event) {
        AID df2 = (AID)event.getParameter(0);
        DFAgentDescription dfd = (DFAgentDescription)event.getParameter(1);
        SearchConstraints sc = (SearchConstraints)event.getParameter(2);
        if (df2.getName().equalsIgnoreCase(this.thisDF.getName().getName())) {
            try {
                FIPAAppletRequestProto rf = new FIPAAppletRequestProto(this, df2, "search", dfd, sc);
                rf.doProto();
            }
            catch (FIPAException e2) {
                e2.printStackTrace();
            }
        } else {
            try {
                JADEAppletRequestProto rf = new JADEAppletRequestProto(this, this.getDescriptionOfThisDF().getName(), "searchon", dfd, df2, sc);
                rf.doProto();
            }
            catch (FIPAException e3) {
                e3.printStackTrace();
            }
        }
    }

    private void Modify(GuiEvent event) {
        AID df2 = (AID)event.getParameter(0);
        DFAgentDescription dfd = (DFAgentDescription)event.getParameter(1);
        if (df2.equals(this.thisDF.getName())) {
            try {
                FIPAAppletRequestProto rf = new FIPAAppletRequestProto(this, df2, "modify", dfd, null);
                rf.doProto();
            }
            catch (FIPAException e2) {
                e2.printStackTrace();
            }
        } else {
            try {
                JADEAppletRequestProto rf = new JADEAppletRequestProto(this, this.thisDF.getName(), "modifyon", dfd, df2);
                rf.doProto();
            }
            catch (FIPAException e3) {
                e3.printStackTrace();
            }
        }
    }

    private void Federate(GuiEvent event) {
        AID parentDF = (AID)event.getParameter(0);
        if (parentDF.equals(this.thisDF.getName())) {
            this.gui.showStatusMsg("Self federation not allowed.");
            return;
        }
        DFAgentDescription dfd = (DFAgentDescription)event.getParameter(1);
        try {
            JADEAppletRequestProto rf = new JADEAppletRequestProto(this, this.getDescriptionOfThisDF().getName(), "federate", dfd, parentDF);
            rf.doProto();
        }
        catch (FIPAException e2) {
            e2.printStackTrace();
        }
    }

    public DFAgentDescription getDFAgentDsc(AID name) throws FIPAException {
        DFAgentDescription outDesc = null;
        AID df2 = this.getDescriptionOfThisDF().getName();
        DFAgentDescription dfd = new DFAgentDescription();
        dfd.setName(name);
        SearchConstraints sc = new SearchConstraints();
        try {
            FIPAAppletRequestProto arp = new FIPAAppletRequestProto(this, df2, "search", dfd, sc);
            arp.doProto();
            Iterator result = arp.getSearchResult().iterator();
            if (result.hasNext()) {
                outDesc = (DFAgentDescription)result.next();
            }
        }
        catch (FIPAAppletRequestProto.NotYetReady nyr) {
            nyr.printStackTrace();
        }
        catch (FIPAException e2) {
            e2.printStackTrace();
        }
        return outDesc;
    }

    public DFAgentDescription getDescriptionOfThisDF() {
        if (this.thisDF == null) {
            AID df2 = new AID(this.getName(), true);
            System.out.println(df2.getName());
            try {
                JADEAppletRequestProto rf = new JADEAppletRequestProto(this, df2, "getdescription", null, null);
                rf.doProto();
            }
            catch (FIPAException e2) {
                e2.printStackTrace();
            }
        }
        return this.thisDF;
    }

    public DFAgentDescription getDescriptionOfThisDF(AID df2) {
        if (this.logger.isLoggable(Logger.FINEST)) {
            this.logger.log(Logger.FINEST, "CALLED METHOD: getDescriptionOfThisDF(aid) into DFAppletCommunicator");
        }
        DFAgentDescription output = null;
        try {
            JADEAppletRequestProto rf = new JADEAppletRequestProto(this, this.getDescriptionOfThisDF().getName(), "getdescriptionused", null, df2);
            rf.doProto();
            List result = rf.getResult();
            output = (DFAgentDescription)result.get(0);
        }
        catch (FIPAException e2) {
            e2.printStackTrace();
        }
        catch (JADEAppletRequestProto.NotYetReady nyr) {
            nyr.printStackTrace();
        }
        return output;
    }

    boolean isADF(DFAgentDescription dfd) {
        try {
            ServiceDescription sd = (ServiceDescription)dfd.getAllServices().next();
            return sd.getType().equalsIgnoreCase("fipa-df");
        }
        catch (Exception e2) {
            return false;
        }
    }

    void setDescription(DFAgentDescription dfd) {
        this.thisDF = dfd;
    }

    PrintStream getStream() {
        return this.out;
    }

    ACLParser getParser() {
        return this.parser;
    }
}

