/*
 * Decompiled with CFR 0.152.
 */
package jade.tools.applet;

import jade.content.abs.AbsContentElement;
import jade.content.lang.Codec;
import jade.content.lang.sl.SLCodec;
import jade.content.onto.Ontology;
import jade.content.onto.OntologyException;
import jade.content.onto.basic.Action;
import jade.content.onto.basic.Result;
import jade.domain.FIPAException;
import jade.lang.acl.ACLMessage;
import jade.lang.acl.ACLParser;
import jade.lang.acl.ParseException;
import jade.util.Logger;
import java.io.PrintStream;

abstract class AppletRequestProto {
    ACLMessage reqMsg;
    boolean notYetReady;
    PrintStream myOut;
    ACLParser myParser;
    private Logger logger = Logger.getMyLogger(this.getClass().getName());

    AppletRequestProto(PrintStream out, ACLParser parser, ACLMessage request) {
        this.myOut = out;
        this.myParser = parser;
        this.notYetReady = true;
        try {
            this.reqMsg = (ACLMessage)request.clone();
            this.reqMsg.setPerformative(16);
        }
        catch (Exception e2) {
            this.reqMsg = new ACLMessage(16);
        }
    }

    public void doProto() {
        this.sendMessage(this.reqMsg.toString());
        try {
            ACLMessage reply = this.receiveMessage();
            if (this.logger.isLoggable(Logger.INFO)) {
                this.logger.log(Logger.INFO, "Received Message:" + reply.toString());
            }
            if (1 == reply.getPerformative()) {
                this.handleAgree(reply);
                ACLMessage inform = this.receiveMessage();
                if (this.logger.isLoggable(Logger.INFO)) {
                    this.logger.log(Logger.INFO, inform.toString());
                }
                if (7 == inform.getPerformative()) {
                    this.handleInform(inform);
                } else if (6 == inform.getPerformative()) {
                    this.handleFailure(inform);
                } else {
                    this.handleOtherMessage(inform);
                }
            } else if (7 == reply.getPerformative()) {
                this.handleInform(reply);
            } else if (14 == reply.getPerformative()) {
                this.handleRefuse(reply);
            } else if (10 == reply.getPerformative()) {
                this.handleNotUnderstood(reply);
            } else {
                this.handleOtherMessage(reply);
            }
        }
        catch (ParseException e2) {
            e2.printStackTrace();
        }
    }

    private ACLMessage receiveMessage() throws ParseException {
        return this.myParser.Message();
    }

    private void sendMessage(String msg) {
        this.myOut.println(msg);
    }

    protected abstract void handleAgree(ACLMessage var1);

    protected abstract void handleInform(ACLMessage var1);

    protected abstract void handleRefuse(ACLMessage var1);

    protected abstract void handleFailure(ACLMessage var1);

    protected abstract void handleNotUnderstood(ACLMessage var1);

    protected abstract void handleOtherMessage(ACLMessage var1);

    static String encode(Action act, SLCodec c, Ontology o) throws FIPAException {
        try {
            return c.encode((AbsContentElement)o.fromObject(act));
        }
        catch (OntologyException oe) {
            throw new FIPAException(oe.getMessage());
        }
        catch (Codec.CodecException el) {
            el.printStackTrace();
            throw new FIPAException(el.getMessage());
        }
    }

    static Result extractContent(String content, SLCodec c, Ontology o) throws FIPAException {
        try {
            AbsContentElement tuple = c.decode(o, content);
            return (Result)o.toObject(tuple);
        }
        catch (Codec.CodecException e1) {
            e1.printStackTrace();
            throw new FIPAException(e1.getMessage());
        }
        catch (OntologyException e2) {
            e2.printStackTrace();
            throw new FIPAException(e2.getMessage());
        }
    }
}

