/*
 * Decompiled with CFR 0.152.
 */
package jade.tools.SocketProxyAgent;

import jade.core.Agent;
import jade.tools.SocketProxyAgent.Server;
import jade.util.Logger;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.StringTokenizer;
import java.util.Vector;

public class SocketProxyAgent
extends Agent {
    public static final int DEFAULT_PORT = 6789;
    private static final Logger logger = Logger.getMyLogger(SocketProxyAgent.class.getName());
    private BufferedReader in;
    private Server proxyServer;
    int portNumber = 6789;
    private static final int ONE_SEC_AS_MS = 1000;

    protected void setup() {
        try {
            String myName = this.getLocalName();
            logger.log(Logger.CONFIG, "My agent name:" + myName);
            Vector<String> agentNames = new Vector<String>();
            String fileName = myName + ".inf";
            String configSource = "*unset!*";
            try {
                Reader reader;
                Object[] arguments = this.getArguments();
                if (null != arguments && null != arguments[0] && arguments[0] instanceof String) {
                    String arg0 = (String)arguments[0];
                    String arg1 = "*";
                    if (arguments.length > 1) {
                        arg1 = (String)arguments[1];
                    }
                    configSource = "agent arguments: \"" + arg0 + "\", \"" + arg1 + "\"";
                    reader = new StringReader(arg0 + "\n" + arg1 + "\n");
                } else {
                    configSource = "file \"" + fileName + "\"";
                    reader = new FileReader(fileName);
                }
                logger.log(Logger.CONFIG, "reading configuration from " + configSource);
                this.in = new BufferedReader(reader);
                this.portNumber = Integer.parseInt(this.in.readLine());
                StringTokenizer st = new StringTokenizer(this.in.readLine());
                while (st.hasMoreTokens()) {
                    int atPos;
                    String name = st.nextToken();
                    if (!name.equals("*") && (atPos = name.lastIndexOf(64)) == -1) {
                        name = name + "@" + this.getHap();
                    }
                    if (logger.isLoggable(Logger.FINE)) {
                        logger.log(Logger.FINE, "Legal addressee:" + name);
                    }
                    agentNames.add(name);
                }
            }
            catch (Exception e2) {
                logger.log(Logger.WARNING, "Unable to read configuration from " + configSource + ", so will use default settings.");
                this.portNumber = 6789;
                agentNames.add("*");
            }
            if (logger.isLoggable(Logger.FINE)) {
                logger.log(Logger.FINE, "Attempting to open a server socket on port: " + this.portNumber);
                int agentNameCount = agentNames.size();
                if (0 == agentNameCount) {
                    logger.log(Logger.SEVERE, "no agent names!");
                } else {
                    for (int i = 0; i < agentNameCount; ++i) {
                        logger.log(Logger.FINE, "agent name " + i + ": \"" + agentNames.get(i) + "\"");
                    }
                }
            }
            this.proxyServer = new Server(this.portNumber, this, agentNames);
        }
        catch (Exception e3) {
            logger.log(Logger.SEVERE, "Failed to start server socket" + e3, e3);
            e3.printStackTrace();
            this.doDelete();
        }
    }

    public int getPort() {
        return this.portNumber;
    }

    protected void takeDown() {
        try {
            if (this.in != null) {
                this.in.close();
                this.in = null;
            }
        }
        catch (Exception e2) {
            // empty catch block
        }
        try {
            if (this.proxyServer != null) {
                this.proxyServer.interrupt();
                this.proxyServer.closeDown();
                this.proxyServer.join(1000L);
                this.proxyServer = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

