/*
 * Decompiled with CFR 0.152.
 */
package jade.tools.SocketProxyAgent;

import jade.lang.acl.ACLMessage;
import jade.lang.acl.ACLParser;
import jade.util.Logger;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Date;

public class JadeBridge {
    public static final long DEFAULT_TIMEOUT = 60000L;
    public static final String DEFAULT_AGENT_PROXY_HOST = "localhost";
    public static final int DEFAULT_AGENT_PROXY_PORT = 6789;
    private static final Logger logger = Logger.getMyLogger(JadeBridge.class.getName());
    private String host;
    private int port;

    public JadeBridge() {
        this(DEFAULT_AGENT_PROXY_HOST, 6789);
    }

    public JadeBridge(String aHost, int aPort) {
        this.host = aHost;
        this.port = aPort;
        logger.log(Logger.CONFIG, "bridge constructed for " + this.host + ":" + this.port);
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String sendMessage(String aMsg) {
        if (logger.isLoggable(Logger.FINE)) {
            logger.log(Logger.FINE, "msg to send:" + aMsg);
        }
        String response = null;
        try {
            response = this.sendACL(aMsg, 60000L).toString();
        }
        catch (Exception e2) {
            response = "Exception when sending ACL:" + e2;
        }
        if (logger.isLoggable(Logger.FINE)) {
            logger.log(Logger.FINE, "response:" + response);
        }
        return response;
    }

    public ACLMessage sendMessage(ACLMessage aMsg) {
        return this.sendMessage(aMsg, 60000L);
    }

    public ACLMessage sendMessage(ACLMessage aMsg, long timeout) {
        if (logger.isLoggable(Logger.FINE)) {
            logger.log(Logger.FINE, "msg to send:" + aMsg);
        }
        ACLMessage response = null;
        if (timeout > 0L && aMsg.getReplyByDate() == null) {
            aMsg.setReplyByDate(new Date(System.currentTimeMillis() + timeout));
        }
        try {
            response = this.sendACL(aMsg.toString(), timeout);
        }
        catch (Exception e2) {
            response = new ACLMessage(6);
            response.setContent("Exception when sending ACL:" + e2);
        }
        if (logger.isLoggable(Logger.FINE)) {
            logger.log(Logger.FINE, "response:" + response);
        }
        return response;
    }

    public ACLMessage sendACL(String aMsg, long timeout) throws IOException, UnknownHostException, SocketException {
        if (logger.isLoggable(Logger.FINE)) {
            logger.log(Logger.FINE, "msg to send:" + aMsg);
        }
        Socket socket = new Socket(this.host, this.port);
        if (timeout > 0L) {
            socket.setSoTimeout((int)timeout);
        }
        if (logger.isLoggable(Logger.FINE)) {
            logger.log(Logger.FINE, "created socket to host \"" + this.host + "\", port " + this.port + ", timeout " + timeout + "ms");
        }
        ACLMessage response = null;
        PrintStream out = new PrintStream(socket.getOutputStream());
        DataInputStream in = new DataInputStream(socket.getInputStream());
        out.println(aMsg);
        out.flush();
        Date startTime = new Date();
        if (logger.isLoggable(Logger.FINE)) {
            logger.log(Logger.FINE, "trying to get response...");
        }
        try {
            ACLParser parser = new ACLParser(in);
            response = parser.Message();
            if (logger.isLoggable(Logger.FINE)) {
                logger.log(Logger.FINE, "response:" + response);
            }
        }
        catch (Throwable any) {
            Date endTime;
            long millisecs;
            if (logger.isLoggable(Logger.WARNING)) {
                logger.log(Logger.WARNING, "caught " + any + " trying to get response", any);
            }
            if ((millisecs = (endTime = new Date()).getTime() - startTime.getTime()) > timeout * 95L / 100L) {
                response = new ACLMessage(6);
                response.setContent("( \"Timeout waiting for response from SocketProxy.\" )");
            }
            response = new ACLMessage(6);
            response.setContent("( \"JadeBridge error in parsing ACL response from SocketProxy:" + any + "\" )");
        }
        socket.close();
        if (logger.isLoggable(Logger.FINE)) {
            logger.log(Logger.FINE, "returning...");
        }
        return response;
    }
}

