/*
 * Decompiled with CFR 0.152.
 */
package jade.proto;

import jade.core.AID;
import jade.core.Agent;
import jade.core.behaviours.Behaviour;
import jade.core.behaviours.DataStore;
import jade.core.behaviours.FSMBehaviour;
import jade.core.behaviours.OneShotBehaviour;
import jade.lang.acl.ACLMessage;
import jade.lang.acl.MessageTemplate;
import jade.proto.states.MsgReceiver;
import jade.util.leap.ArrayList;
import jade.util.leap.HashMap;
import jade.util.leap.Iterator;
import jade.util.leap.Map;
import jade.util.leap.Serializable;
import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;

public class ProposeInitiator
extends FSMBehaviour {
    protected final String INITIATION_K = "__initiation" + this.hashCode();
    protected final String ALL_INITIATIONS_K = "__all-initiations" + this.hashCode();
    public final String REPLY_KEY = "__reply" + this.hashCode();
    public final String ALL_RESPONSES_KEY = "__all-responses" + this.hashCode();
    protected static final String PREPARE_INITIATIONS = "Prepare-initiations";
    protected static final String SEND_INITIATIONS = "Send-initiations";
    protected static final String RECEIVE_REPLY = "Receive-reply";
    protected static final String CHECK_IN_SEQ = "Check-in-seq";
    protected static final String HANDLE_NOT_UNDERSTOOD = "Handle-not-understood";
    protected static final String HANDLE_OUT_OF_SEQ = "Handle-out-of-seq";
    protected static final String HANDLE_ALL_RESPONSES = "Handle-all-responses";
    protected static final String HANDLE_REJECT_PROPOSAL = "Handle-reject-proposal";
    protected static final String HANDLE_ACCEPT_PROPOSAL = "Handle-accept-proposal";
    private static final String CHECK_AGAIN = "Check-again";
    protected static final String CHECK_SESSIONS = "Check-sessions";
    protected static final String DUMMY_FINAL = "Dummy-final";
    protected Map sessions = new HashMap();
    protected MsgReceiver replyReceiver = null;
    protected MessageTemplate replyTemplate = null;
    private ACLMessage initiation;
    private static final int ALL_RESPONSES_RECEIVED = 1;
    private static final int TERMINATED = 2;
    protected String[] toBeReset = new String[]{"Handle-accept-proposal", "Handle-reject-proposal", "Handle-not-understood", "Handle-out-of-seq"};
    private boolean allResponsesReceived = false;

    public ProposeInitiator(Agent a, ACLMessage msg) {
        this(a, msg, new DataStore());
    }

    public ProposeInitiator(Agent a, ACLMessage initiation, DataStore store) {
        super(a);
        this.setDataStore(store);
        this.initiation = initiation;
        this.registerDefaultTransition(PREPARE_INITIATIONS, SEND_INITIATIONS);
        this.registerTransition(SEND_INITIATIONS, DUMMY_FINAL, 0);
        this.registerDefaultTransition(SEND_INITIATIONS, RECEIVE_REPLY);
        this.registerTransition(RECEIVE_REPLY, CHECK_SESSIONS, -1001);
        this.registerTransition(RECEIVE_REPLY, CHECK_SESSIONS, -1002);
        this.registerDefaultTransition(RECEIVE_REPLY, CHECK_IN_SEQ);
        this.registerTransition(CHECK_IN_SEQ, HANDLE_NOT_UNDERSTOOD, 10);
        this.registerTransition(CHECK_IN_SEQ, HANDLE_REJECT_PROPOSAL, 15);
        this.registerTransition(CHECK_IN_SEQ, HANDLE_ACCEPT_PROPOSAL, 0);
        this.registerDefaultTransition(CHECK_IN_SEQ, HANDLE_OUT_OF_SEQ);
        this.registerDefaultTransition(HANDLE_NOT_UNDERSTOOD, CHECK_SESSIONS);
        this.registerDefaultTransition(HANDLE_REJECT_PROPOSAL, CHECK_SESSIONS);
        this.registerDefaultTransition(HANDLE_ACCEPT_PROPOSAL, CHECK_SESSIONS);
        this.registerDefaultTransition(HANDLE_OUT_OF_SEQ, RECEIVE_REPLY);
        this.registerDefaultTransition(CHECK_SESSIONS, RECEIVE_REPLY, this.toBeReset);
        this.registerTransition(CHECK_SESSIONS, HANDLE_ALL_RESPONSES, 1);
        this.registerTransition(CHECK_SESSIONS, DUMMY_FINAL, 2);
        this.registerDefaultTransition(HANDLE_ALL_RESPONSES, CHECK_AGAIN);
        this.registerTransition(CHECK_AGAIN, DUMMY_FINAL, 0);
        this.registerDefaultTransition(CHECK_AGAIN, RECEIVE_REPLY, this.toBeReset);
        OneShotBehaviour b = null;
        b = new OneShotBehaviour(this.myAgent){
            private static final long serialVersionUID = 3487495895818000L;

            public void action() {
                DataStore ds = this.getDataStore();
                Vector allInitiations = ProposeInitiator.this.prepareInitiations((ACLMessage)ds.get(ProposeInitiator.this.INITIATION_K));
                this.getDataStore().put(ProposeInitiator.this.ALL_INITIATIONS_K, allInitiations);
            }
        };
        b.setDataStore(this.getDataStore());
        this.registerFirstState(b, PREPARE_INITIATIONS);
        b = new OneShotBehaviour(this.myAgent){
            private static final long serialVersionUID = 3487495895818001L;

            public void action() {
                Vector allInitiations = (Vector)this.getDataStore().get(ProposeInitiator.this.ALL_INITIATIONS_K);
                if (allInitiations != null) {
                    ProposeInitiator.this.sendInitiations(allInitiations);
                }
            }

            public int onEnd() {
                return ProposeInitiator.this.sessions.size();
            }
        };
        b.setDataStore(this.getDataStore());
        this.registerState(b, SEND_INITIATIONS);
        this.replyReceiver = new MsgReceiver(this.myAgent, null, -1L, this.getDataStore(), this.REPLY_KEY);
        this.registerState(this.replyReceiver, RECEIVE_REPLY);
        b = new OneShotBehaviour(this.myAgent){
            int ret;
            private static final long serialVersionUID = 3487495895818002L;

            public void action() {
                ACLMessage reply = (ACLMessage)this.getDataStore().get(ProposeInitiator.this.REPLY_KEY);
                this.ret = ProposeInitiator.this.checkInSequence(reply) ? reply.getPerformative() : -1;
            }

            public int onEnd() {
                return this.ret;
            }
        };
        b.setDataStore(this.getDataStore());
        this.registerState(b, CHECK_IN_SEQ);
        b = new OneShotBehaviour(this.myAgent){

            public void action() {
                ProposeInitiator.this.handleAllResponses((Vector)this.getDataStore().get(ProposeInitiator.this.ALL_RESPONSES_KEY));
            }
        };
        b.setDataStore(this.getDataStore());
        this.registerState(b, HANDLE_ALL_RESPONSES);
        b = new OneShotBehaviour(this.myAgent){

            public void action() {
                ProposeInitiator.this.handleAcceptProposal((ACLMessage)this.getDataStore().get(ProposeInitiator.this.REPLY_KEY));
            }
        };
        b.setDataStore(this.getDataStore());
        this.registerState(b, HANDLE_ACCEPT_PROPOSAL);
        b = new OneShotBehaviour(this.myAgent){

            public void action() {
                ProposeInitiator.this.handleRejectProposal((ACLMessage)this.getDataStore().get(ProposeInitiator.this.REPLY_KEY));
            }
        };
        b.setDataStore(this.getDataStore());
        this.registerState(b, HANDLE_REJECT_PROPOSAL);
        b = new OneShotBehaviour(this.myAgent){
            private static final long serialVersionUID = 3487495895818005L;

            public void action() {
                ProposeInitiator.this.handleNotUnderstood((ACLMessage)this.getDataStore().get(ProposeInitiator.this.REPLY_KEY));
            }
        };
        b.setDataStore(this.getDataStore());
        this.registerState(b, HANDLE_NOT_UNDERSTOOD);
        b = new OneShotBehaviour(this.myAgent){
            private static final long serialVersionUID = 3487495895818008L;

            public void action() {
                ProposeInitiator.this.handleOutOfSequence((ACLMessage)this.getDataStore().get(ProposeInitiator.this.REPLY_KEY));
            }
        };
        b.setDataStore(this.getDataStore());
        this.registerState(b, HANDLE_OUT_OF_SEQ);
        b = new OneShotBehaviour(this.myAgent){
            int ret;
            private static final long serialVersionUID = 3487495895818009L;

            public void action() {
                ACLMessage reply = (ACLMessage)this.getDataStore().get(ProposeInitiator.this.REPLY_KEY);
                this.ret = ProposeInitiator.this.checkSessions(reply);
            }

            public int onEnd() {
                return this.ret;
            }
        };
        b.setDataStore(this.getDataStore());
        this.registerState(b, CHECK_SESSIONS);
        b = new OneShotBehaviour(this.myAgent){

            public void action() {
            }

            public int onEnd() {
                return ProposeInitiator.this.sessions.size();
            }
        };
        b.setDataStore(this.getDataStore());
        this.registerState(b, CHECK_AGAIN);
        b = new OneShotBehaviour(this.myAgent){
            private static final long serialVersionUID = 3487495895818010L;

            public void action() {
            }
        };
        this.registerLastState(b, DUMMY_FINAL);
    }

    protected void initializeDataStore(ACLMessage msg) {
        this.getDataStore().put(this.INITIATION_K, this.initiation);
        Vector l = new Vector();
        this.getDataStore().put(this.ALL_RESPONSES_KEY, l);
    }

    protected void sendInitiations(Vector initiations) {
        long currentTime = System.currentTimeMillis();
        long minTimeout = -1L;
        long deadline = -1L;
        String conversationID = this.createConvId(initiations);
        this.replyTemplate = MessageTemplate.MatchConversationId(conversationID);
        int cnt = 0;
        Enumeration e2 = initiations.elements();
        while (e2.hasMoreElements()) {
            long timeout;
            ACLMessage proposal = (ACLMessage)e2.nextElement();
            if (proposal == null) continue;
            ACLMessage toSend = (ACLMessage)proposal.clone();
            toSend.setProtocol("fipa-propose");
            toSend.setConversationId(conversationID);
            Iterator receivers = proposal.getAllReceiver();
            while (receivers.hasNext()) {
                toSend.clearAllReceiver();
                AID r = (AID)receivers.next();
                toSend.addReceiver(r);
                String sessionKey = "R" + this.hashCode() + "_" + Integer.toString(cnt);
                toSend.setReplyWith(sessionKey);
                this.sessions.put(sessionKey, new Session());
                this.adjustReplyTemplate(toSend);
                this.myAgent.send(toSend);
                this.getDataStore().put(r, toSend);
                ++cnt;
            }
            Date d = proposal.getReplyByDate();
            if (d == null || (timeout = d.getTime() - currentTime) <= 0L || timeout >= minTimeout && minTimeout > 0L) continue;
            minTimeout = timeout;
            deadline = d.getTime();
        }
        this.replyReceiver.setTemplate(this.replyTemplate);
        this.replyReceiver.setDeadline(deadline);
    }

    protected boolean checkInSequence(ACLMessage reply) {
        int perf;
        String inReplyTo = reply.getInReplyTo();
        Session s = (Session)this.sessions.get(inReplyTo);
        if (s != null && s.update(perf = reply.getPerformative())) {
            switch (s.getState()) {
                case 2: 
                case 3: {
                    Vector allRsp = (Vector)this.getDataStore().get(this.ALL_RESPONSES_KEY);
                    allRsp.addElement(reply);
                    break;
                }
                default: {
                    return false;
                }
            }
            if (s.isCompleted()) {
                this.sessions.remove(inReplyTo);
            }
            return true;
        }
        return false;
    }

    protected int checkSessions(ACLMessage reply) {
        int ret = -1;
        if (this.getLastExitValue() == -1001) {
            if (!this.allResponsesReceived) {
                ArrayList sessionsToRemove = new ArrayList(this.sessions.size());
                Iterator i = this.sessions.keySet().iterator();
                while (i.hasNext()) {
                    Object key = i.next();
                    Session s = (Session)this.sessions.get(key);
                    if (s.getState() != 0) continue;
                    sessionsToRemove.add(key);
                }
                i = sessionsToRemove.iterator();
                while (i.hasNext()) {
                    this.sessions.remove(i.next());
                }
                sessionsToRemove = null;
            } else {
                this.sessions.clear();
            }
        }
        if (!this.allResponsesReceived) {
            this.allResponsesReceived = true;
            Iterator it = this.sessions.values().iterator();
            while (it.hasNext()) {
                Session s = (Session)it.next();
                if (s.getState() != 0) continue;
                this.allResponsesReceived = false;
                break;
            }
            if (this.allResponsesReceived) {
                this.replyReceiver.setDeadline(-1L);
                ret = 1;
            }
        } else if (this.sessions.size() == 0) {
            ret = 2;
        }
        return ret;
    }

    protected Vector prepareInitiations(ACLMessage propose) {
        Vector<ACLMessage> v = new Vector<ACLMessage>(1);
        v.addElement(propose);
        return v;
    }

    protected void handleAcceptProposal(ACLMessage accept_proposal) {
    }

    protected void handleRejectProposal(ACLMessage reject_proposal) {
    }

    protected void handleNotUnderstood(ACLMessage notUnderstood) {
    }

    protected void handleOutOfSequence(ACLMessage msg) {
    }

    public void registerHandleAllResponses(Behaviour b) {
        this.registerState(b, HANDLE_ALL_RESPONSES);
        b.setDataStore(this.getDataStore());
    }

    public void registerHandleAcceptProposal(Behaviour b) {
        this.registerState(b, HANDLE_ACCEPT_PROPOSAL);
        b.setDataStore(this.getDataStore());
    }

    public void registerHandleRejectProposal(Behaviour b) {
        this.registerState(b, HANDLE_REJECT_PROPOSAL);
        b.setDataStore(this.getDataStore());
    }

    public void registerHandleNotUnderstood(Behaviour b) {
        this.registerState(b, HANDLE_NOT_UNDERSTOOD);
        b.setDataStore(this.getDataStore());
    }

    public void registerHandleOutOfSequence(Behaviour b) {
        this.registerState(b, HANDLE_OUT_OF_SEQ);
        b.setDataStore(this.getDataStore());
    }

    protected void handleAllResponses(Vector responses) {
    }

    public void reset() {
        this.reset(null);
    }

    public void reset(ACLMessage msg) {
        super.reset();
        this.replyReceiver.reset(null, -1L, this.getDataStore(), this.REPLY_KEY);
        this.initiation = msg;
        this.sessions.clear();
        this.allResponsesReceived = false;
    }

    public void onStart() {
        this.initializeDataStore(this.initiation);
    }

    public void setDataStore(DataStore ds) {
        super.setDataStore(ds);
        Iterator it = this.getChildren().iterator();
        while (it.hasNext()) {
            Behaviour b = (Behaviour)it.next();
            b.setDataStore(ds);
        }
    }

    protected String createConvId(Vector msgs) {
        String convId = null;
        if (msgs.size() > 0) {
            ACLMessage msg = (ACLMessage)msgs.elementAt(0);
            convId = msg == null || msg.getConversationId() == null ? "C" + this.hashCode() + "_" + System.currentTimeMillis() : msg.getConversationId();
        }
        return convId;
    }

    protected void adjustReplyTemplate(ACLMessage msg) {
        AID r = (AID)msg.getAllReceiver().next();
        if (this.myAgent.getAID().equals(r)) {
            this.replyTemplate = MessageTemplate.and(this.replyTemplate, MessageTemplate.not(MessageTemplate.MatchCustom(msg, true)));
        }
    }

    private static class Session
    implements Serializable {
        static final int INIT = 0;
        static final int NEGATIVE_RESPONSE_RECEIVED = 2;
        static final int RESULT_NOTIFICATION_RECEIVED = 3;
        private int state = 0;

        private Session() {
        }

        boolean update(int perf) {
            switch (this.state) {
                case 0: {
                    switch (perf) {
                        case 10: {
                            this.state = 2;
                            return true;
                        }
                        case 0: 
                        case 15: {
                            this.state = 3;
                            return true;
                        }
                    }
                    return false;
                }
            }
            return false;
        }

        int getState() {
            return this.state;
        }

        boolean isCompleted() {
            return this.state == 2 || this.state == 3;
        }
    }
}

