/*
 * Decompiled with CFR 0.152.
 */
package jade.lang.acl;

import jade.core.AID;
import jade.core.CaseInsensitiveString;
import jade.lang.acl.ACLCodec;
import jade.lang.acl.ACLMessage;
import jade.lang.acl.ACLParser;
import jade.lang.acl.ISO8601;
import jade.lang.acl.TokenMgrError;
import jade.util.leap.Iterator;
import jade.util.leap.Properties;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.Date;
import java.util.Enumeration;
import org.apache.commons.codec.binary.Base64;

public class StringACLCodec
implements ACLCodec {
    public static final String NAME = "fipa.acl.rep.string.std";
    private static final String BASE64ENCODING_KEY = "JADE-Encoding";
    private static final String BASE64ENCODING_VALUE = "Base64";
    private static final String SENDER = " :sender ";
    private static final String RECEIVER = " :receiver ";
    private static final String CONTENT = " :content ";
    private static final String REPLY_WITH = " :reply-with ";
    private static final String IN_REPLY_TO = " :in-reply-to ";
    private static final String REPLY_TO = " :reply-to ";
    private static final String LANGUAGE = " :language ";
    private static final String ENCODING = " :encoding ";
    private static final String ONTOLOGY = " :ontology ";
    private static final String REPLY_BY = " :reply-by ";
    private static final String PROTOCOL = " :protocol ";
    private static final String CONVERSATION_ID = " :conversation-id ";
    ACLParser parser = null;
    Writer out = null;
    private static final String illegalFirstChar = "#0123456789-";

    public StringACLCodec() {
    }

    public StringACLCodec(Reader r, Writer w) {
        this.parser = new ACLParser(r);
        this.out = w;
    }

    private void checkBase64Encoding(ACLMessage msg) {
        String encoding = msg.getUserDefinedParameter(BASE64ENCODING_KEY);
        if (CaseInsensitiveString.equalsIgnoreCase(BASE64ENCODING_VALUE, encoding)) {
            try {
                String content = msg.getContent();
                if (content != null && content.length() > 0) {
                    msg.setByteSequenceContent(Base64.decodeBase64((byte[])content.getBytes("US-ASCII")));
                    msg.removeUserDefinedParameter(BASE64ENCODING_KEY);
                }
            }
            catch (StringIndexOutOfBoundsException e2) {
                e2.printStackTrace();
            }
            catch (NullPointerException e2) {
                e2.printStackTrace();
            }
            catch (NoClassDefFoundError jlncdfe) {
                System.err.println("\t\t===== E R R O R !!! =======\n");
                System.err.println("Missing support for Base64 conversions");
                System.err.println("Please refer to the documentation for details.");
                System.err.println("=============================================\n\n");
                try {
                    Thread.currentThread();
                    Thread.sleep(3000L);
                }
                catch (InterruptedException ie) {}
            }
            catch (UnsupportedEncodingException e3) {
                System.err.println("\t\t===== E R R O R !!! =======\n");
                System.err.println("Missing support for US-ASCII encoding for Base64 conversions");
            }
        }
    }

    public ACLMessage decode() throws ACLCodec.CodecException {
        try {
            ACLMessage msg = this.parser.Message();
            this.checkBase64Encoding(msg);
            return msg;
        }
        catch (TokenMgrError e1) {
            throw new ACLCodec.CodecException(this.getName() + " ACLMessage decoding token exception", e1);
        }
        catch (Exception e2) {
            throw new ACLCodec.CodecException(this.getName() + " ACLMessage decoding exception", e2);
        }
    }

    public AID decodeAID() throws ACLCodec.CodecException {
        try {
            return this.parser.parseAID(null);
        }
        catch (TokenMgrError e1) {
            throw new ACLCodec.CodecException(this.getName() + " AID decoding token exception", e1);
        }
        catch (Exception e2) {
            e2.printStackTrace();
            throw new ACLCodec.CodecException(this.getName() + " AID decoding exception", e2);
        }
    }

    public void write(ACLMessage msg) {
        try {
            this.out.write(StringACLCodec.toString(msg));
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    private static String escape(String s) {
        StringBuffer result = new StringBuffer(s.length() + 20);
        for (int i = 0; i < s.length(); ++i) {
            if (s.charAt(i) == '\"') {
                result.append("\\\"");
                continue;
            }
            result.append(s.charAt(i));
        }
        return result.toString();
    }

    private static String quotedString(String str) {
        return "\"" + StringACLCodec.escape(str) + "\"";
    }

    static String toString(ACLMessage msg) {
        String tmp;
        Iterator it;
        StringBuffer str = new StringBuffer("(");
        str.append(ACLMessage.getPerformative(msg.getPerformative()) + "\n");
        AID sender = msg.getSender();
        if (sender != null) {
            str.append(" :sender  " + sender.toString() + "\n");
        }
        if ((it = msg.getAllReceiver()).hasNext()) {
            str.append(" :receiver  (set ");
            while (it.hasNext()) {
                str.append(it.next().toString() + " ");
            }
            str.append(")\n");
        }
        if ((it = msg.getAllReplyTo()).hasNext()) {
            str.append(" :reply-to  (set \n");
            while (it.hasNext()) {
                str.append(it.next().toString() + " ");
            }
            str.append(")\n");
        }
        if (msg.hasByteSequenceContent()) {
            str.append(":X-JADE-Encoding Base64\n");
            try {
                String b64 = new String(Base64.encodeBase64((byte[])msg.getByteSequenceContent()), "US-ASCII");
                str.append(" :content  \"" + b64 + "\" \n");
            }
            catch (NoClassDefFoundError jlncdfe) {
                System.err.println("\n\t===== E R R O R !!! =======\n");
                System.err.println("Missing support for Base64 conversions");
                System.err.println("Please refer to the documentation for details.");
                System.err.println("=============================================\n\n");
                System.err.println("");
                try {
                    Thread.currentThread();
                    Thread.sleep(3000L);
                }
                catch (InterruptedException ie) {
                }
            }
            catch (UnsupportedEncodingException e2) {
                System.err.println("\n\t===== E R R O R !!! =======\n");
                System.err.println("Missing support for US-ASCII encoding for Base64 conversions");
                System.err.println("Please refer to the documentation for details.");
                System.err.println("=============================================\n\n");
                System.err.println("");
                try {
                    Thread.currentThread();
                    Thread.sleep(3000L);
                }
                catch (InterruptedException ie) {}
            }
        } else {
            String content = msg.getContent();
            if (content != null && (content = content.trim()).length() > 0) {
                str.append(" :content  \"" + StringACLCodec.escape(content) + "\" \n");
            }
        }
        StringACLCodec.appendACLExpression(str, REPLY_WITH, msg.getReplyWith());
        StringACLCodec.appendACLExpression(str, IN_REPLY_TO, msg.getInReplyTo());
        StringACLCodec.appendACLExpression(str, ENCODING, msg.getEncoding());
        StringACLCodec.appendACLExpression(str, LANGUAGE, msg.getLanguage());
        StringACLCodec.appendACLExpression(str, ONTOLOGY, msg.getOntology());
        Date d = msg.getReplyByDate();
        if (d != null) {
            str.append(" :reply-by  " + ISO8601.toString(d) + "\n");
        }
        if ((tmp = msg.getProtocol()) != null && (tmp = tmp.trim()).length() > 0) {
            str.append(" :protocol  " + tmp + "\n");
        }
        StringACLCodec.appendACLExpression(str, CONVERSATION_ID, msg.getConversationId());
        Properties userDefProps = msg.getAllUserDefinedParameters();
        if (userDefProps != null) {
            Enumeration<?> e2 = userDefProps.propertyNames();
            while (e2.hasMoreElements()) {
                String key = (String)e2.nextElement();
                if (key.indexOf(32) == -1) {
                    if (!key.startsWith("X-") && !key.startsWith("x-")) {
                        StringACLCodec.appendACLExpression(str, ":X-" + key, userDefProps.getProperty(key));
                        continue;
                    }
                    StringACLCodec.appendACLExpression(str, ":" + key, userDefProps.getProperty(key));
                    continue;
                }
                System.err.println("WARNING: The slotName of user-defined parameters cannot contain blanks inside. Therefore " + key + " is not being encoded");
            }
        }
        str.append(")");
        return str.toString();
    }

    public byte[] encode(ACLMessage msg, String charset) {
        try {
            return StringACLCodec.toString(msg).getBytes(charset);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            return new byte[0];
        }
    }

    public ACLMessage decode(byte[] data, String charset) throws ACLCodec.CodecException {
        try {
            ACLMessage msg = ACLParser.create().parse(new InputStreamReader((InputStream)new ByteArrayInputStream(data), charset));
            this.checkBase64Encoding(msg);
            return msg;
        }
        catch (TokenMgrError e1) {
            throw new ACLCodec.CodecException(this.getName() + " ACLMessage decoding token exception", e1);
        }
        catch (Exception e2) {
            throw new ACLCodec.CodecException(this.getName() + " ACLMessage decoding exception", e2);
        }
    }

    public String getName() {
        return NAME;
    }

    public static void appendACLExpression(StringBuffer str, String slotName, String slotValue) {
        if (slotValue != null && slotValue.length() > 0) {
            if (!StringACLCodec.isAWord(slotValue)) {
                try {
                    Double.valueOf(slotValue);
                }
                catch (NumberFormatException e2) {
                    slotValue = StringACLCodec.quotedString(slotValue);
                }
            }
            str.append(slotName + " " + slotValue + " ");
        }
    }

    private static boolean isAWord(String s) {
        if (s == null || s.length() == 0) {
            return false;
        }
        if (illegalFirstChar.indexOf(s.charAt(0)) >= 0) {
            return false;
        }
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c != '\"' && c != '(' && c != ')' && c > ' ') continue;
            return false;
        }
        return true;
    }
}

