/*
 * Decompiled with CFR 0.152.
 */
package jade.lang.acl;

import jade.core.AID;
import jade.lang.acl.ACLCodec;
import jade.lang.acl.ACLMessage;
import jade.util.leap.Iterator;
import jade.util.leap.Properties;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Date;
import java.util.Enumeration;

public class LEAPACLCodec
implements ACLCodec {
    public static final String NAME = "leap.acl.rep";

    public byte[] encode(ACLMessage msg, String charset) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        try {
            LEAPACLCodec.serializeACL(msg, dos);
            return baos.toByteArray();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            return new byte[0];
        }
    }

    public ACLMessage decode(byte[] data, String charset) throws ACLCodec.CodecException {
        DataInputStream din = new DataInputStream(new ByteArrayInputStream(data));
        try {
            return LEAPACLCodec.deserializeACL(din);
        }
        catch (IOException ioe) {
            throw new ACLCodec.CodecException(this.getName() + " ACLMessage decoding exception", ioe);
        }
    }

    public String getName() {
        return NAME;
    }

    public static final void serializeACL(ACLMessage msg, DataOutputStream dos) throws IOException {
        dos.writeByte(msg.getPerformative());
        int presence1 = 0;
        int presence2 = 0;
        AID sender = msg.getSender();
        String language = msg.getLanguage();
        String ontology = msg.getOntology();
        String encoding = msg.getEncoding();
        String protocol = msg.getProtocol();
        String conversationId = msg.getConversationId();
        String inReplyTo = msg.getInReplyTo();
        String replyWith = msg.getReplyWith();
        Date replyBy = msg.getReplyByDate();
        Properties props = msg.getAllUserDefinedParameters();
        if (props.size() > 63) {
            throw new IOException("Cannot serialize more than 63 params");
        }
        if (sender != null) {
            presence1 = (byte)(presence1 | 0x80);
        }
        if (language != null) {
            presence1 = (byte)(presence1 | 0x40);
        }
        if (ontology != null) {
            presence1 = (byte)(presence1 | 0x20);
        }
        if (encoding != null) {
            presence1 = (byte)(presence1 | 0x10);
        }
        if (protocol != null) {
            presence1 = (byte)(presence1 | 8);
        }
        if (conversationId != null) {
            presence1 = (byte)(presence1 | 4);
        }
        if (inReplyTo != null) {
            presence1 = (byte)(presence1 | 2);
        }
        if (replyWith != null) {
            presence1 = (byte)(presence1 | 1);
        }
        if (replyBy != null) {
            presence2 = (byte)(presence2 | 0x80);
        }
        presence2 = (byte)(presence2 | props.size() & 0x3F);
        dos.writeByte(presence1);
        dos.writeByte(presence2);
        if (sender != null) {
            LEAPACLCodec.serializeAID(sender, dos);
        }
        if (language != null) {
            dos.writeUTF(language);
        }
        if (ontology != null) {
            dos.writeUTF(ontology);
        }
        if (encoding != null) {
            dos.writeUTF(encoding);
        }
        if (protocol != null) {
            dos.writeUTF(protocol);
        }
        if (conversationId != null) {
            dos.writeUTF(conversationId);
        }
        if (inReplyTo != null) {
            dos.writeUTF(inReplyTo);
        }
        if (replyWith != null) {
            dos.writeUTF(replyWith);
        }
        if (replyBy != null) {
            dos.writeLong(replyBy.getTime());
        }
        LEAPACLCodec.serializeProperties(props, dos);
        Iterator it = msg.getAllReceiver();
        while (it.hasNext()) {
            dos.writeBoolean(true);
            LEAPACLCodec.serializeAID((AID)it.next(), dos);
        }
        dos.writeBoolean(false);
        it = msg.getAllReplyTo();
        while (it.hasNext()) {
            dos.writeBoolean(true);
            LEAPACLCodec.serializeAID((AID)it.next(), dos);
        }
        dos.writeBoolean(false);
        if (msg.hasByteSequenceContent()) {
            dos.writeByte(2);
            byte[] content = msg.getByteSequenceContent();
            dos.writeInt(content.length);
            dos.write(content, 0, content.length);
        } else {
            String content = msg.getContent();
            if (content != null) {
                dos.writeByte(1);
                byte[] bscontent = content.getBytes();
                dos.writeInt(bscontent.length);
                dos.write(bscontent, 0, bscontent.length);
            } else {
                dos.writeByte(0);
            }
        }
    }

    public static final ACLMessage deserializeACL(DataInputStream dis) throws IOException {
        byte[] content;
        ACLMessage msg = new ACLMessage(dis.readByte());
        byte presence1 = dis.readByte();
        byte presence2 = dis.readByte();
        if ((presence1 & 0x80) != 0) {
            msg.setSender(LEAPACLCodec.deserializeAID(dis));
        }
        if ((presence1 & 0x40) != 0) {
            msg.setLanguage(dis.readUTF());
        }
        if ((presence1 & 0x20) != 0) {
            msg.setOntology(dis.readUTF());
        }
        if ((presence1 & 0x10) != 0) {
            msg.setEncoding(dis.readUTF());
        }
        if ((presence1 & 8) != 0) {
            msg.setProtocol(dis.readUTF());
        }
        if ((presence1 & 4) != 0) {
            msg.setConversationId(dis.readUTF());
        }
        if ((presence1 & 2) != 0) {
            msg.setInReplyTo(dis.readUTF());
        }
        if ((presence1 & 1) != 0) {
            msg.setReplyWith(dis.readUTF());
        }
        if ((presence2 & 0x80) != 0) {
            msg.setReplyByDate(new Date(dis.readLong()));
        }
        int propsSize = presence2 & 0x3F;
        for (int i = 0; i < propsSize; ++i) {
            String key = dis.readUTF();
            String val = dis.readUTF();
            msg.addUserDefinedParameter(key, val);
        }
        while (dis.readBoolean()) {
            msg.addReceiver(LEAPACLCodec.deserializeAID(dis));
        }
        while (dis.readBoolean()) {
            msg.addReplyTo(LEAPACLCodec.deserializeAID(dis));
        }
        byte type = dis.readByte();
        if (type == 2) {
            content = new byte[dis.readInt()];
            dis.read(content, 0, content.length);
            msg.setByteSequenceContent(content);
        } else if (type == 1) {
            content = new byte[dis.readInt()];
            dis.read(content, 0, content.length);
            msg.setContent(new String(content));
        }
        return msg;
    }

    public static final void serializeAID(AID id, DataOutputStream dos) throws IOException {
        int presence = 0;
        String name = id.getName();
        Iterator addresses = id.getAllAddresses();
        Iterator resolvers = id.getAllResolvers();
        Properties props = id.getAllUserDefinedSlot();
        if (props.size() > 31) {
            throw new IOException("Cannot serialize more than 31 slots");
        }
        if (name != null) {
            presence = (byte)(presence | 0x80);
        }
        if (addresses.hasNext()) {
            presence = (byte)(presence | 0x40);
        }
        if (resolvers.hasNext()) {
            presence = (byte)(presence | 0x20);
        }
        presence = (byte)(presence | props.size() & 0x1F);
        dos.writeByte(presence);
        if (name != null) {
            dos.writeUTF(name);
        }
        while (addresses.hasNext()) {
            dos.writeUTF((String)addresses.next());
            dos.writeBoolean(addresses.hasNext());
        }
        while (resolvers.hasNext()) {
            LEAPACLCodec.serializeAID((AID)resolvers.next(), dos);
            dos.writeBoolean(resolvers.hasNext());
        }
        LEAPACLCodec.serializeProperties(props, dos);
    }

    public static final AID deserializeAID(DataInputStream dis) throws IOException {
        AID id;
        byte presence = dis.readByte();
        AID aID = id = (presence & 0x80) != 0 ? new AID(dis.readUTF(), true) : new AID();
        if ((presence & 0x40) != 0) {
            do {
                id.addAddresses(dis.readUTF());
            } while (dis.readBoolean());
        }
        if ((presence & 0x20) != 0) {
            do {
                id.addResolvers(LEAPACLCodec.deserializeAID(dis));
            } while (dis.readBoolean());
        }
        int propsSize = presence & 0x1F;
        for (int i = 0; i < propsSize; ++i) {
            String key = dis.readUTF();
            String val = dis.readUTF();
            id.addUserDefinedSlot(key, val);
        }
        return id;
    }

    private static final void serializeProperties(Properties props, DataOutputStream dos) throws IOException {
        Enumeration<Object> e2 = props.keys();
        while (e2.hasMoreElements()) {
            String key = (String)e2.nextElement();
            dos.writeUTF(key);
            dos.writeUTF(props.getProperty(key));
        }
    }
}

