/*
 * Decompiled with CFR 0.152.
 */
package jade.lang.acl;

import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

public class ISO8601 {
    private static Calendar localCal = Calendar.getInstance();
    private static Calendar utcCal = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
    private static char plus = (char)43;
    private static char minus = (char)45;
    private static String z = "Z";
    private static char t = (char)84;
    private static final long year = 31536000000L;
    private static final long month = 2592000000L;
    private static final long day = 86400000L;
    private static final long hour = 3600000L;
    private static final long minute = 60000L;
    private static final long sec = 1000L;

    private static Date parseutcDateFormat(String dateTimeToken) throws Exception {
        ISO8601.subparse(utcCal, dateTimeToken);
        return utcCal.getTime();
    }

    private static Date parselocalDateFormat(String dateTimeToken) throws Exception {
        ISO8601.subparse(localCal, dateTimeToken);
        return localCal.getTime();
    }

    private static void subparse(Calendar cal, String dateTimeToken) {
        cal.set(1, Integer.parseInt(dateTimeToken.substring(0, 4)));
        cal.set(2, Integer.parseInt(dateTimeToken.substring(4, 6)) - 1);
        cal.set(5, Integer.parseInt(dateTimeToken.substring(6, 8)));
        cal.set(11, Integer.parseInt(dateTimeToken.substring(9, 11)));
        cal.set(12, Integer.parseInt(dateTimeToken.substring(11, 13)));
        cal.set(13, Integer.parseInt(dateTimeToken.substring(13, 15)));
        cal.set(14, Integer.parseInt(dateTimeToken.substring(15, 18)));
    }

    private static String formatlocalDate(Date d) {
        localCal.setTime(d);
        return ISO8601.subFormatDate(localCal);
    }

    private static String formatutcDate(Date d) {
        utcCal.setTime(d);
        return ISO8601.subFormatDate(utcCal) + z;
    }

    private static String subFormatDate(Calendar cal) {
        StringBuffer formatedDate = new StringBuffer();
        formatedDate.append(ISO8601.zeroPaddingNumber(cal.get(1), 4));
        formatedDate.append(ISO8601.zeroPaddingNumber(cal.get(2) + 1, 2));
        formatedDate.append(ISO8601.zeroPaddingNumber(cal.get(5), 2));
        formatedDate.append(t);
        formatedDate.append(ISO8601.zeroPaddingNumber(cal.get(11), 2));
        formatedDate.append(ISO8601.zeroPaddingNumber(cal.get(12), 2));
        formatedDate.append(ISO8601.zeroPaddingNumber(cal.get(13), 2));
        formatedDate.append(ISO8601.zeroPaddingNumber(cal.get(14), 3));
        return formatedDate.toString();
    }

    public static synchronized Date toDate(String dateTimeToken) throws Exception {
        if (dateTimeToken == null) {
            return new Date();
        }
        char sign = dateTimeToken.charAt(0);
        if (sign == plus || sign == minus) {
            long millisec = Long.parseLong(dateTimeToken.substring(1, 5)) * 31536000000L + Long.parseLong(dateTimeToken.substring(5, 7)) * 2592000000L + Long.parseLong(dateTimeToken.substring(7, 9)) * 86400000L + Long.parseLong(dateTimeToken.substring(10, 12)) * 3600000L + Long.parseLong(dateTimeToken.substring(12, 14)) * 60000L + Long.parseLong(dateTimeToken.substring(14, 16)) * 1000L;
            System.out.println("sign=" + sign + " millisec=" + millisec);
            System.out.println("31536000000 2592000000 86400000 3600000");
            System.out.println("currentTime=" + System.currentTimeMillis());
            millisec = System.currentTimeMillis() + (sign == plus ? millisec : -millisec);
            return new Date(millisec);
        }
        if (dateTimeToken.endsWith(z)) {
            return ISO8601.parseutcDateFormat(dateTimeToken);
        }
        return ISO8601.parselocalDateFormat(dateTimeToken);
    }

    public static synchronized String toString(Date d, boolean useUTCtime) {
        if (useUTCtime) {
            return ISO8601.formatutcDate(d);
        }
        return ISO8601.formatlocalDate(d);
    }

    public static String toString(Date d) {
        return ISO8601.toString(d, true);
    }

    public static String toRelativeTimeString(long millisec) {
        StringBuffer str = new StringBuffer();
        if (millisec > 0L) {
            str.append(plus);
        } else {
            str.append(minus);
            millisec = -millisec;
        }
        long tmp = millisec / 1000L;
        long msec = millisec - tmp * 1000L;
        millisec = tmp;
        tmp = millisec / 60L;
        long sec = millisec - tmp * 60L;
        millisec = tmp;
        tmp = millisec / 60L;
        long min2 = millisec - tmp * 60L;
        millisec = tmp;
        tmp = millisec / 24L;
        long h = millisec - tmp * 24L;
        millisec = tmp;
        tmp = millisec / 30L;
        long day = millisec - tmp * 30L;
        millisec = tmp;
        tmp = millisec / 12L;
        long mon = millisec - tmp * 12L;
        long year = millisec = tmp;
        str.append(ISO8601.zeroPaddingNumber(year, 4));
        str.append(ISO8601.zeroPaddingNumber(mon, 2));
        str.append(ISO8601.zeroPaddingNumber(day, 2));
        str.append(t);
        str.append(ISO8601.zeroPaddingNumber(h, 2));
        str.append(ISO8601.zeroPaddingNumber(min2, 2));
        str.append(ISO8601.zeroPaddingNumber(sec, 2));
        str.append(ISO8601.zeroPaddingNumber(msec, 3));
        return str.toString();
    }

    private static String zeroPaddingNumber(long value, int digits) {
        String s = Long.toString(value);
        int n = digits - s.length();
        for (int i = 0; i < n; ++i) {
            s = "0" + s;
        }
        return s;
    }

    public static void main(String[] argv) {
        System.out.println(localCal);
        System.out.println("USAGE: java ISO8601 DateTimetoken");
        System.out.println(argv[0]);
        try {
            System.out.println("Testing default behaviour (using UTC DateTime):");
            System.out.println("  ISO8601.toDate(" + argv[0] + ") returns:" + ISO8601.toDate(argv[0]));
            System.out.println("  converting that back to a string gives:" + ISO8601.toString(ISO8601.toDate(argv[0])));
            Date d1 = new Date();
            System.out.println("  ISO8601.toString( new Date() ) returns:" + ISO8601.toString(d1));
            System.out.println("  converting that back to a date gives:" + ISO8601.toDate(ISO8601.toString(d1)));
            System.out.println("Testing local time (for backwards compatability):");
            System.out.println("  ISO8601.toDate(" + argv[0] + ") returns:" + ISO8601.toDate(argv[0]));
            System.out.println("  converting that back to a string gives:" + ISO8601.toString(ISO8601.toDate(argv[0]), false));
            System.out.println("  ISO8601.toString( new Date(), false ) returns:" + ISO8601.toString(d1, false));
            System.out.println("  converting that back to a date gives:" + ISO8601.toDate(ISO8601.toString(d1, false)));
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        try {
            System.out.println("ISO8601.toRelativeTimeString(" + argv[0] + ") returns:" + ISO8601.toRelativeTimeString(Long.parseLong(argv[0])));
            Date d = new Date(Integer.parseInt(argv[0]));
            System.out.println("ISO8601.toString(" + d + ", false) returns:" + ISO8601.toString(d, false));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

