/*
 * Decompiled with CFR 0.152.
 */
package jade.lang.acl;

import jade.core.AID;
import jade.lang.acl.ACLMessage;
import jade.lang.acl.ACLParserConstants;
import jade.lang.acl.ACLParserTokenManager;
import jade.lang.acl.ISO8601;
import jade.lang.acl.ParseException;
import jade.lang.acl.SimpleCharStream;
import jade.lang.acl.Token;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.Vector;

public class ACLParser
implements ACLParserConstants {
    ACLMessage msg = new ACLMessage(10);
    public ACLParserTokenManager token_source;
    SimpleCharStream jj_input_stream;
    public Token token;
    public Token jj_nt;
    private int jj_ntk;
    private int jj_gen;
    private final int[] jj_la1 = new int[14];
    private static int[] jj_la1_0;
    private static int[] jj_la1_1;
    private Vector jj_expentries = new Vector();
    private int[] jj_expentry;
    private int jj_kind = -1;

    public static void main(String[] args) throws ParseException {
        ACLParser parser = new ACLParser(System.in);
        while (true) {
            try {
                while (true) {
                    ACLMessage result = parser.Message();
                    System.out.println(result);
                }
            }
            catch (ParseException pe) {
                pe.printStackTrace();
                System.exit(1);
                continue;
            }
            break;
        }
    }

    public static ACLParser create() {
        StringReader r = new StringReader("");
        return new ACLParser(r);
    }

    public ACLMessage parse(Reader text) throws ParseException {
        this.ReInit(text);
        return this.Message();
    }

    public AID parseAID(Reader text) throws ParseException {
        if (text != null) {
            this.ReInit(text);
        }
        this.token_source.SwitchTo(4);
        AID result = this.AgentIdentifier();
        this.token_source.SwitchTo(0);
        return result;
    }

    private String trimQuotes(String s) throws ParseException {
        if ((s = s.trim()).startsWith("\"") && s.endsWith("\"")) {
            s = s.substring(1, s.length() - 1);
        }
        return this.unescape(s);
    }

    private String unescape(String s) throws ParseException {
        int i;
        StringBuffer result = new StringBuffer(s.length());
        for (i = 0; i < s.length() - 1; ++i) {
            if (s.charAt(i) == '\\' && s.charAt(i + 1) == '\"') {
                result.append("\"");
                ++i;
                continue;
            }
            result.append(s.charAt(i));
        }
        if (i < s.length()) {
            result.append(s.charAt(s.length() - 1));
        }
        return result.toString();
    }

    public final ACLMessage Message() throws ParseException {
        this.msg.reset();
        this.jj_consume_token(5);
        this.MessageType();
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 20: 
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 26: 
                case 27: {
                    break;
                }
                default: {
                    this.jj_la1[0] = this.jj_gen;
                    break block3;
                }
            }
            this.MessageParameter();
        }
        this.jj_consume_token(28);
        return this.msg;
    }

    public final void MessageType() throws ParseException {
        Token t = this.jj_consume_token(10);
        this.msg.setPerformative(ACLMessage.getInteger(t.image));
    }

    public final void MessageParameter() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 15: {
                this.jj_consume_token(15);
                AID aid = this.AgentIdentifier();
                this.msg.setSender(aid);
                this.token_source.SwitchTo(2);
                break;
            }
            case 16: {
                this.jj_consume_token(16);
                this.msg.clearAllReceiver();
                this.jj_consume_token(55);
                this.jj_consume_token(47);
                block23: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 55: {
                            break;
                        }
                        default: {
                            this.jj_la1[1] = this.jj_gen;
                            break block23;
                        }
                    }
                    AID aid = this.AgentIdentifier();
                    this.msg.addReceiver(aid);
                }
                this.jj_consume_token(54);
                this.token_source.SwitchTo(2);
                break;
            }
            case 17: {
                this.jj_consume_token(17);
                String s = this.Content();
                this.msg.setContent(s);
                this.token_source.SwitchTo(2);
                break;
            }
            case 18: {
                this.jj_consume_token(18);
                String s = this.Expression();
                this.msg.setReplyWith(s);
                this.token_source.SwitchTo(2);
                break;
            }
            case 19: {
                this.jj_consume_token(19);
                String s = this.DateTimeToken();
                try {
                    this.msg.setReplyByDate(ISO8601.toDate(s));
                }
                catch (Exception e2) {
                    // empty catch block
                }
                this.token_source.SwitchTo(2);
                break;
            }
            case 20: {
                this.jj_consume_token(20);
                String s = this.Expression();
                this.msg.setInReplyTo(s);
                this.token_source.SwitchTo(2);
                break;
            }
            case 21: {
                this.jj_consume_token(21);
                this.msg.clearAllReplyTo();
                this.jj_consume_token(55);
                this.jj_consume_token(47);
                block24: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 55: {
                            break;
                        }
                        default: {
                            this.jj_la1[2] = this.jj_gen;
                            break block24;
                        }
                    }
                    AID aid = this.AgentIdentifier();
                    this.msg.addReplyTo(aid);
                }
                this.jj_consume_token(54);
                this.token_source.SwitchTo(2);
                break;
            }
            case 22: {
                this.jj_consume_token(22);
                String s = this.Expression();
                this.msg.setEncoding(s);
                this.token_source.SwitchTo(2);
                break;
            }
            case 23: {
                this.jj_consume_token(23);
                String s = this.Expression();
                this.msg.setLanguage(s);
                this.token_source.SwitchTo(2);
                break;
            }
            case 24: {
                this.jj_consume_token(24);
                String s = this.Expression();
                this.msg.setOntology(s);
                this.token_source.SwitchTo(2);
                break;
            }
            case 25: {
                this.jj_consume_token(25);
                String s = this.Word();
                this.msg.setProtocol(s);
                this.token_source.SwitchTo(2);
                break;
            }
            case 26: {
                this.jj_consume_token(26);
                String s = this.Expression();
                this.msg.setConversationId(s);
                this.token_source.SwitchTo(2);
                break;
            }
            case 27: {
                Token t = this.jj_consume_token(27);
                String s = this.Expression();
                this.msg.addUserDefinedParameter(t.image.substring(3), s);
                this.token_source.SwitchTo(2);
                break;
            }
            default: {
                this.jj_la1[3] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final String Content() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 35: 
            case 40: {
                String s = this.Stringa();
                return s;
            }
            case 34: {
                String s = this.Word();
                return s;
            }
        }
        this.jj_la1[4] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final AID AgentIdentifier() throws ParseException {
        AID cur = new AID();
        this.jj_consume_token(55);
        this.jj_consume_token(49);
        block15: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 50: {
                    this.jj_consume_token(50);
                    String s = this.Content();
                    cur.setName(s);
                    this.token_source.SwitchTo(4);
                    break;
                }
                case 51: {
                    String s;
                    this.jj_consume_token(51);
                    this.jj_consume_token(55);
                    this.jj_consume_token(48);
                    this.token_source.SwitchTo(3);
                    block16: while (true) {
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 34: {
                                break;
                            }
                            default: {
                                this.jj_la1[5] = this.jj_gen;
                                break block16;
                            }
                        }
                        s = this.Word();
                        cur.addAddresses(s);
                    }
                    this.jj_consume_token(41);
                    this.token_source.SwitchTo(4);
                    break;
                }
                case 52: {
                    this.jj_consume_token(52);
                    this.jj_consume_token(55);
                    this.jj_consume_token(48);
                    block17: while (true) {
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 55: {
                                break;
                            }
                            default: {
                                this.jj_la1[6] = this.jj_gen;
                                break block17;
                            }
                        }
                        AID aid = this.AgentIdentifier();
                        cur.addResolvers(aid);
                    }
                    this.jj_consume_token(54);
                    this.token_source.SwitchTo(4);
                    break;
                }
                case 53: {
                    Token t = this.jj_consume_token(53);
                    String s = this.Expression();
                    cur.addUserDefinedSlot(t.image.substring(3), s);
                    this.token_source.SwitchTo(4);
                    break;
                }
                default: {
                    this.jj_la1[7] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 50: 
                case 51: 
                case 52: 
                case 53: {
                    continue block15;
                }
            }
            break;
        }
        this.jj_la1[8] = this.jj_gen;
        this.jj_consume_token(54);
        return cur;
    }

    public final String Expression() throws ParseException {
        String s1 = new String();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 34: {
                String s = this.Word();
                return s;
            }
            case 35: 
            case 40: {
                String s = this.Stringa();
                return s;
            }
            case 36: 
            case 37: 
            case 38: 
            case 39: {
                String s = this.Number();
                return s;
            }
            case 33: {
                String s = this.DateTimeToken();
                return s;
            }
            case 42: {
                this.jj_consume_token(42);
                block10: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 33: 
                        case 34: 
                        case 35: 
                        case 36: 
                        case 37: 
                        case 38: 
                        case 39: 
                        case 40: 
                        case 42: {
                            break;
                        }
                        default: {
                            this.jj_la1[9] = this.jj_gen;
                            break block10;
                        }
                    }
                    String s = this.Expression();
                    s1 = s1 + s + " ";
                }
                this.jj_consume_token(41);
                return "(" + s1 + ")";
            }
        }
        this.jj_la1[10] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final String Word() throws ParseException {
        Token t = this.jj_consume_token(34);
        return this.trimQuotes(t.image);
    }

    public final String Stringa() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 35: {
                String s = this.StringLiteral();
                return s;
            }
            case 40: {
                String s = this.ByteLengthEncodedString();
                return s;
            }
        }
        this.jj_la1[11] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final String StringLiteral() throws ParseException {
        Token t = this.jj_consume_token(35);
        return this.trimQuotes(t.image);
    }

    public final String ByteLengthEncodedString() throws ParseException {
        Token t = this.jj_consume_token(40);
        return t.image;
    }

    public final String Number() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 36: {
                String s = this.Digit();
                return s;
            }
            case 37: {
                String s = this.Integer();
                return s;
            }
            case 38: 
            case 39: {
                String s = this.Float();
                return s;
            }
        }
        this.jj_la1[12] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final String DateTimeToken() throws ParseException {
        Token t = this.jj_consume_token(33);
        return t.image;
    }

    public final String Digit() throws ParseException {
        Token t = this.jj_consume_token(36);
        return t.image;
    }

    public final String Integer() throws ParseException {
        String s = new String();
        Token t = this.jj_consume_token(37);
        return t.image;
    }

    public final String Float() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 38: {
                Token t = this.jj_consume_token(38);
                return t.image;
            }
            case 39: {
                Token t = this.jj_consume_token(39);
                return t.image;
            }
        }
        this.jj_la1[13] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    private static void jj_la1_0() {
        jj_la1_0 = new int[]{0xFFF8000, 0, 0, 0xFFF8000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    }

    private static void jj_la1_1() {
        jj_la1_1 = new int[]{0, 0x800000, 0x800000, 0, 268, 4, 0x800000, 0x3C0000, 0x3C0000, 1534, 1534, 264, 240, 192};
    }

    public ACLParser(InputStream stream) {
        this.jj_input_stream = new SimpleCharStream(stream, 1, 1);
        this.token_source = new ACLParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 14; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public void ReInit(InputStream stream) {
        this.jj_input_stream.ReInit(stream, 1, 1);
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 14; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public ACLParser(Reader stream) {
        this.jj_input_stream = new SimpleCharStream(stream, 1, 1);
        this.token_source = new ACLParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 14; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public void ReInit(Reader stream) {
        this.jj_input_stream.ReInit(stream, 1, 1);
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 14; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public ACLParser(ACLParserTokenManager tm) {
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 14; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public void ReInit(ACLParserTokenManager tm) {
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 14; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    private final Token jj_consume_token(int kind) throws ParseException {
        Token oldToken = this.token;
        this.token = oldToken.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == kind) {
            ++this.jj_gen;
            return this.token;
        }
        this.token = oldToken;
        this.jj_kind = kind;
        throw this.generateParseException();
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        ++this.jj_gen;
        return this.token;
    }

    public final Token getToken(int index) {
        Token t = this.token;
        for (int i = 0; i < index; ++i) {
            t = t.next != null ? t.next : (t.next = this.token_source.getNextToken());
        }
        return t;
    }

    private final int jj_ntk() {
        this.jj_nt = this.token.next;
        if (this.jj_nt == null) {
            this.token.next = this.token_source.getNextToken();
            this.jj_ntk = this.token.next.kind;
            return this.jj_ntk;
        }
        this.jj_ntk = this.jj_nt.kind;
        return this.jj_ntk;
    }

    public ParseException generateParseException() {
        int i;
        this.jj_expentries.removeAllElements();
        boolean[] la1tokens = new boolean[56];
        for (i = 0; i < 56; ++i) {
            la1tokens[i] = false;
        }
        if (this.jj_kind >= 0) {
            la1tokens[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        for (i = 0; i < 14; ++i) {
            if (this.jj_la1[i] != this.jj_gen) continue;
            for (int j = 0; j < 32; ++j) {
                if ((jj_la1_0[i] & 1 << j) != 0) {
                    la1tokens[j] = true;
                }
                if ((jj_la1_1[i] & 1 << j) == 0) continue;
                la1tokens[32 + j] = true;
            }
        }
        for (i = 0; i < 56; ++i) {
            if (!la1tokens[i]) continue;
            this.jj_expentry = new int[1];
            this.jj_expentry[0] = i;
            this.jj_expentries.addElement(this.jj_expentry);
        }
        int[][] exptokseq = new int[this.jj_expentries.size()][];
        for (int i2 = 0; i2 < this.jj_expentries.size(); ++i2) {
            exptokseq[i2] = (int[])this.jj_expentries.elementAt(i2);
        }
        return new ParseException(this.token, exptokseq, tokenImage);
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }

    static {
        ACLParser.jj_la1_0();
        ACLParser.jj_la1_1();
    }
}

