/*
 * Decompiled with CFR 0.152.
 */
package jade.imtp.leap.sms;

import jade.imtp.leap.ICPException;
import jade.imtp.leap.JICP.Connection;
import jade.imtp.leap.JICP.JICPMediatorManager;
import jade.imtp.leap.JICP.JICPPacket;
import jade.imtp.leap.nio.NIOBEDispatcher;
import jade.imtp.leap.sms.SMSManager;
import jade.util.Logger;
import jade.util.leap.Properties;
import java.net.InetAddress;

public class SMSBEDispatcher
extends NIOBEDispatcher {
    private SMSManager theSMSManager;
    private int smsPort;
    private String msisdn;
    private Logger myLogger = Logger.getMyLogger(this.getClass().getName());

    public void init(JICPMediatorManager mgr, String id, Properties props) throws ICPException {
        this.msisdn = props.getProperty("msisdn");
        if (this.msisdn == null) {
            throw new ICPException("Missing MSISDN");
        }
        this.theSMSManager = SMSManager.getInstance(props);
        if (this.theSMSManager == null) {
            throw new ICPException("Cannot connect to the SMSManager");
        }
        super.init(mgr, id, props);
    }

    protected void handleDropDown(Connection c, JICPPacket pkt, InetAddress addr, int port) {
        super.handleDropDown(c, pkt, addr, port);
        try {
            String portStr = new String(pkt.getData());
            this.smsPort = Integer.parseInt(portStr);
            this.myLogger.log(Logger.CONFIG, "OUT-of-bound notification param: msisdn=" + this.msisdn + " port=" + this.smsPort);
        }
        catch (Exception e2) {
            this.myLogger.log(Logger.SEVERE, "Cannot get FE port for OUT-of-bound notifications via SMS!!!!!!! " + e2);
            e2.printStackTrace();
        }
    }

    protected void requestRefresh() {
        if (this.msisdn.startsWith("39")) {
            this.msisdn = "+" + this.msisdn;
        }
        this.theSMSManager.sendTextMessage(this.msisdn, this.smsPort, null);
    }
}

