/*
 * Decompiled with CFR 0.152.
 */
package jade.imtp.leap.http;

import jade.core.CaseInsensitiveString;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Enumeration;
import java.util.Hashtable;

public class HTTPPacket {
    private static final CaseInsensitiveString CONTENT_LENGTH_KEY = new CaseInsensitiveString("content-length");
    private static final int CR = 13;
    private static final int LF = 10;
    private static final String DELIMITER = new String(new byte[]{13, 10});
    protected String firstLine = null;
    protected String httpType = null;
    protected Hashtable fields = new Hashtable();
    protected byte[] payload = null;

    protected HTTPPacket() {
    }

    public String getHttpType() {
        return this.httpType;
    }

    public String getField(String key) {
        return (String)this.fields.get(new CaseInsensitiveString(key));
    }

    public byte[] getPayload() {
        return this.payload;
    }

    public void setHttpType(String type) {
        this.httpType = type;
    }

    public void setField(String key, String value) {
        if (value != null) {
            this.fields.put(new CaseInsensitiveString(key), value);
        } else {
            this.fields.remove(new CaseInsensitiveString(key));
        }
    }

    public void setPayload(byte[] p) {
        this.payload = p;
        if (this.payload != null) {
            this.fields.put(CONTENT_LENGTH_KEY, String.valueOf(this.payload.length));
        } else {
            this.fields.remove(CONTENT_LENGTH_KEY);
        }
    }

    public void setPayload(byte[] bb, int first, int length2) {
        this.payload = new byte[length2];
        System.arraycopy(bb, first, this.payload, 0, length2);
        this.fields.put(CONTENT_LENGTH_KEY, String.valueOf(this.payload.length));
    }

    protected void readFrom(InputStream is) throws IOException {
        String line;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        int[] bb = new int[]{0, 0, 0};
        int pos = 0;
        do {
            bb[pos] = is.read();
            if (bb[pos] == -1) {
                throw new EOFException("Unexpected EOF");
            }
            baos.write(bb[pos++]);
            if (pos < 3) continue;
            pos = 0;
        } while (!HTTPPacket.endOfHeader(bb, pos));
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        BufferedReader inpReader = new BufferedReader(new InputStreamReader(bais));
        this.firstLine = inpReader.readLine();
        while ((line = inpReader.readLine()) != null && line.length() != 0) {
            try {
                int colonIndex = line.indexOf(58);
                String key = line.substring(0, colonIndex);
                String value = line.substring(colonIndex + 1, line.length()).trim();
                this.setField(key, value);
            }
            catch (Exception e2) {
                throw new IOException("Header field format error. " + e2);
            }
        }
        try {
            int k;
            int length2 = Integer.parseInt((String)this.fields.get(CONTENT_LENGTH_KEY));
            this.payload = new byte[length2];
            for (int n = 0; n < length2; n += k) {
                k = is.read(this.payload, n, length2 - n);
                if (k >= 0) continue;
                throw new EOFException(String.valueOf(n));
            }
        }
        catch (IOException ioe) {
            throw ioe;
        }
        catch (Exception e3) {
            this.payload = null;
        }
    }

    private static final boolean endOfHeader(int[] bb, int pos) {
        if (bb[pos] == 10) {
            if (++pos >= 3) {
                pos = 0;
            }
            if (bb[pos] == 13) {
                if (++pos >= 3) {
                    pos = 0;
                }
                return bb[pos] == 10;
            }
        }
        return false;
    }

    protected void writeTo(OutputStream os) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        BufferedWriter outWriter = new BufferedWriter(new OutputStreamWriter(baos));
        outWriter.write(this.firstLine);
        outWriter.write(DELIMITER);
        Enumeration e2 = this.fields.keys();
        while (e2.hasMoreElements()) {
            CaseInsensitiveString key = (CaseInsensitiveString)e2.nextElement();
            String value = (String)this.fields.get(key);
            outWriter.write(key.toString() + ": " + value);
            outWriter.write(DELIMITER);
        }
        outWriter.write(DELIMITER);
        outWriter.flush();
        if (this.payload != null) {
            baos.write(this.payload);
        }
        os.write(baos.toByteArray());
        os.flush();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        Enumeration e2 = this.fields.keys();
        while (e2.hasMoreElements()) {
            CaseInsensitiveString key = (CaseInsensitiveString)e2.nextElement();
            String value = (String)this.fields.get(key);
            sb.append(key.toString() + "=" + value);
            sb.append("\n");
        }
        if (this.payload != null) {
            sb.append("-------------\nPayload size: " + this.payload.length + "\n");
        }
        return sb.toString();
    }
}

